/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.ToolDescriptor;
import org.apache.jetspeed.om.registry.base.BaseCachedParameter;
import org.apache.jetspeed.om.registry.base.BaseMediaType;
import org.apache.jetspeed.om.registry.base.BaseParameter;
import org.apache.jetspeed.om.registry.base.BaseRegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseToolDescriptor;

public abstract class BasePortletInfoEntry
extends BaseRegistryEntry {
    protected String classname;
    protected Vector parameter = new Vector();
    protected transient Map nameIdx = null;
    protected Vector medias = new Vector();
    protected transient Map mediasIdx = null;
    protected Vector tools = new Vector();
    protected transient Map toolsIdx = null;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        BasePortletInfoEntry obj = (BasePortletInfoEntry)object;
        if (this.classname != null ? !this.classname.equals(obj.getClassname()) : obj.getClassname() != null) {
            return false;
        }
        Iterator i = this.parameter.iterator();
        Iterator i2 = obj.getParameters().iterator();
        while (i.hasNext()) {
            BaseParameter p1 = (BaseParameter)i.next();
            BaseParameter p2 = null;
            if (!i2.hasNext()) {
                return false;
            }
            p2 = (BaseParameter)i2.next();
            if (p1.equals(p2)) continue;
            return false;
        }
        if (i2.hasNext()) {
            return false;
        }
        i = this.medias.iterator();
        i2 = obj.getMediaTypes().iterator();
        while (i.hasNext()) {
            BaseMediaType m1 = (BaseMediaType)i.next();
            BaseMediaType m2 = null;
            if (!i2.hasNext()) {
                return false;
            }
            m2 = (BaseMediaType)i2.next();
            if (m1.equals(m2)) continue;
            return false;
        }
        if (i2.hasNext()) {
            return false;
        }
        i = this.tools.iterator();
        i2 = obj.getTools().iterator();
        while (i.hasNext()) {
            BaseToolDescriptor t1 = (BaseToolDescriptor)i.next();
            BaseToolDescriptor t2 = null;
            if (!i2.hasNext()) {
                return false;
            }
            t2 = (BaseToolDescriptor)i2.next();
            if (t1.equals(t2)) continue;
            return false;
        }
        if (i2.hasNext()) {
            return false;
        }
        return super.equals(object);
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getParameterNames() {
        Vector vector = this.parameter;
        synchronized (vector) {
            if (this.nameIdx == null) {
                this.buildNameIndex();
            }
        }
        return this.nameIdx.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter getParameter(String name) {
        Integer pos;
        Vector vector = this.parameter;
        synchronized (vector) {
            if (this.nameIdx == null) {
                this.buildNameIndex();
            }
        }
        if (name != null && (pos = (Integer)this.nameIdx.get(name)) != null) {
            return (Parameter)this.parameter.elementAt(pos);
        }
        return null;
    }

    public Map getParameterMap() {
        Hashtable<String, String> params = new Hashtable<String, String>();
        Enumeration en = this.parameter.elements();
        while (en.hasMoreElements()) {
            Parameter param = (Parameter)en.nextElement();
            String key = param.getName();
            String value = param.getValue();
            if (key == null || value == null) continue;
            params.put(key, value);
        }
        return params;
    }

    public void addParameter(String name, String value) {
        if (name != null) {
            Parameter p = this.getParameter(name);
            if (p == null) {
                p = this instanceof PortletEntry ? new BaseCachedParameter() : new BaseParameter();
                p.setName(name);
            }
            p.setValue(value);
            this.addParameter(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(Parameter param) {
        Vector vector = this.parameter;
        synchronized (vector) {
            if (this.parameter == null) {
                this.parameter = new Vector();
            }
            if (this.nameIdx == null) {
                this.buildNameIndex();
            }
            this.parameter.addElement(param);
            this.nameIdx.put(param.getName(), new Integer(this.parameter.size() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameter(String name) {
        if (name == null) {
            return;
        }
        Vector vector = this.parameter;
        synchronized (vector) {
            Iterator i = this.parameter.iterator();
            while (i.hasNext()) {
                Parameter param = (Parameter)i.next();
                if (!param.getName().equals(name)) continue;
                i.remove();
            }
            this.buildNameIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listMediaTypes() {
        if (this.mediasIdx == null) {
            Vector vector = this.medias;
            synchronized (vector) {
                this.buildMediasIndex();
            }
        }
        return this.mediasIdx.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMediaType(String name) {
        if (this.mediasIdx == null) {
            Vector vector = this.medias;
            synchronized (vector) {
                this.buildMediasIndex();
            }
        }
        return name != null && this.mediasIdx.get(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaType(String name) {
        if (name != null) {
            Vector vector = this.medias;
            synchronized (vector) {
                if (this.mediasIdx == null) {
                    this.buildMediasIndex();
                }
                BaseMediaType m = new BaseMediaType();
                m.setRef(name);
                this.mediasIdx.put(name, new Integer(this.medias.size()));
                this.medias.add(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaType(String name) {
        if (name != null) {
            Vector vector = this.medias;
            synchronized (vector) {
                this.mediasIdx.remove(name);
                BaseMediaType m = new BaseMediaType();
                m.setRef(name);
                Iterator i = this.medias.iterator();
                while (i.hasNext()) {
                    if (!i.next().equals(m)) continue;
                    i.remove();
                    return;
                }
            }
        }
    }

    public Vector getParameters() {
        return this.parameter;
    }

    public void setParameters(Vector parameters) {
        this.parameter = parameters;
    }

    public void setMediaTypes(Vector mediaTypes) {
        this.medias = mediaTypes;
    }

    public Vector getMediaTypes() {
        return this.medias;
    }

    public Vector getTools() {
        return this.tools;
    }

    public void setTools(Vector tools) {
        this.tools = tools;
    }

    protected void buildNameIndex() {
        Hashtable<String, Integer> idx = new Hashtable<String, Integer>();
        Iterator i = this.parameter.iterator();
        int count = 0;
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            idx.put(p.getName(), new Integer(count));
            ++count;
        }
        this.nameIdx = idx;
    }

    private void buildMediasIndex() {
        Hashtable<String, Integer> idx = new Hashtable<String, Integer>();
        Iterator i = this.medias.iterator();
        int count = 0;
        while (i.hasNext()) {
            BaseMediaType b = (BaseMediaType)i.next();
            idx.put(b.getRef(), new Integer(count));
            ++count;
        }
        this.mediasIdx = idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getToolNames() {
        Vector vector = this.tools;
        synchronized (vector) {
            if (this.toolsIdx == null) {
                this.buildToolsIndex();
            }
        }
        return this.toolsIdx.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToolDescriptor getTool(String name) {
        Integer pos;
        Vector vector = this.tools;
        synchronized (vector) {
            if (this.toolsIdx == null) {
                this.buildToolsIndex();
            }
        }
        if (name != null && (pos = (Integer)this.toolsIdx.get(name)) != null) {
            return (ToolDescriptor)this.tools.elementAt(pos);
        }
        return null;
    }

    public Map getToolMap() {
        Hashtable<String, ToolDescriptor> map = new Hashtable<String, ToolDescriptor>();
        Enumeration en = this.tools.elements();
        while (en.hasMoreElements()) {
            ToolDescriptor desc = (ToolDescriptor)en.nextElement();
            map.put(desc.getName(), desc);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTool(ToolDescriptor tool) {
        Vector vector = this.tools;
        synchronized (vector) {
            if (this.tools == null) {
                this.tools = new Vector();
            }
            if (this.toolsIdx == null) {
                this.buildToolsIndex();
            }
            this.tools.addElement(tool);
            this.toolsIdx.put(tool.getName(), new Integer(this.tools.size() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTool(String name) {
        if (name == null) {
            return;
        }
        Vector vector = this.tools;
        synchronized (vector) {
            Iterator i = this.tools.iterator();
            while (i.hasNext()) {
                ToolDescriptor tool = (ToolDescriptor)i.next();
                if (!tool.getName().equals(name)) continue;
                i.remove();
            }
            this.buildToolsIndex();
        }
    }

    private void buildToolsIndex() {
        Hashtable<String, Integer> idx = new Hashtable<String, Integer>();
        Iterator i = this.tools.iterator();
        int count = 0;
        while (i.hasNext()) {
            ToolDescriptor b = (ToolDescriptor)i.next();
            idx.put(b.getName(), new Integer(count));
            ++count;
        }
        this.toolsIdx = idx;
    }
}

