/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.security;

import org.apache.jetspeed.om.security.BaseJetspeedGroup;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.services.security.GroupException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class JetspeedGroupFactory {
    private static final String CONFIG_GROUP_CLASSNAME = "group.class";
    private static String groupClassName = null;
    private static Class groupClass = null;

    public static Group getInstance() throws GroupException {
        return JetspeedGroupFactory.getInstance(true);
    }

    public static Group getInstance(boolean isNew) throws GroupException {
        Group group = null;
        if (null == groupClassName) {
            try {
                ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
                groupClassName = serviceConf.getString(CONFIG_GROUP_CLASSNAME);
                groupClass = Class.forName(groupClassName);
            }
            catch (Exception e) {
                throw new GroupException("GroupFactory: Failed to create a Class object for Group implementation: " + e.toString());
            }
        }
        try {
            group = (Group)groupClass.newInstance();
            if (group instanceof BaseJetspeedGroup) {
                ((BaseJetspeedGroup)group).setNew(isNew);
            }
        }
        catch (Exception e) {
            throw new GroupException("Failed instantiate an Group implementation object: " + e.toString());
        }
        return group;
    }
}

