/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.security;

import org.apache.jetspeed.om.security.BaseJetspeedPermission;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.services.security.PermissionException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class JetspeedPermissionFactory {
    private static final String CONFIG_GROUP_CLASSNAME = "permission.class";
    private static String permissionClassName = null;
    private static Class permissionClass = null;

    public static Permission getInstance() throws PermissionException {
        return JetspeedPermissionFactory.getInstance(true);
    }

    public static Permission getInstance(boolean isNew) throws PermissionException {
        Permission permission = null;
        if (null == permissionClassName) {
            try {
                ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
                permissionClassName = serviceConf.getString(CONFIG_GROUP_CLASSNAME);
                permissionClass = Class.forName(permissionClassName);
            }
            catch (Exception e) {
                throw new PermissionException("PermissionFactory: Failed to create a Class object for Permission implementation: " + e.toString());
            }
        }
        try {
            permission = (Permission)permissionClass.newInstance();
            if (permission instanceof BaseJetspeedPermission) {
                ((BaseJetspeedPermission)permission).setNew(isNew);
            }
        }
        catch (Exception e) {
            throw new PermissionException("Failed instantiate an Permission implementation object: " + e.toString());
        }
        return permission;
    }
}

