/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.BasePortletConfig;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.persistence.PortalPersistenceException;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.util.MetaData;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.util.RunData;

public class BasePortletSet
implements PortletSet,
Portlet,
PortletState {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BasePortletSet.class.getName());
    private boolean dirty = false;
    private PortletConfig pc = null;
    private String name = null;
    private Vector portlets = new Vector();
    private PortletController controller = null;
    private long creationTime;
    private String info;
    private String id = null;

    public BasePortletSet() {
        try {
            this.init();
        }
        catch (PortletException e) {
            logger.error("Exception", e);
        }
    }

    public BasePortletSet(PortletController controller) {
        this.setController(controller);
    }

    public void init() throws PortletException {
        if (this.getPortletConfig() == null) {
            this.setPortletConfig(new BasePortletConfig());
        }
    }

    public int size() {
        return this.portlets.size();
    }

    public Portlet[] toArray() {
        this.sortPortletSet();
        Object[] p = new Portlet[this.portlets.size()];
        this.portlets.copyInto(p);
        return p;
    }

    public Portlet getPortletAt(int pos) {
        this.sortPortletSet();
        return (Portlet)this.portlets.elementAt(pos);
    }

    public Portlet getPortletByID(String id) {
        if (this.portlets == null) {
            return null;
        }
        Portlet portlet = null;
        for (int ix = 0; ix < this.portlets.size(); ++ix) {
            portlet = (Portlet)this.portlets.elementAt(ix);
            if (!portlet.getID().equals(id)) continue;
            return portlet;
        }
        return null;
    }

    public Portlet getPortletByName(String name) {
        if (this.portlets == null) {
            return null;
        }
        Portlet portlet = null;
        for (int ix = 0; ix < this.portlets.size(); ++ix) {
            portlet = (Portlet)this.portlets.elementAt(ix);
            if (!portlet.getName().equals(name)) continue;
            return portlet;
        }
        return null;
    }

    public Enumeration getPortlets() {
        this.sortPortletSet();
        return this.portlets.elements();
    }

    public void addPortlet(Portlet portlet) {
        this.addPortlet(portlet, null, -1);
    }

    public void addPortlet(Portlet portlet, int position) {
        this.addPortlet(portlet, null, position);
    }

    public void addPortlet(Portlet portlet, PortletSet.Constraints constraints) {
        this.addPortlet(portlet, constraints, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortlet(Portlet portlet, PortletSet.Constraints constraints, int position) {
        Vector vector = this.portlets;
        synchronized (vector) {
            this.portlets.addElement(portlet);
            PortletConfig pc = portlet.getPortletConfig();
            if (pc != null) {
                pc.setPortletSet(this);
                if (constraints != null) {
                    pc.setConstraints(constraints);
                }
                if (position >= 0) {
                    pc.setPosition(position);
                    if (position < this.portlets.size() - 1) {
                        this.dirty = true;
                    }
                }
            }
        }
    }

    public PortletController getController() {
        return this.controller;
    }

    public synchronized void setController(PortletController controller) {
        this.controller = controller;
        controller.setPortlets(this);
    }

    public ConcreteElement getContent(RunData rundata) {
        ConcreteElement content = null;
        PortletController controller = this.getController();
        PortalResource portalResource = new PortalResource(this);
        try {
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
            portalResource.setOwner(jsLink.getUserName());
            JetspeedLinkFactory.putInstance(jsLink);
        }
        catch (Exception e) {
            logger.warn(e.toString(), e);
            portalResource.setOwner(null);
        }
        if (!JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), portalResource, "view")) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unauthorized access by user \"" + rundata.getUser().getUserName() + "\"");
            }
            if (this.portlets != null) {
                this.portlets.clear();
            }
            return new StringElement(Localization.getString((RunData)rundata, (String)"SECURITY_NO_ACCESS"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("User \"" + rundata.getUser().getUserName() + "\" is authorized to portlet set " + this.getID());
        }
        if (controller == null) {
            Portlet p = this.getPortletAt(0);
            if (p != null) {
                content = p.getContent(rundata);
            }
        } else {
            content = controller.getContent(rundata);
        }
        if (content == null) {
            content = new ConcreteElement();
        }
        return content;
    }

    public String getName() {
        if (this.name == null) {
            return this.getClass().getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PortletConfig getPortletConfig() {
        return this.pc;
    }

    public void setPortletConfig(PortletConfig pc) {
        this.pc = pc;
    }

    public String getDescription() {
        if (this.getPortletConfig() != null && this.getPortletConfig().getMetainfo() != null) {
            return this.getPortletConfig().getMetainfo().getDescription();
        }
        return null;
    }

    public String getDescription(String instanceDescription) {
        if (instanceDescription != null) {
            return instanceDescription;
        }
        return this.getDescription();
    }

    public void setDescription(String description) {
        MetaData meta;
        PortletConfig pc = this.getPortletConfig();
        if (pc == null) {
            pc = new BasePortletConfig();
            this.setPortletConfig(pc);
        }
        if ((meta = pc.getMetainfo()) == null) {
            meta = new MetaData();
            pc.setMetainfo(meta);
        }
        meta.setDescription(description);
    }

    public void setImage(String instanceImage) {
    }

    public String getImage() {
        if (this.getPortletConfig() != null && this.getPortletConfig().getMetainfo() != null) {
            return this.getPortletConfig().getMetainfo().getImage();
        }
        return null;
    }

    public String getImage(String instanceImage) {
        if (instanceImage != null) {
            return instanceImage;
        }
        return this.getImage();
    }

    public String getTitle() {
        if (this.getPortletConfig() != null && this.getPortletConfig().getMetainfo() != null) {
            return this.getPortletConfig().getMetainfo().getTitle();
        }
        return null;
    }

    public String getTitle(String instanceTitle) {
        if (instanceTitle != null) {
            return instanceTitle;
        }
        return this.getTitle();
    }

    public void setTitle(String title) {
        MetaData meta;
        PortletConfig pc = this.getPortletConfig();
        if (pc == null) {
            pc = new BasePortletConfig();
            this.setPortletConfig(pc);
        }
        if ((meta = pc.getMetainfo()) == null) {
            meta = new MetaData();
            pc.setMetainfo(meta);
        }
        meta.setTitle(title);
    }

    public boolean getAllowEdit(RunData rundata) {
        return true;
    }

    public boolean getAllowView(RunData rundata) {
        return true;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sortPortletSet() {
        if (!this.dirty) {
            return;
        }
        Vector vector = this.portlets;
        synchronized (vector) {
            for (int i = 0; i < this.portlets.size(); ++i) {
                Portlet p = (Portlet)this.portlets.elementAt(i);
                int pos = p.getPortletConfig().getPosition();
                if (pos < 0 || pos == i || pos >= this.portlets.size()) continue;
                this.portlets.removeElementAt(i);
                this.portlets.insertElementAt(p, pos);
            }
            this.dirty = false;
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public boolean supportsType(MimeType mimeType) {
        Enumeration portlets = this.getPortlets();
        while (portlets.hasMoreElements()) {
            Portlet p = (Portlet)portlets.nextElement();
            if (!p.supportsType(mimeType)) continue;
            return true;
        }
        return false;
    }

    public boolean allowClose(RunData rundata) {
        return false;
    }

    public boolean isClosed(RunData data) {
        return false;
    }

    public void setClosed(boolean close, RunData data) {
    }

    public boolean allowInfo(RunData rundata) {
        return false;
    }

    public boolean allowPrintFriendly(RunData rundata) {
        return false;
    }

    public boolean allowCustomize(RunData rundata) {
        PortalResource portalResource = new PortalResource(this);
        try {
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
            portalResource.setOwner(jsLink.getUserName());
            JetspeedLinkFactory.putInstance(jsLink);
        }
        catch (Exception e) {
            logger.warn(e.toString(), e);
            portalResource.setOwner(null);
        }
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        return JetspeedSecurity.checkPermission((JetspeedUser)jdata.getUser(), portalResource, "customize");
    }

    public boolean allowMaximize(RunData rundata) {
        return false;
    }

    public boolean allowMinimize(RunData rundata) {
        return false;
    }

    public boolean isMinimized(RunData rundata) {
        return false;
    }

    public void setMinimized(boolean minimize, RunData rundata) {
    }

    public String getAttribute(String attrName, String attrDefValue, RunData rundata) {
        String attrValue = null;
        PortletInstance instance = PersistenceManager.getInstance((Portlet)this, rundata);
        attrValue = instance.getAttribute(attrName, attrDefValue);
        return attrValue;
    }

    public void setAttribute(String attrName, String attrValue, RunData rundata) {
        try {
            PortletInstance instance = PersistenceManager.getInstance((Portlet)this, rundata);
            instance.setAttribute(attrName, attrValue);
            PersistenceManager.store(instance);
        }
        catch (PortalPersistenceException e) {
            logger.error("Exception while setting attribute " + attrName + " for portlet " + this.getName(), e);
        }
    }

    public PortletInstance getInstance(RunData rundata) {
        return PersistenceManager.getInstance((Portlet)this, rundata);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public boolean providesCustomization() {
        return false;
    }

    public boolean isShowTitleBar(RunData rundata) {
        return true;
    }
}

