/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.expire;

import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.expire.Expire;
import org.apache.jetspeed.portal.expire.NoExpire;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.JetspeedException;

public class ExpireFactory {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ExpireFactory.class.getName());
    public static final String FILE_WATCH_EXPIRE = "org.apache.jetspeed.portal.expire.FileWatchExpire";
    public static final String NO_EXPIRE = "org.apache.jetspeed.portal.expire.NoExpire";
    public static Expire noExpire = new NoExpire();

    public static Expire getExpire(Portlet portlet, String classname) throws JetspeedException {
        if (classname.equals(NO_EXPIRE)) {
            return noExpire;
        }
        try {
            Expire expire = (Expire)Class.forName(classname).newInstance();
            expire.init();
            expire.setPortlet(portlet);
            expire.setExpired(false);
            return expire;
        }
        catch (Throwable t) {
            logger.error("Throwable", t);
            throw new JetspeedException(t.getMessage());
        }
    }
}

