/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.html.A;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.PortletURIManager;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class ApplicationsPortlet
extends AbstractPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ApplicationsPortlet.class.getName());
    private Vector applications = new Vector();

    public void init() throws PortletException {
        PortletConfig config = this.getPortletConfig();
        this.setTitle("Applications");
        this.setDescription("A list of Applications that are installed within Jetspeed");
        logger.info("Jetspeed: initializing the ApplicationsPortlet: BEGIN ");
        Enumeration portlets = Registry.get(Registry.PORTLET).getEntries();
        while (portlets.hasMoreElements()) {
            PortletEntry entry = (PortletEntry)portlets.nextElement();
            if (!entry.isApplication()) continue;
            this.applications.addElement(entry);
        }
        logger.info("Jetspeed: initializing the ApplicationsPortlet: END ");
    }

    public ConcreteElement getContent(RunData data) {
        Table table = new Table();
        Enumeration portlets = this.applications.elements();
        while (portlets.hasMoreElements()) {
            PortletEntry entry = (PortletEntry)portlets.nextElement();
            String url = PortletURIManager.getPortletMaxURI(entry, data).toString();
            Portlet portlet = null;
            try {
                portlet = PortletFactory.getPortlet(entry.getName(), "0");
            }
            catch (PortletException e) {
                continue;
            }
            A anchor = new A(url).addElement(portlet.getTitle());
            table.addElement((Element)new TR().addElement((Element)new TD().addElement((Element)anchor)));
            table.addElement((Element)new TR().addElement((Element)new TD().addElement(portlet.getDescription())));
        }
        return table;
    }

    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return true;
    }
}

