/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.util.Hashtable;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractInstancePortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.StringUtils;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;

public class IFramePortlet
extends AbstractInstancePortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(IFramePortlet.class.getName());
    static final String DEFAULT_NOTSUPP_MSG = "[Your user agent does not support inline frames or is currently configured not to display frames]";
    static final String NO_SOURCE_MSG = "Please customize source for this IFrame";
    static final String DEFAULT_SOURCE = "http://127.0.0.1";
    static final String DEFAULT_WIDTH = null;
    static final String DEFAULT_HEIGHT = null;
    static final String DEFAULT_SCROLLING = "auto";
    static final String DEFAULT_FRAMEBORDER = "1";
    static final String PARAM_SOURCE = "source";
    static final String PARAM_WIDTH = "width";
    static final String PARAM_HEIGHT = "height";
    static final String PARAM_SCROLLING = "scrolling";
    static final String PARAM_FRAMEBORDER = "frameborder";
    static final String PARAM_NAME = "name";
    static final String PARAM_STYLE = "style";
    static final String PARAM_MARGINWIDTH = "marginwidth";
    static final String PARAM_MARGINHEIGHT = "marginheight";
    static final String PARAM_REFRESH = "refresh";
    static final String PARAM_ALIGN = "align";
    static final String WEBAPPROOT = "${webappRoot}";
    private String iSource = "http://127.0.0.1";
    private String iWidth = DEFAULT_WIDTH;
    private String iHeight = DEFAULT_HEIGHT;
    private String iScrolling = "auto";
    private String iFrameBorder = "1";
    private String iMarginWidth = null;
    private String iMarginHeight = null;
    private String iStyle = null;
    private String iName = null;
    private String iRefresh = null;
    private String iAlign = null;

    public void setSource(String source) {
        if (source != null) {
            Hashtable<String, String> parms = new Hashtable<String, String>();
            if (source.indexOf("${") >= 0) {
                parms.putAll(this.getPortletConfig().getInitParameters());
                try {
                    ServerData sd = new ServerData(TurbineServlet.getServerName(), Integer.parseInt(TurbineServlet.getServerPort()), TurbineServlet.getServerScheme(), TurbineServlet.getContextPath(), TurbineServlet.getContextPath());
                    DynamicURI uri = new DynamicURI(sd);
                    parms.put("webappRoot", uri.toString() + "/");
                }
                catch (Exception e) {
                    logger.error("Exception", e);
                }
                parms.put("portlet", this.getName());
            }
            this.iSource = StringUtils.replaceVars(source, parms);
        }
    }

    public void setScrolling(String scrolling) {
        this.iScrolling = scrolling;
    }

    public void setWidth(String width) {
        this.iWidth = width;
    }

    public void setHeight(String height) {
        this.iHeight = height;
    }

    public void setFrameBorder(String frameBorder) {
        this.iFrameBorder = frameBorder;
    }

    public void setMarginWidth(String width) {
        this.iMarginWidth = width;
    }

    public void setMarginHeight(String height) {
        this.iMarginHeight = height;
    }

    public void setAlign(String value) {
        this.iAlign = value;
    }

    public void setRefresh(String value) {
        this.iRefresh = value;
    }

    public void setStyle(String value) {
        this.iStyle = value;
    }

    public void setFrameName(String value) {
        this.iName = value;
    }

    public ConcreteElement getContent(RunData runData) {
        if (PortletSessionState.getPortletConfigChanged(this, runData)) {
            try {
                this.init();
            }
            catch (PortletException pe) {
                logger.error("Exception", pe);
            }
        }
        StringBuffer text = new StringBuffer();
        if (this.getSource() == null || this.getSource().trim().length() == 0) {
            text.append(NO_SOURCE_MSG);
            return new StringElement(text.toString());
        }
        text.append("<IFRAME ");
        text.append("src = \"" + this.getSource() + "\" ");
        if (this.getWidth() != null) {
            text.append("width = \"" + this.getWidth() + "\" ");
        }
        if (this.getHeight() != null) {
            text.append("height = \"" + this.getHeight() + "\" ");
        }
        if (this.getFrameName() != null) {
            text.append("name = \"" + this.getFrameName() + "\" ");
        }
        if (this.getStyle() != null) {
            text.append("style = \"" + this.getStyle() + "\" ");
        }
        if (this.getMarginWidth() != null) {
            text.append("marginwidth = \"" + this.getMarginWidth() + "\" ");
        }
        if (this.getMarginHeight() != null) {
            text.append("marginheight = \"" + this.getMarginHeight() + "\" ");
        }
        if (this.getAlign() != null) {
            text.append("align = \"" + this.getAlign() + "\" ");
        }
        text.append("scrolling = \"" + this.getScrolling() + "\" ");
        text.append("frameborder = \"" + this.getFrameBorder() + "\" ");
        text.append(">");
        text.append("</IFRAME>");
        return new StringElement(text.toString());
    }

    public String getSource() {
        return this.iSource;
    }

    public String getScrolling() {
        return this.iScrolling;
    }

    public String getWidth() {
        return this.iWidth;
    }

    public String getHeight() {
        return this.iHeight;
    }

    public String getFrameBorder() {
        String trueValues = "1,yes,true";
        if (this.iFrameBorder != null && trueValues.indexOf(this.iFrameBorder) >= 0) {
            return DEFAULT_FRAMEBORDER;
        }
        return "0";
    }

    public String getNotSupportedMsg() {
        return DEFAULT_NOTSUPP_MSG;
    }

    public String getAlign() {
        return this.iAlign;
    }

    public String getStyle() {
        return this.iStyle;
    }

    public String getFrameName() {
        return this.iName;
    }

    public String getRefresh() {
        return this.iRefresh;
    }

    public String getMarginHeight() {
        return this.iMarginHeight;
    }

    public String getMarginWidth() {
        return this.iMarginWidth;
    }

    public void init() throws PortletException {
        super.init();
        try {
            PortletConfig config = this.getPortletConfig();
            String param = null;
            param = config.getInitParameter(PARAM_SOURCE);
            if (param != null) {
                this.setSource(param);
            }
            if ((param = config.getInitParameter(PARAM_WIDTH)) != null) {
                this.setWidth(param);
            }
            if ((param = config.getInitParameter(PARAM_HEIGHT)) != null) {
                this.setHeight(param);
            }
            if ((param = config.getInitParameter(PARAM_SCROLLING)) != null) {
                this.setScrolling(param);
            }
            if ((param = config.getInitParameter(PARAM_FRAMEBORDER)) != null) {
                this.setFrameBorder(param);
            }
            if ((param = config.getInitParameter(PARAM_STYLE)) != null) {
                this.setStyle(param);
            }
            if ((param = config.getInitParameter(PARAM_NAME)) != null) {
                this.setFrameName(param);
            }
            if ((param = config.getInitParameter(PARAM_REFRESH)) != null) {
                this.setRefresh(param);
            }
            if ((param = config.getInitParameter(PARAM_MARGINWIDTH)) != null) {
                this.setMarginWidth(param);
            }
            if ((param = config.getInitParameter(PARAM_MARGINHEIGHT)) != null) {
                this.setMarginHeight(param);
            }
            if ((param = config.getInitParameter(PARAM_ALIGN)) != null) {
                this.setAlign(param);
            }
        }
        catch (Exception e) {
            logger.error("Exception in init()", e);
            throw new PortletException(e.getMessage());
        }
    }
}

