/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets.viewprocessor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.GenericMVCContext;
import org.apache.jetspeed.portal.portlets.viewprocessor.ViewProcessor;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.SimpleTransform;
import org.apache.jetspeed.xml.JetspeedXMLEntityResolver;
import org.apache.turbine.util.RunData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSLViewProcessor
implements ViewProcessor {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(XSLViewProcessor.class.getName());
    private static final String XMLDECL = "<?xml version=";
    public static final String ERROR_NOT_VALID = "This does not appear to be an XML document";
    public static final String INVALID_TYPE = "Unable to display for this browser";
    protected Document document = null;
    protected Hashtable stylesheets = null;
    private Hashtable params = null;

    public void init(Portlet portlet) throws PortletException {
        DocumentBuilder parser = null;
        String url = null;
        this.stylesheets = new Hashtable();
        this.params = new Hashtable();
        Iterator i = portlet.getPortletConfig().getInitParameterNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            String base = MimeType.HTML.toString();
            if (name.startsWith("stylesheet")) {
                int idx = -1;
                idx = name.indexOf(".");
                if (idx > -1) {
                    base = name.substring(idx + 1, name.length());
                }
                this.stylesheets.put(base, portlet.getPortletConfig().getInitParameter(name));
                continue;
            }
            this.params.put(name.toLowerCase(), portlet.getPortletConfig().getInitParameter(name));
        }
        try {
            DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
            docfactory.setValidating(false);
            parser = docfactory.newDocumentBuilder();
            parser.setEntityResolver(new JetspeedXMLEntityResolver());
            url = portlet.getPortletConfig().getURL();
            String content = JetspeedDiskCache.getInstance().getEntry(url).getData();
            CapabilityMap xmap = CapabilityMapFactory.getCapabilityMap("agentxml/1.0");
            InputSource isrc = new InputSource(this.cleanse(content));
            isrc.setSystemId(url);
            isrc.setEncoding("UTF-8");
            this.document = parser.parse(isrc);
        }
        catch (Throwable t) {
            String message = "XSLViewProcessor:  Couldn't parse out XML document -> " + url;
            logger.error(message, t);
            throw new PortletException(t.getMessage());
        }
    }

    public Object processView(GenericMVCContext context) {
        try {
            this.init((Portlet)context.get("portlet"));
        }
        catch (PortletException pe) {
            logger.error("XSLViewProcessor - error: " + pe.getMessage(), pe);
        }
        RunData data = (RunData)context.get("data");
        CapabilityMap map = ((JetspeedRunData)data).getCapability();
        String type = map.getPreferredType().toString();
        JetspeedClearElement content = new JetspeedClearElement(INVALID_TYPE);
        String stylesheet = (String)this.stylesheets.get(type);
        if (stylesheet != null) {
            try {
                content = new JetspeedClearElement(SimpleTransform.transform(this.document, stylesheet, (Map)this.params));
            }
            catch (SAXException e) {
                logger.error("SAXException", e);
                content = new JetspeedClearElement(e.getMessage());
            }
        } else {
            content = new JetspeedClearElement("stylesheet not defined");
        }
        return content;
    }

    public boolean supportsType(MimeType mimeType) {
        Enumeration en = this.stylesheets.keys();
        while (en.hasMoreElements()) {
            String type = (String)en.nextElement();
            if (!type.equals(mimeType.toString())) continue;
            return true;
        }
        return false;
    }

    protected Node getNode(Node start, String name) {
        NodeList list = start.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!node.getNodeName().equals(name)) continue;
            return node;
        }
        return null;
    }

    protected Reader cleanse(String content) throws IOException {
        String filtered = null;
        int start = content.indexOf(XMLDECL);
        filtered = start <= 0 ? content : content.substring(start, content.length());
        return new StringReader(filtered);
    }
}

