/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.daemonfactory;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.daemon.Daemon;
import org.apache.jetspeed.daemon.DaemonConfig;
import org.apache.jetspeed.daemon.DaemonContext;
import org.apache.jetspeed.daemon.DaemonEntry;
import org.apache.jetspeed.daemon.DaemonException;
import org.apache.jetspeed.daemon.DaemonNotFoundException;
import org.apache.jetspeed.daemon.DaemonThread;
import org.apache.jetspeed.services.daemonfactory.DaemonFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineBaseService;

public class JetspeedDaemonFactoryService
extends TurbineBaseService
implements DaemonFactoryService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedDaemonFactoryService.class.getName());
    public static final String FEEDDAEMON_KEY = "org.apache.jetspeed.daemon.impl.FeedDaemon";
    public static final String DISKCACHEDAEMON_KEY = "org.apache.jetspeed.daemon.impl.DiskCacheDaemon";
    public static final String BADURLMANAGERDAEMON_KEY = "org.apache.jetspeed.daemon.impl.BadURLManagerDaemon";
    private DaemonContext context = null;
    protected Hashtable daemons = new Hashtable();
    protected Hashtable threads = new Hashtable();
    private DaemonEntry[] entries = null;

    public void init() {
        logger.info("Late init for DaemonFactory called");
        while (!this.getInit()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                logger.info("DaemonFactory service: Waiting for init()...");
            }
        }
    }

    public synchronized void init(ServletConfig config) {
        if (this.getInit()) {
            return;
        }
        logger.info("Early init for DaemonFactory called...");
        this.context = new DaemonContext();
        Vector raw = JetspeedResources.getVector((String)"daemon.entry");
        this.entries = new DaemonEntry[raw.size()];
        for (int i = 0; i < raw.size(); ++i) {
            String name = (String)raw.elementAt(i);
            String classname = JetspeedResources.getString("daemon." + name + ".classname");
            long interval = JetspeedResources.getLong("daemon." + name + ".interval");
            boolean onstartup = JetspeedResources.getBoolean("daemon." + name + ".onstartup");
            this.entries[i] = new DaemonEntry(name, interval, classname, onstartup);
        }
        this.setInit(true);
        logger.info("Early init for DaemonFactory done");
        this.start();
    }

    public void start() {
        logger.info("DaemonFactory:  Starting up necessary daemons.");
        DaemonEntry[] entries = this.getDaemonEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].onStartup()) continue;
            this.start(entries[i]);
        }
    }

    private void start(DaemonEntry entry) {
        logger.info("DaemonFactory:  start(): starting daemon -> " + entry.getName());
        DaemonThread dt = new DaemonThread(entry);
        this.threads.put(entry, dt);
        dt.start();
    }

    public void stop() {
        logger.info("DaemonFactory:  stop(): stop all daemons");
        try {
            super.shutdown();
            Collection threadsValues = this.threads.values();
            for (Object obj : threadsValues) {
                ((DaemonThread)obj).interrupt();
            }
            this.threads.clear();
            this.daemons.clear();
            Collection daemonsValues = this.daemons.values();
            for (Object obj : daemonsValues) {
                Daemon daemon = (Daemon)this.daemons.get(obj.getClass());
                daemon.wait();
            }
        }
        catch (Exception e) {
            logger.error("Error instantiating DaemonThread", e);
        }
    }

    public Daemon getDaemon(DaemonEntry entry) throws DaemonException {
        Daemon daemon = (Daemon)this.daemons.get(entry);
        if (daemon != null) {
            return daemon;
        }
        logger.info("Creating daemon: " + entry.getName());
        try {
            daemon = (Daemon)Class.forName(entry.getClassname()).newInstance();
            DaemonConfig dc = new DaemonConfig();
            daemon.init(dc, entry);
            this.daemons.put(entry, daemon);
            return daemon;
        }
        catch (ClassNotFoundException e) {
            logger.error("Exception", e);
            throw new DaemonException("daemon not found: " + e.getMessage());
        }
        catch (InstantiationException e) {
            logger.error("Exception", e);
            throw new DaemonException("couldn't instantiate daemon: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.error("Exception", e);
            throw new DaemonException(e.getMessage());
        }
    }

    public Daemon getDaemon(String classname) throws DaemonException {
        DaemonEntry[] entries = this.getDaemonEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getClassname().equals(classname)) continue;
            return this.getDaemon(entries[i]);
        }
        throw new DaemonException("daemon not found: " + classname);
    }

    public DaemonContext getDaemonContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DaemonEntry entry) throws DaemonException {
        int status;
        DaemonThread dt = (DaemonThread)this.threads.get(entry);
        if (dt == null) {
            this.start(entry);
            dt = (DaemonThread)this.threads.get(entry);
        }
        if ((status = this.getStatus(entry)) != 3 && status != 0 && dt != null) {
            DaemonThread daemonThread = dt;
            synchronized (daemonThread) {
                dt.notify();
            }
        }
        if (dt != null && !dt.isAlive()) {
            dt.start();
        }
    }

    public int getStatus(DaemonEntry entry) {
        try {
            Daemon daemon = this.getDaemon(entry);
            return daemon.getStatus();
        }
        catch (DaemonException e) {
            logger.error("Exception", e);
            return 0;
        }
    }

    public int getResult(DaemonEntry entry) {
        try {
            Daemon daemon = this.getDaemon(entry);
            return daemon.getResult();
        }
        catch (DaemonException e) {
            logger.error("Exception", e);
            return 0;
        }
    }

    public String getMessage(DaemonEntry entry) {
        try {
            Daemon daemon = this.getDaemon(entry);
            return daemon.getMessage();
        }
        catch (DaemonException e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public DaemonEntry[] getDaemonEntries() {
        return this.entries;
    }

    public DaemonEntry getDaemonEntry(String name) throws DaemonNotFoundException {
        DaemonEntry[] entries = this.getDaemonEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getName().equals(name)) continue;
            return entries[i];
        }
        throw new DaemonNotFoundException("Could not find daemon named: " + name);
    }
}

