/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.rundata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.StateManagerService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.rundata.TurbineRunDataService;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class JetspeedRunDataService
extends TurbineRunDataService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedRunDataService.class.getName());
    private Map m_runDataStore = null;

    public void init() throws InitializationException {
        super.init();
        this.m_runDataStore = Collections.synchronizedMap(new HashMap());
    }

    public RunData getRunData(String key, HttpServletRequest req, HttpServletResponse res, ServletConfig config) throws TurbineException, IllegalArgumentException {
        JetspeedRunData r = (JetspeedRunData)super.getRunData(key, req, res, config);
        this.m_runDataStore.put(Thread.currentThread(), r);
        StateManagerService stateManager = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (stateManager != null) {
            stateManager.setCurrentContext(req.getSession(true));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("JetspeedRunDataService: storing rundata " + r + " for thread: " + Thread.currentThread());
        }
        return r;
    }

    public boolean putRunData(RunData data) {
        StateManagerService stateManager = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (stateManager != null) {
            stateManager.clearCurrentContext();
        }
        this.m_runDataStore.remove(Thread.currentThread());
        if (logger.isDebugEnabled()) {
            logger.debug("JetspeedRunDataService: releasing rundata for thread: " + Thread.currentThread());
        }
        return super.putRunData(data);
    }

    public JetspeedRunData getCurrentRunData() {
        if (logger.isDebugEnabled()) {
            logger.debug("JetspeedRunDataService: accessing rundata " + this.m_runDataStore.get(Thread.currentThread()) + " for thread: " + Thread.currentThread());
        }
        return (JetspeedRunData)this.m_runDataStore.get(Thread.currentThread());
    }
}

