/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.jetspeed.om.security.BaseJetspeedGroup;
import org.apache.jetspeed.om.security.BaseJetspeedGroupRole;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.GroupRole;
import org.apache.jetspeed.om.security.Role;

public class CachedAcl {
    protected HashMap groupRoles = new HashMap();
    protected String userName;

    public CachedAcl(String userName) {
        this.userName = userName;
    }

    public void addRole(Role role) {
        BaseJetspeedGroup group = new BaseJetspeedGroup();
        group.setName("Jetspeed");
        this.addRole(role, group);
    }

    public void addRole(Role role, Group group) {
        BaseJetspeedGroupRole gr = new BaseJetspeedGroupRole();
        gr.setRole(role);
        gr.setGroup(group);
        String key = this.getGroupRoleKey(group.getName(), role.getName());
        this.groupRoles.put(key, gr);
    }

    public Role getRole(String roleName) {
        return this.getRole(roleName, "Jetspeed");
    }

    public Role getRole(String roleName, String groupName) {
        GroupRole gr = (GroupRole)this.groupRoles.get(this.getGroupRoleKey(groupName, roleName));
        return gr != null ? gr.getRole() : null;
    }

    public Iterator getRoles() {
        return this.groupRoles.values().iterator();
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean hasRole(String roleName) {
        return this.hasRole(roleName, "Jetspeed");
    }

    public boolean hasRole(String roleName, String groupName) {
        return this.groupRoles.containsKey(this.getGroupRoleKey(groupName, roleName));
    }

    public void removeRole(String roleName) {
        this.removeRole(roleName, "Jetspeed");
    }

    public void removeRole(String roleName, String groupName) {
        this.groupRoles.remove(this.getGroupRoleKey(groupName, roleName));
    }

    public void setRoles(Iterator grouproles) {
        while (grouproles.hasNext()) {
            GroupRole grouprole = (GroupRole)grouproles.next();
            String key = this.getGroupRoleKey(grouprole.getGroup().getName(), grouprole.getRole().getName());
            this.groupRoles.put(key, grouprole);
        }
    }

    private String getGroupRoleKey(String groupName, String roleName) {
        StringBuffer key = new StringBuffer();
        key.append(groupName);
        key.append(roleName);
        return key.toString();
    }
}

