/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.turbine;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.CredentialExpiredException;
import org.apache.jetspeed.services.security.FailedLoginException;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.PortalAuthentication;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class TurbineAuthentication
extends TurbineBaseService
implements PortalAuthentication {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(TurbineAuthentication.class.getName());
    private JetspeedRunDataService runDataService = null;
    private static final String CONFIG_ANONYMOUS_USER = "user.anonymous";
    String anonymousUser = "anon";
    private static final String CACHING_ENABLE = "caching.enable";
    private boolean cachingEnable = true;
    private static final String CONFIG_PASSWORD_EXPIRATION_PERIOD = "password.expiration.period";
    private int expirationPeriod = 0;

    public JetspeedUser login(String username, String password) throws LoginException {
        if (username.equals(this.anonymousUser)) {
            throw new LoginException("Anonymous user cannot login");
        }
        JetspeedUser user = null;
        username = JetspeedSecurity.convertUserName(username);
        password = JetspeedSecurity.convertPassword(password);
        try {
            user = JetspeedUserManagement.getUser(new UserNamePrincipal(username));
            password = JetspeedSecurity.encryptPassword(password);
        }
        catch (UnknownUserException e) {
            logger.warn("Unknown user attempted access: " + username, (Throwable)((Object)e));
            throw new FailedLoginException(e.toString());
        }
        catch (JetspeedSecurityException e) {
            logger.warn("User denied authentication: " + username, (Throwable)((Object)e));
            throw new LoginException(e.toString());
        }
        if (!user.getPassword().equals(password)) {
            logger.error("Invalid password for user: " + username);
            throw new FailedLoginException("Credential authentication failure");
        }
        if (this.expirationPeriod > 0) {
            Date passwordLastChangedDate = user.getPasswordChanged();
            Date passwordExpireDate = null;
            if (passwordLastChangedDate != null) {
                GregorianCalendar gcal = (GregorianCalendar)GregorianCalendar.getInstance();
                gcal.setTime(passwordLastChangedDate);
                gcal.add(5, this.expirationPeriod);
                passwordExpireDate = gcal.getTime();
                if (logger.isDebugEnabled()) {
                    logger.debug("TurbineAuthentication: password last changed = " + passwordLastChangedDate.toString() + ", password expires = " + passwordExpireDate.toString());
                }
            }
            if (passwordExpireDate == null || new Date().getTime() > passwordExpireDate.getTime()) {
                throw new CredentialExpiredException("Password expired");
            }
        }
        user.setHasLoggedIn(new Boolean(true));
        try {
            user.updateLastLogin();
            this.putUserIntoContext(user);
            if (this.cachingEnable) {
                JetspeedSecurityCache.load(username);
            }
        }
        catch (Exception e) {
            logger.error("Failed to update last login ", e);
            this.putUserIntoContext(JetspeedSecurity.getAnonymousUser());
            throw new LoginException("Failed to update last login ", e);
        }
        return user;
    }

    public JetspeedUser getAnonymousUser() throws LoginException {
        JetspeedUser user = null;
        try {
            user = JetspeedUserManagement.getUser(new UserNamePrincipal(this.anonymousUser));
            user.setHasLoggedIn(new Boolean(false));
            this.putUserIntoContext(user);
            if (this.cachingEnable) {
                JetspeedSecurityCache.load(user.getUserName());
            }
        }
        catch (JetspeedSecurityException e) {
            logger.error("Failed to get anonymous user: ", (Throwable)((Object)e));
            throw new LoginException("Failed to get anonymous user: ", (Throwable)((Object)e));
        }
        return user;
    }

    public void logout() throws LoginException {
        try {
            this.getAnonymousUser();
        }
        catch (Exception e) {
            logger.error("Exception logging user out ", e);
            throw new LoginException("Exception logging user out ", e);
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.anonymousUser = serviceConf.getString(CONFIG_ANONYMOUS_USER, this.anonymousUser);
        this.cachingEnable = serviceConf.getBoolean(CACHING_ENABLE, this.cachingEnable);
        this.expirationPeriod = serviceConf.getInt(CONFIG_PASSWORD_EXPIRATION_PERIOD, 0);
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.setInit(true);
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected JetspeedUser getUserFromContext() {
        JetspeedRunData rundata = this.getRunData();
        JetspeedUser user = null;
        if (rundata != null) {
            user = (JetspeedUser)rundata.getUser();
        }
        return user;
    }

    protected JetspeedRunData putUserIntoContext(JetspeedUser user) {
        JetspeedRunData rundata = this.getRunData();
        if (rundata != null) {
            rundata.setUser(user);
            rundata.save();
        }
        return rundata;
    }
}

