/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.turbine;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.security.BaseJetspeedGroupRole;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.om.security.turbine.TurbineGroup;
import org.apache.jetspeed.om.security.turbine.TurbineRole;
import org.apache.jetspeed.om.security.turbine.TurbineRolePeer;
import org.apache.jetspeed.om.security.turbine.TurbineRolePermissionPeer;
import org.apache.jetspeed.om.security.turbine.TurbineUserGroupRole;
import org.apache.jetspeed.om.security.turbine.TurbineUserGroupRolePeer;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.CachedAcl;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.RoleException;
import org.apache.jetspeed.services.security.RoleManagement;
import org.apache.torque.Torque;
import org.apache.torque.om.NumberKey;
import org.apache.torque.util.Criteria;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class TurbineRoleManagement
extends TurbineBaseService
implements RoleManagement {
    private JetspeedRunDataService runDataService = null;
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private boolean cascadeDelete;
    private static final String CACHING_ENABLE = "caching.enable";
    private boolean cachingEnable = true;

    public Iterator getRoles(String username) throws JetspeedSecurityException {
        HashMap<String, BaseJetspeedGroupRole> roles;
        JetspeedUser user = null;
        try {
            Iterator result;
            if (this.cachingEnable && null != (result = JetspeedSecurityCache.getRoles(username))) {
                return result;
            }
            user = JetspeedSecurity.getUser(new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new RoleException("Failed to Retrieve User: ", (Throwable)((Object)e));
        }
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)user.getUserId());
        try {
            List rels = TurbineUserGroupRolePeer.doSelect(criteria);
            roles = rels.size() > 0 ? new HashMap(rels.size()) : new HashMap<String, BaseJetspeedGroupRole>();
            for (int ix = 0; ix < rels.size(); ++ix) {
                TurbineUserGroupRole rel = (TurbineUserGroupRole)((Object)rels.get(ix));
                TurbineRole role = rel.getTurbineRole();
                TurbineGroup group = rel.getTurbineGroup();
                BaseJetspeedGroupRole groupRole = new BaseJetspeedGroupRole();
                groupRole.setGroup(group);
                groupRole.setRole(role);
                roles.put(group.getName() + role.getName(), groupRole);
            }
        }
        catch (Exception e) {
            throw new RoleException("Failed to retrieve roles ", e);
        }
        return roles.values().iterator();
    }

    public Iterator getRoles() throws JetspeedSecurityException {
        List roles;
        Criteria criteria = new Criteria();
        try {
            roles = TurbineRolePeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new RoleException("Failed to retrieve roles ", e);
        }
        return roles.iterator();
    }

    public void addRole(Role role) throws JetspeedSecurityException {
        if (this.roleExists(role.getName())) {
            throw new RoleException("The role '" + role.getName() + "' already exists");
        }
        try {
            TurbineRole trole = new TurbineRole();
            trole.setRoleName(role.getName());
            Criteria criteria = TurbineRolePeer.buildCriteria(trole);
            NumberKey key = (NumberKey)TurbineRolePeer.doInsert(criteria);
            role.setId(key.toString());
        }
        catch (Exception e) {
            throw new RoleException("Failed to create role '" + role.getName() + "'", e);
        }
        if (this.cachingEnable) {
            JetspeedSecurityCache.addRole(role);
        }
        try {
            this.addDefaultRolePSML(role);
        }
        catch (Exception e) {
            try {
                this.removeRole(role.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RoleException("failed to add default PSML for Role resource", e);
        }
    }

    protected void addDefaultRolePSML(Role role) throws RoleException {
        try {
            JetspeedRunDataService runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
            JetspeedRunData rundata = runDataService.getCurrentRunData();
            Profile profile = Profiler.createProfile();
            profile.setRole(role);
            profile.setMediaType("html");
            Profiler.createProfile((RunData)rundata, profile);
        }
        catch (ProfileException e) {
            try {
                this.removeRole(role.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RoleException("Failed to create Role PSML", e);
        }
    }

    public void saveRole(Role role) throws JetspeedSecurityException {
        if (!this.roleExists(role.getName())) {
            throw new RoleException("The role '" + role.getName() + "' doesn't exists");
        }
        try {
            if (!(role instanceof TurbineRole)) {
                throw new RoleException("TurbineRoleManagment: Role is not a Turbine role, cannot update");
            }
            TurbineRolePeer.doUpdate((TurbineRole)role);
        }
        catch (Exception e) {
            throw new RoleException("Failed to create role '" + role.getName() + "'", e);
        }
    }

    public void removeRole(String rolename) throws JetspeedSecurityException {
        Connection conn = null;
        try {
            conn = Torque.getConnection();
            Role role = this.getRole(rolename);
            Criteria criteria = new Criteria();
            criteria.add(TurbineRolePeer.ROLE_NAME, (Object)rolename);
            if (this.cascadeDelete) {
                Criteria criteria1 = new Criteria();
                criteria1.add(TurbineUserGroupRolePeer.ROLE_ID, (Object)role.getId());
                TurbineUserGroupRolePeer.doDelete(criteria1, conn);
                Criteria criteria2 = new Criteria();
                criteria2.add(TurbineRolePermissionPeer.ROLE_ID, (Object)role.getId());
                TurbineRolePermissionPeer.doDelete(criteria2, conn);
            }
            TurbineRolePeer.doDelete(criteria, conn);
            PsmlManager.removeRoleDocuments(role);
            conn.commit();
            if (this.cachingEnable) {
                JetspeedSecurityCache.removeAllRoles(rolename);
            }
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException sqle) {
                Log.error((Throwable)sqle);
            }
            throw new RoleException("Failed to remove role '" + rolename + "'", e);
        }
        finally {
            try {
                Torque.closeConnection((Connection)conn);
            }
            catch (Exception e) {}
        }
    }

    public void grantRole(String username, String rolename) throws JetspeedSecurityException {
        this.grantRole(username, rolename, "Jetspeed");
    }

    public void grantRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        try {
            JetspeedUser user = JetspeedSecurity.getUser(username);
            Role role = this.getRole(rolename);
            Group group = JetspeedSecurity.getGroup(groupname);
            Criteria criteria = new Criteria();
            criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)user.getUserId());
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)group.getId());
            criteria.add(TurbineUserGroupRolePeer.ROLE_ID, (Object)role.getId());
            TurbineUserGroupRolePeer.doInsert(criteria);
            if (this.cachingEnable) {
                JetspeedSecurityCache.addRole(username, role, group);
            }
        }
        catch (Exception e) {
            throw new RoleException("Grant role '" + rolename + "' to user '" + username + "' failed: ", e);
        }
    }

    public void revokeRole(String username, String rolename) throws JetspeedSecurityException {
        this.revokeRole(username, rolename, "Jetspeed");
    }

    public void revokeRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        try {
            JetspeedUser user = JetspeedSecurity.getUser(username);
            Role role = this.getRole(rolename);
            Group group = JetspeedSecurity.getGroup(groupname);
            Criteria criteria = new Criteria();
            criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)user.getUserId());
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)group.getId());
            criteria.add(TurbineUserGroupRolePeer.ROLE_ID, (Object)role.getId());
            TurbineUserGroupRolePeer.doDelete(criteria);
            if (this.cachingEnable) {
                JetspeedSecurityCache.removeRole(username, rolename, groupname);
            }
        }
        catch (Exception e) {
            throw new RoleException("Revoke role '" + rolename + "' to user '" + username + "' failed: ", e);
        }
    }

    public boolean hasRole(String username, String rolename) throws JetspeedSecurityException {
        return this.hasRole(username, rolename, "Jetspeed");
    }

    public boolean hasRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        List roles;
        try {
            CachedAcl acl;
            if (this.cachingEnable && null != (acl = JetspeedSecurityCache.getAcl(username))) {
                return acl.hasRole(rolename, groupname);
            }
            JetspeedUser user = JetspeedSecurity.getUser(username);
            Role role = this.getRole(rolename);
            Group group = JetspeedSecurity.getGroup(groupname);
            Criteria criteria = new Criteria();
            criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)user.getUserId());
            criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)group.getId());
            criteria.add(TurbineUserGroupRolePeer.ROLE_ID, (Object)role.getId());
            roles = TurbineUserGroupRolePeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new RoleException("Failed to check role '" + rolename + "'", e);
        }
        return roles.size() > 0;
    }

    public Role getRole(String rolename) throws JetspeedSecurityException {
        List roles;
        try {
            Criteria criteria = new Criteria();
            criteria.add(TurbineRolePeer.ROLE_NAME, (Object)rolename);
            roles = TurbineRolePeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new RoleException("Failed to retrieve role '" + rolename + "'", e);
        }
        if (roles.size() > 1) {
            throw new RoleException("Multiple Roles with same rolename '" + rolename + "'");
        }
        if (roles.size() == 1) {
            TurbineRole role = (TurbineRole)roles.get(0);
            return role;
        }
        throw new RoleException("Unknown role '" + rolename + "'");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean roleExists(String roleName) throws RoleException {
        List roles;
        Criteria criteria = new Criteria();
        criteria.add(TurbineRolePeer.ROLE_NAME, (Object)roleName);
        try {
            roles = TurbineRolePeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new RoleException("Failed to check account's presence", e);
        }
        return roles.size() >= 1;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.cachingEnable = serviceConf.getBoolean(CACHING_ENABLE, this.cachingEnable);
        this.setInit(true);
    }
}

