/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.template;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.ServletUtils;

public class JetspeedTemplateService
extends TurbineBaseService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedTemplateService.class.getName());
    private Hashtable screenCache = null;
    private Hashtable templateCache = null;
    private Hashtable navCache = null;
    private Hashtable layoutCache = null;
    private boolean useCache = false;
    private String extension;
    private String defaultLayoutTemplate;
    private String defaultNavigation;
    private String defaultScreen;
    private String[] templateRoot = null;

    public void init(ServletConfig config) throws InitializationException {
        try {
            this.initTemplate(config);
            this.setInit(true);
            logger.info("TemplateService init()....finished!");
        }
        catch (Exception e) {
            logger.error("TurbineTemplateService failed to initialize", e);
            throw new InitializationException("TurbineTemplateService failed to initialize", (Throwable)e);
        }
    }

    private void initTemplate(ServletConfig config) throws Exception {
        this.useCache = TurbineResources.getBoolean((String)"modules.cache", (boolean)true);
        Properties props = this.getProperties();
        if (this.useCache) {
            int layoutSize = Integer.parseInt(props.getProperty("layout.cache.size", "5"));
            int navigationSize = Integer.parseInt(props.getProperty("navigation.cache.size", "10"));
            int screenSize = Integer.parseInt(props.getProperty("screen.cache.size", "5"));
            int templateSize = Integer.parseInt(props.getProperty("screen.cache.size", "50"));
            this.layoutCache = new Hashtable((int)(1.25 * (double)layoutSize) + 1);
            this.navCache = new Hashtable((int)(1.25 * (double)navigationSize) + 1);
            this.screenCache = new Hashtable((int)(1.25 * (double)screenSize) + 1);
            this.templateCache = new Hashtable((int)(1.25 * (double)templateSize) + 1);
        }
        String templatePaths = props.getProperty("template.path", "/templates");
        templatePaths = ServletUtils.expandRelative((ServletConfig)config, (String)templatePaths);
        props.put("template.path", templatePaths);
        String pathSep = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(templatePaths, pathSep);
        this.templateRoot = new String[st.countTokens()];
        int pos = 0;
        while (st.hasMoreTokens()) {
            this.templateRoot[pos++] = st.nextToken();
        }
        this.extension = props.getProperty("default.extension", "html");
        this.defaultNavigation = props.getProperty("default.navigation", "TemplateNavigation");
        this.defaultScreen = props.getProperty("default.screen", "TemplateScreen");
        this.defaultLayoutTemplate = props.getProperty("default.layout.template", "/default." + this.extension);
        if (this.defaultLayoutTemplate.indexOf(46) == -1) {
            this.defaultLayoutTemplate = this.defaultLayoutTemplate + "." + this.extension;
        }
    }

    private void addToCache(String key, Object value, Hashtable h) {
        if (this.useCache && value != null) {
            h.put(key, value);
        }
    }

    public String getDefaultScreen() {
        return this.defaultScreen;
    }

    public String getDefaultNavigation() {
        return this.defaultNavigation;
    }

    public String getDefaultLayoutTemplate() {
        return this.defaultLayoutTemplate;
    }

    public String getScreenTemplateName(String key) throws Exception {
        if (this.name == null) {
            throw new Exception("TurbineTemplateService: getLayoutTemplateName() was passed in a null value.");
        }
        String name = null;
        if (this.useCache && this.templateCache.containsKey(key)) {
            name = (String)this.templateCache.get(key);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("JetspeedTemplatePage.getLayoutTemplateName(" + key + ")");
            }
            String[] names = this.parseScreenTemplate(key);
            name = names[2];
            this.addToCache(key, names[0], this.screenCache);
            this.addToCache(key, names[1], this.layoutCache);
            this.addToCache(key, names[2], this.templateCache);
        }
        return name;
    }

    public String getLayoutTemplateName(String name) throws Exception {
        if (name == null) {
            throw new Exception("TurbineTemplateService: getLayoutTemplateName() was passed in a null value.");
        }
        String layoutName = null;
        if (this.useCache && this.layoutCache.containsKey(name)) {
            layoutName = (String)this.layoutCache.get(name);
        } else {
            String[] names = this.parseScreenTemplate(name);
            layoutName = names[1];
            this.addToCache(name, names[0], this.screenCache);
            this.addToCache(name, names[1], this.layoutCache);
            this.addToCache(name, names[2], this.templateCache);
        }
        return layoutName;
    }

    public String getNavigationName(String name) throws Exception {
        if (name == null) {
            throw new Exception("TurbineTemplateService: getNavigationName() was passed in a null value.");
        }
        String nav_name = null;
        if (this.useCache && this.navCache.containsKey(name)) {
            nav_name = (String)this.navCache.get(name);
        } else {
            nav_name = this.parseNavigationTemplate(name);
            this.addToCache(name, nav_name, this.navCache);
        }
        return nav_name;
    }

    public String getScreenName(String name) throws Exception {
        if (name == null) {
            throw new Exception("TurbineTemplateService: getScreenName() was passed in a null value.");
        }
        String screenName = null;
        if (this.useCache && this.screenCache.containsKey(name)) {
            screenName = (String)this.screenCache.get(name);
        } else {
            String[] names = this.parseScreenTemplate(name);
            screenName = names[0];
            this.addToCache(name, names[0], this.screenCache);
            this.addToCache(name, names[1], this.layoutCache);
            this.addToCache(name, names[2], this.templateCache);
        }
        return screenName;
    }

    public String getDefaultExtension() {
        return this.extension;
    }

    protected String[] parseScreenTemplate(String template) throws Exception {
        int j;
        StringBuffer pkg;
        StringBuffer path;
        int i;
        if (template.indexOf(46) == -1) {
            template = template + "." + this.getDefaultExtension();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("JetspeedTemplateService.parseScreen: template = " + template);
        }
        StringTokenizer st = new StringTokenizer(template, "/");
        ArrayList<String> tokens = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("")) continue;
            tokens.add(token);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("JetspeedTemplateService.parseScreen: tokens1: " + tokens);
        }
        String fileName = (String)tokens.get(tokens.size() - 1);
        tokens.remove(tokens.size() - 1);
        int dot = fileName.lastIndexOf(46);
        String className = null;
        className = dot > 0 ? fileName.substring(0, dot) : fileName;
        String firstChar = String.valueOf(className.charAt(0));
        firstChar = firstChar.toUpperCase();
        className = firstChar + className.substring(1);
        if (logger.isDebugEnabled()) {
            logger.debug("JetspeedTemplateService.parseScreen: tokens2: " + tokens);
        }
        String pathRoot = null;
        String allPaths = "";
        String pathSep = System.getProperty("path.separator");
        for (int i2 = 0; i2 < this.templateRoot.length; ++i2) {
            if (logger.isDebugEnabled()) {
                logger.debug("JetspeedTemplateService.parseScreen: templateRoot " + i2 + " " + this.templateRoot[i2]);
            }
            String templatePath = null;
            for (int k = tokens.size(); k >= 0; --k) {
                StringBuffer path2 = new StringBuffer();
                for (int j2 = 0; j2 < k; ++j2) {
                    path2.append("/").append((String)tokens.get(j2));
                }
                StringBuffer distinctPath = new StringBuffer(path2.toString()).append("/").append(fileName);
                templatePath = distinctPath.toString();
                if (logger.isDebugEnabled()) {
                    logger.debug("JetspeedTemplateService.parseScreen: Path: " + templatePath);
                }
                if (new File(this.templateRoot[i2] + "/screens" + templatePath).exists()) {
                    template = templatePath;
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("JetspeedTemplateService.parseScreen: template found: " + template);
                    break;
                }
                templatePath = null;
            }
            if (templatePath != null) {
                pathRoot = this.templateRoot[i2];
                if (!logger.isDebugEnabled()) break;
                logger.debug("JetspeedTemplateService.parseScreen: pathRoot: " + pathRoot);
                break;
            }
            allPaths = allPaths + pathSep + this.templateRoot[i2];
        }
        if (pathRoot == null) {
            throw new Exception("The screen template: " + template + " does not exist in " + allPaths.substring(pathSep.length()) + ", so the TemplateService could not " + "determine associated templates.");
        }
        String[] paths = new String[2 * tokens.size() + 2];
        String[] pkgs = new String[2 * tokens.size() + 2];
        int arrayIndex = 0;
        for (i = tokens.size(); i >= 0; --i) {
            path = new StringBuffer();
            pkg = new StringBuffer();
            for (j = 0; j < i; ++j) {
                path.append("/").append((String)tokens.get(j));
                pkg.append((String)tokens.get(j)).append('.');
            }
            paths[arrayIndex] = path.append("/").append(fileName).toString();
            pkgs[arrayIndex] = pkg.append("/").append(className).toString();
            ++arrayIndex;
        }
        for (i = tokens.size(); i >= 0; --i) {
            path = new StringBuffer();
            pkg = new StringBuffer();
            for (j = 0; j < i; ++j) {
                path.append("/").append((String)tokens.get(j));
                pkg.append((String)tokens.get(j)).append('.');
            }
            paths[arrayIndex] = path.append(this.defaultLayoutTemplate).toString();
            pkgs[arrayIndex] = pkg.append("Default").toString();
            ++arrayIndex;
        }
        if (logger.isDebugEnabled()) {
            for (i = 0; i < paths.length; ++i) {
                logger.debug("JetspeedTemplateService.parseScreen: paths[" + i + "] = " + paths[i]);
            }
        }
        String[] holder = new String[]{this.getScreenName(pkgs), this.getLayoutTemplateName(pathRoot, paths), template};
        return holder;
    }

    protected String parseNavigationTemplate(String template) {
        StringTokenizer st = new StringTokenizer(template, "/");
        ArrayList<String> tokens = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("")) continue;
            tokens.add(token);
        }
        String fileName = (String)tokens.get(tokens.size() - 1);
        tokens.remove(tokens.size() - 1);
        int dot = fileName.lastIndexOf(46);
        String className = null;
        className = dot > 0 ? fileName.substring(0, dot) : fileName;
        String firstChar = String.valueOf(className.charAt(0));
        firstChar = firstChar.toUpperCase();
        className = firstChar + className.substring(1);
        String[] pkgs = new String[tokens.size() + 2];
        int arrayIndex = 0;
        for (int i = tokens.size(); i >= 0; --i) {
            StringBuffer pkg = new StringBuffer();
            for (int j = 0; j < i; ++j) {
                pkg.append((String)tokens.get(j)).append('.');
            }
            if (i == tokens.size()) {
                StringBuffer distinctPkg = new StringBuffer(pkg.toString());
                pkgs[arrayIndex] = distinctPkg.append(className).toString();
                ++arrayIndex;
            }
            pkgs[arrayIndex] = pkg.append("Default").toString();
            ++arrayIndex;
        }
        return this.getNavigationName(pkgs);
    }

    private String getLayoutTemplateName(String pathRoot, String[] possiblePaths) {
        int i;
        if (logger.isDebugEnabled()) {
            logger.debug("JetspeedTemplatePage.getLayoutTemplateName: pathRoot " + pathRoot);
            for (i = 0; i < possiblePaths.length; ++i) {
                logger.debug("JetspeedTemplatePage.getLayoutTemplateName: possiblePaths[" + i + "]=" + possiblePaths[i]);
            }
        }
        for (i = 0; i < possiblePaths.length; ++i) {
            if (new File(pathRoot, "layouts" + possiblePaths[i]).exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("JetspeedTemplatePage.getLayoutTemplateName: " + pathRoot + "/layouts" + possiblePaths[i] + " found.");
                }
                return possiblePaths[i];
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("JetspeedTemplatePage.getLayoutTemplateName: " + pathRoot + "/layouts" + possiblePaths[i] + " NOT found.");
        }
        return this.defaultLayoutTemplate;
    }

    private String getScreenName(String[] possibleScreens) {
        for (int i = 0; i < possibleScreens.length; ++i) {
            try {
                ScreenLoader.getInstance().getInstance(possibleScreens[i]);
                return possibleScreens[i];
            }
            catch (Exception e) {
                logger.error("Exception in getScreenName", e);
                continue;
            }
        }
        return this.defaultScreen;
    }

    private String getNavigationName(String[] possibleNavigations) {
        for (int i = 0; i < possibleNavigations.length; ++i) {
            try {
                NavigationLoader.getInstance().getInstance(possibleNavigations[i]);
                return possibleNavigations[i];
            }
            catch (Exception e) {
                logger.error("Exception in getNavigationName", e);
                continue;
            }
        }
        return this.defaultNavigation;
    }
}

