/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class HTMLRewriter {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(HTMLRewriter.class.getName());
    private Callback cb = new Callback();

    public HTMLRewriter(boolean removeScript, boolean removeStyle, boolean removeNoScript, boolean removeMeta, boolean removeApplet, boolean removeObject, boolean removeHead, boolean removeOnSomething) {
        this.init(removeScript, removeStyle, removeNoScript, removeMeta, removeApplet, removeObject, removeHead, removeOnSomething, false);
    }

    public HTMLRewriter(boolean removeScript, boolean removeStyle, boolean removeNoScript, boolean removeMeta, boolean removeApplet, boolean removeObject, boolean removeHead, boolean removeOnSomething, boolean openInNewWindow) {
        this.init(removeScript, removeStyle, removeNoScript, removeMeta, removeApplet, removeObject, removeHead, removeOnSomething, openInNewWindow);
    }

    private void init(boolean removeScript, boolean removeStyle, boolean removeNoScript, boolean removeMeta, boolean removeApplet, boolean removeObject, boolean removeHead, boolean removeOnSomething, boolean openInNewWindow) {
        this.cb.removeScript = removeScript;
        this.cb.removeStyle = removeStyle;
        this.cb.removeNoScript = removeNoScript;
        this.cb.removeMeta = removeMeta;
        this.cb.removeApplet = removeApplet;
        this.cb.removeObject = removeObject;
        this.cb.removeHead = removeHead;
        this.cb.removeOnSomething = removeOnSomething;
        this.cb.openInNewWindow = openInNewWindow;
    }

    public synchronized String convertURLs(Reader HTMLrdr, String BaseUrl) throws MalformedURLException {
        HTMLEditorKit.Parser parse = new ParserGetter().getParser();
        String res = "";
        try {
            if (this.cb.result != null) {
                this.cb.result = null;
                this.cb.result = new StringWriter();
            }
            this.cb.baseUrl = new URL(BaseUrl);
            parse.parse(HTMLrdr, this.cb, true);
            res = this.cb.getResult();
        }
        catch (Exception e) {
            logger.error("Unable to convertURLS", e);
            throw new MalformedURLException(e.toString());
        }
        return res;
    }

    class Callback
    extends HTMLEditorKit.ParserCallback {
        private URL baseUrl;
        private boolean inForm = false;
        private int ignoreLevel = 0;
        private boolean removeScript = true;
        private boolean removeStyle = true;
        private boolean removeNoScript = true;
        private boolean removeMeta = true;
        private boolean removeApplet = true;
        private boolean removeObject = true;
        private boolean removeHead = true;
        private boolean openInNewWindow = false;
        private boolean removeOnSomething = true;
        private boolean inScript = false;
        private boolean inStyle = false;
        private StringWriter result = new StringWriter();

        private Callback() {
        }

        private Callback addToResult(Object txt) {
            if (this.ignoreLevel > 0) {
                return this;
            }
            try {
                this.result.write(txt.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        private Callback addToResult(char[] txt) {
            if (this.ignoreLevel > 0) {
                return this;
            }
            try {
                this.result.write(txt);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        public String getResult() {
            try {
                this.result.flush();
            }
            catch (Exception e) {
                // empty catch block
            }
            String res = " " + this.result.toString();
            return res;
        }

        public void flush() throws BadLocationException {
        }

        public void handleComment(char[] values, int param) {
            if (!this.inStyle && !this.inScript) {
                return;
            }
            try {
                this.result.write("<!--");
                this.result.write(values);
                this.result.write("-->");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void handleEndOfLineString(String str) {
            this.addToResult("\n");
        }

        public void handleError(String str, int param) {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attrs, int param) {
            if (this.removeMeta && tag == HTML.Tag.META) {
                return;
            }
            this.appendTagToResult(tag, attrs);
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrs, int position) {
            this.appendTagToResult(tag, attrs);
        }

        public void handleEndTag(HTML.Tag tag, int position) {
            if (tag == HTML.Tag.FORM && this.inForm) {
                this.addToResult("</").addToResult(tag).addToResult(">");
                this.inForm = false;
            } else if (tag != HTML.Tag.FORM) {
                this.addToResult("</").addToResult(tag).addToResult(">");
            }
            if (!this.removeScript && tag == HTML.Tag.SCRIPT) {
                this.inScript = false;
            } else if (!this.removeStyle && tag == HTML.Tag.STYLE) {
                this.inStyle = false;
            }
            if (this.removeScript && tag == HTML.Tag.SCRIPT) {
                --this.ignoreLevel;
            } else if (this.removeStyle && tag == HTML.Tag.STYLE) {
                --this.ignoreLevel;
            } else if (this.removeHead && tag == HTML.Tag.HEAD) {
                --this.ignoreLevel;
            } else if (this.removeApplet && tag == HTML.Tag.APPLET) {
                --this.ignoreLevel;
            } else if (this.removeObject && tag == HTML.Tag.OBJECT) {
                --this.ignoreLevel;
            } else if (this.removeNoScript && tag.toString().equalsIgnoreCase("NOSCRIPT")) {
                --this.ignoreLevel;
            }
        }

        private void appendTagToResult(HTML.Tag tag, MutableAttributeSet attrs) {
            if (tag.toString().equalsIgnoreCase("__ENDOFLINETAG__")) {
                return;
            }
            if (tag.toString().equalsIgnoreCase("__IMPLIED__")) {
                return;
            }
            this.convertURLS(tag, attrs);
            Enumeration<?> e = attrs.getAttributeNames();
            if (tag == HTML.Tag.BASE) {
                return;
            }
            this.addToResult("<").addToResult(tag);
            while (e.hasMoreElements()) {
                Object attr = e.nextElement();
                String attrName = attr.toString();
                String value = attrs.getAttribute(attr).toString();
                if (this.removeOnSomething && attrName.toLowerCase().startsWith("on") && attrName.length() > 2) continue;
                this.addToResult(" ").addToResult(attr).addToResult("=\"").addToResult(value).addToResult("\"");
            }
            this.addToResult(">");
        }

        private void convertURLS(HTML.Tag tag, MutableAttributeSet attrs) {
            if (tag == HTML.Tag.A) {
                if (attrs.getAttribute(HTML.Attribute.HREF) != null) {
                    this.addConvertedAttribute(HTML.Attribute.HREF, attrs);
                }
                if (attrs.getAttribute(HTML.Attribute.TARGET) == null && ((HTMLRewriter)HTMLRewriter.this).cb.openInNewWindow) {
                    attrs.addAttribute(HTML.Attribute.TARGET, "_BLANK");
                }
            } else if (tag == HTML.Tag.AREA) {
                if (attrs.getAttribute(HTML.Attribute.HREF) != null) {
                    this.addConvertedAttribute(HTML.Attribute.HREF, attrs);
                }
                if (attrs.getAttribute(HTML.Attribute.TARGET) == null && ((HTMLRewriter)HTMLRewriter.this).cb.openInNewWindow) {
                    attrs.addAttribute(HTML.Attribute.TARGET, "_BLANK");
                }
            } else if ((tag == HTML.Tag.IMG || tag == HTML.Tag.INPUT || tag == HTML.Tag.SCRIPT) && attrs.getAttribute(HTML.Attribute.SRC) != null) {
                this.addConvertedAttribute(HTML.Attribute.SRC, attrs);
            } else if (tag == HTML.Tag.LINK) {
                if (attrs.getAttribute(HTML.Attribute.HREF) != null) {
                    this.addConvertedAttribute(HTML.Attribute.HREF, attrs);
                }
            } else if (tag == HTML.Tag.APPLET) {
                if (attrs.getAttribute(HTML.Attribute.CODEBASE) == null) {
                    int endOfPath = this.baseUrl.toString().lastIndexOf("/");
                    attrs.addAttribute(HTML.Attribute.CODEBASE, this.baseUrl.toString().substring(0, endOfPath + 1));
                } else {
                    this.addConvertedAttribute(HTML.Attribute.CODEBASE, attrs);
                }
            } else if (tag == HTML.Tag.OBJECT) {
                if (attrs.getAttribute(HTML.Attribute.CODEBASE) == null) {
                    int endOfPath = this.baseUrl.toString().lastIndexOf("/");
                    attrs.addAttribute(HTML.Attribute.CODEBASE, this.baseUrl.toString().substring(0, endOfPath + 1));
                } else {
                    this.addConvertedAttribute(HTML.Attribute.CODEBASE, attrs);
                }
            } else if (tag == HTML.Tag.BODY) {
                if (attrs.getAttribute(HTML.Attribute.BACKGROUND) != null) {
                    attrs.removeAttribute(HTML.Attribute.BACKGROUND);
                }
            } else if (tag == HTML.Tag.BASE) {
                if (attrs.getAttribute(HTML.Attribute.HREF) != null) {
                    try {
                        this.baseUrl = new URL(attrs.getAttribute(HTML.Attribute.HREF).toString());
                    }
                    catch (Throwable t) {
                        logger.error("HTMLRewriter: Setting BASE=" + attrs.getAttribute(HTML.Attribute.HREF).toString() + t.getMessage());
                    }
                    attrs.removeAttribute(HTML.Attribute.HREF);
                }
            } else if (tag == HTML.Tag.FORM) {
                this.inForm = true;
                if (attrs.getAttribute(HTML.Attribute.ACTION) == null) {
                    attrs.addAttribute(HTML.Attribute.ACTION, this.baseUrl.toString());
                } else {
                    this.addConvertedAttribute(HTML.Attribute.ACTION, attrs);
                }
            } else if (tag == HTML.Tag.TD && attrs.getAttribute(HTML.Attribute.BACKGROUND) != null) {
                this.addConvertedAttribute(HTML.Attribute.BACKGROUND, attrs);
            }
            if (!this.removeScript && tag == HTML.Tag.SCRIPT) {
                this.inScript = true;
            } else if (!this.removeStyle && tag == HTML.Tag.STYLE) {
                this.inStyle = true;
            }
            if (this.removeScript && tag == HTML.Tag.SCRIPT) {
                ++this.ignoreLevel;
            } else if (this.removeStyle && tag == HTML.Tag.STYLE) {
                ++this.ignoreLevel;
            } else if (this.removeHead && tag == HTML.Tag.HEAD) {
                ++this.ignoreLevel;
            } else if (this.removeApplet && tag == HTML.Tag.APPLET) {
                ++this.ignoreLevel;
            } else if (this.removeObject && tag == HTML.Tag.OBJECT) {
                ++this.ignoreLevel;
            } else if (this.removeNoScript && tag.toString().equalsIgnoreCase("NOSCRIPT")) {
                ++this.ignoreLevel;
            }
        }

        private void addConvertedAttribute(HTML.Attribute attr, MutableAttributeSet attrs) {
            if (attrs.getAttribute(attr) != null) {
                String attrSource = attrs.getAttribute(attr).toString();
                attrs.addAttribute(attr, this.generateNewUrl(attrSource));
            }
        }

        private String generateNewUrl(String oldURL) {
            try {
                URL x = new URL(this.baseUrl, oldURL);
                return x.toString();
            }
            catch (Throwable t) {
                if (oldURL.toLowerCase().startsWith("javascript:")) {
                    return oldURL;
                }
                logger.error("HTMLRewriter: Setting BASE=" + this.baseUrl + " Old = " + oldURL + t.getMessage());
                return oldURL;
            }
        }

        public void handleText(char[] values, int param) {
            this.addToResult(values);
        }
    }

    class ParserGetter
    extends HTMLEditorKit {
        ParserGetter() {
        }

        public HTMLEditorKit.Parser getParser() {
            return super.getParser();
        }
    }
}

