/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

public class SAXPIFilter
extends HandlerBase {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(SAXPIFilter.class.getName());
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected PrintWriter out = new PrintWriter(System.out);
    private String pi;
    private boolean stripExistingPI;
    private Vector pis = new Vector();

    public SAXPIFilter(PrintWriter outPW) throws UnsupportedEncodingException {
        this(outPW, false, null);
    }

    public SAXPIFilter(PrintWriter outPW, boolean strip) throws UnsupportedEncodingException {
        this(outPW, strip, null);
    }

    public SAXPIFilter(PrintWriter outPW, boolean strip, String PI2) throws UnsupportedEncodingException {
        this.out = outPW;
        this.stripExistingPI = strip;
        this.pi = PI2;
    }

    public String[] getProcessingInstructions() {
        Object[] ins = new String[this.pis.size()];
        this.pis.copyInto(ins);
        return ins;
    }

    public void addProcessingInstruction(String pi) {
        this.pis.addElement(pi);
    }

    public void print(String uri) {
        try {
            SAXPIFilter handler = this;
            Parser parser = ParserFactory.makeParser(DEFAULT_PARSER_NAME);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(uri);
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    public void print(InputStream in) {
        try {
            SAXPIFilter handler = this;
            Parser parser = ParserFactory.makeParser(DEFAULT_PARSER_NAME);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(in));
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    public void print(Reader in) {
        try {
            SAXPIFilter handler = this;
            Parser parser = ParserFactory.makeParser(DEFAULT_PARSER_NAME);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(in));
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    public void processingInstruction(String target, String data) {
        if (!this.stripExistingPI) {
            this.out.print(this.makeSAXPI(target, data));
        } else if (target.equals("cocoon-process")) {
            this.addProcessingInstruction(this.makeSAXPI(target, data));
        }
    }

    private String makeSAXPI(String target, String data) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?");
        buffer.append(target);
        if (data != null && data.length() > 0) {
            buffer.append(' ');
            buffer.append(data);
        }
        buffer.append("?>");
        return buffer.toString();
    }

    public void startDocument() {
        if (this.pi != null) {
            this.out.print(this.pi);
        }
    }

    public void startElement(String name, AttributeList attrs) {
        this.out.print('<');
        this.out.print(name);
        if (attrs != null) {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                this.out.print(' ');
                this.out.print(attrs.getName(i));
                this.out.print("=\"");
                this.out.print(this.normalize(attrs.getValue(i)));
                this.out.print('\"');
            }
        }
        this.out.print('>');
    }

    public void characters(char[] ch, int start, int length) {
        this.out.print(this.normalize(new String(ch, start, length)));
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.characters(ch, start, length);
    }

    public void endElement(String name) {
        this.out.print("</");
        this.out.print(name);
        this.out.print('>');
    }

    public void endDocument() {
        this.out.flush();
    }

    public void warning(SAXParseException ex) {
        System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void error(SAXParseException ex) {
        System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block6;
                }
                case '>': {
                    str.append("&gt;");
                    continue block6;
                }
                case '&': {
                    str.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block6;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }
}

