/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.servlet;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Map;
import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.SimpleTransform;
import org.xml.sax.InputSource;

public class EcsStylesheetElement
extends ConcreteElement {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(EcsStylesheetElement.class.getName());
    private InputSource content_;
    private Map params_;
    private InputSource stylesheet_;

    public void output(OutputStream out) {
        this.output(new PrintWriter(out));
    }

    public void output(PrintWriter out) {
        try {
            StringReader rdr = new StringReader(SimpleTransform.transform(this.content_, this.stylesheet_, this.params_));
            int count = 0;
            char[] buff = new char[1024];
            while ((count = rdr.read(buff, 0, buff.length)) > 0) {
                out.write(buff, 0, count);
            }
        }
        catch (Exception e) {
            String message = "ECSStylesheetElement.output(PrintWriter): error processing stylesheet" + e.getMessage();
            logger.error(message, e);
            out.print(message);
            e.printStackTrace(out);
        }
    }

    public EcsStylesheetElement(InputSource content, InputSource stylesheet, Map params) {
        this.content_ = content;
        this.stylesheet_ = stylesheet;
        this.params_ = params;
    }
}

