/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.webservices.util;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessList;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceList;
import org.uddi4j.transport.TransportException;

public class UDDIAccessBean
implements Serializable {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(UDDIAccessBean.class.getName());
    private transient UDDIProxy proxy = new UDDIProxy();
    private String queryURL;

    public void setQueryURL(String queryURL) {
        this.queryURL = queryURL;
    }

    public String getQueryURL() {
        return this.queryURL;
    }

    public UDDIAccessBean() {
        this.queryURL = "http://www-3.ibm.com/services/uddi/testregistry/inquiryapi";
    }

    public UDDIAccessBean(String queryURL) {
        this.queryURL = queryURL;
    }

    public List queryBusiness(String name) {
        Vector businessList;
        block8: {
            businessList = new Vector();
            try {
                this.proxy.setInquiryURL(this.queryURL);
                BusinessList results = this.proxy.find_business(name, null, 0);
                businessList = results.getBusinessInfos().getBusinessInfoVector();
                if (logger.isDebugEnabled()) {
                    ListIterator iterator = businessList.listIterator();
                    while (iterator.hasNext()) {
                        BusinessInfo business = (BusinessInfo)iterator.next();
                        logger.debug(business.getDefaultDescriptionString());
                    }
                }
            }
            catch (MalformedURLException exception) {
                exception.printStackTrace();
                if (logger.isDebugEnabled()) {
                    logger.error(exception.getMessage(), exception);
                }
            }
            catch (UDDIException exception) {
                exception.printStackTrace();
                if (logger.isDebugEnabled()) {
                    logger.error(exception.getMessage(), exception);
                }
            }
            catch (TransportException exception) {
                exception.printStackTrace();
                if (!logger.isDebugEnabled()) break block8;
                logger.error(exception.getMessage(), exception);
            }
        }
        return businessList;
    }

    public String getBusinessKey(String businessName) {
        String businessKey;
        block7: {
            businessKey = null;
            Vector businessList = new Vector();
            try {
                this.proxy.setInquiryURL(this.queryURL);
                BusinessList results = this.proxy.find_business(businessName, null, 0);
                businessList = results.getBusinessInfos().getBusinessInfoVector();
                ListIterator iterator = businessList.listIterator();
                while (iterator.hasNext()) {
                    BusinessInfo business = (BusinessInfo)iterator.next();
                    if (!business.getNameString().equals(businessName)) continue;
                    businessKey = business.getBusinessKey();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(business.getNameString() + " has associated key " + businessKey);
                }
            }
            catch (MalformedURLException exception) {
                exception.printStackTrace();
                if (logger.isDebugEnabled()) {
                    logger.error(exception.getMessage(), exception);
                }
            }
            catch (UDDIException exception) {
                exception.printStackTrace();
                if (logger.isDebugEnabled()) {
                    logger.error(exception.getMessage(), exception);
                }
            }
            catch (TransportException exception) {
                exception.printStackTrace();
                if (!logger.isDebugEnabled()) break block7;
                logger.error(exception.getMessage(), exception);
            }
        }
        return businessKey;
    }

    public List queryService(String businessKey, String description) {
        Vector serviceList;
        block8: {
            serviceList = new Vector();
            try {
                this.proxy.setInquiryURL(this.queryURL);
                ServiceList results = this.proxy.find_service(businessKey, description, null, 0);
                serviceList = results.getServiceInfos().getServiceInfoVector();
                if (logger.isDebugEnabled()) {
                    ListIterator iterator = serviceList.listIterator();
                    while (iterator.hasNext()) {
                        ServiceInfo service = (ServiceInfo)iterator.next();
                        logger.debug(service.getNameString());
                    }
                }
            }
            catch (MalformedURLException exception) {
                exception.printStackTrace();
                if (logger.isDebugEnabled()) {
                    logger.error(exception.getMessage(), exception);
                }
            }
            catch (UDDIException exception) {
                exception.printStackTrace();
                if (logger.isDebugEnabled()) {
                    logger.error(exception.getMessage(), exception);
                }
            }
            catch (TransportException exception) {
                exception.printStackTrace();
                if (!logger.isDebugEnabled()) break block8;
                logger.error(exception.getMessage(), exception);
            }
        }
        return serviceList;
    }

    public String getServiceKey(String businessKey, String serviceName) {
        String serviceKey;
        block7: {
            serviceKey = null;
            Vector serviceList = new Vector();
            try {
                this.proxy.setInquiryURL(this.queryURL);
                ServiceList results = this.proxy.find_service(businessKey, serviceName, null, 0);
                serviceList = results.getServiceInfos().getServiceInfoVector();
                ListIterator iterator = serviceList.listIterator();
                while (iterator.hasNext()) {
                    ServiceInfo service = (ServiceInfo)iterator.next();
                    if (!service.getNameString().equals(serviceName)) continue;
                    serviceKey = service.getServiceKey();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(service.getNameString() + " has associated key " + serviceKey);
                }
            }
            catch (MalformedURLException exception) {
                exception.printStackTrace();
                if (logger.isDebugEnabled()) {
                    logger.error(exception.getMessage(), exception);
                }
            }
            catch (UDDIException exception) {
                exception.printStackTrace();
                if (logger.isDebugEnabled()) {
                    logger.error(exception.getMessage(), exception);
                }
            }
            catch (TransportException exception) {
                exception.printStackTrace();
                if (!logger.isDebugEnabled()) break block7;
                logger.error(exception.getMessage(), exception);
            }
        }
        return serviceKey;
    }

    public void finalize() {
        this.proxy = null;
        this.queryURL = null;
    }
}

