/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.blog.BlogCommentResultData;
import com.aimluck.eip.blog.BlogEntryResultData;
import com.aimluck.eip.blog.BlogFootmarkResultData;
import com.aimluck.eip.blog.BlogThemaResultData;
import com.aimluck.eip.blog.BlogUserResultData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFile;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogEntrySelectData
extends ALAbstractSelectData<EipTBlogEntry, EipTBlogEntry>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogEntrySelectData.class.getName());
    private List<BlogThemaResultData> themaList;
    private int entrySum;
    private List<BlogCommentResultData> commentList;
    private List<BlogFootmarkResultData> footmarkList;
    private int uid;
    private String ownerId;
    private int view_uid;
    private ALStringField view_uname;
    private boolean has_photo;
    private String userAccountURI;
    private boolean editable;
    private boolean deletable;
    private boolean comment_deletable;
    private boolean other_comment_deletable;
    private String aclPortletFeature = null;
    private ALStringField keyword;
    private String themeId;
    private String groupId;
    private List<BlogUserResultData> userList;
    private List<ALEipGroup> myGroupList;
    private final List<Integer> users = new ArrayList<Integer>();

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (rundata.getParameters().containsKey((Object)"entityid")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"entityid", (String)rundata.getParameters().get("entityid"));
        }
        this.ownerId = BlogUtils.getOwnerId(rundata, context);
        this.themeId = BlogUtils.getThemeId(rundata, context);
        this.keyword = new ALStringField(BlogUtils.getKeyword(rundata, context));
        this.groupId = BlogUtils.getGroupId(rundata, context);
        this.userList = BlogUtils.getBlogUserResultDataList(this.getGroupId());
        this.myGroupList = ALEipUtils.getMyGroups((RunData)rundata);
        this.userAccountURI = BlogUtils.getPortletURIinPersonalConfigPane(rundata, "AccountPerson");
        super.init(action, rundata, context);
        this.view_uid = BlogUtils.getViewId(rundata, context, this.uid);
        this.aclPortletFeature = this.view_uid == this.uid ? "blog_entry_self" : "blog_entry_other";
        this.editable = BlogUtils.checkPermission(rundata, context, 8, this.aclPortletFeature);
        this.deletable = BlogUtils.checkPermission(rundata, context, 16, this.aclPortletFeature);
        this.other_comment_deletable = BlogUtils.checkPermission(rundata, context, 16, "blog_entry_other_reply");
        this.comment_deletable = BlogUtils.checkPermission(rundata, context, 16, "blog_entry_reply");
    }

    public void loadThemaList(RunData rundata, Context context) {
        this.themaList = BlogUtils.getThemaList(rundata, context);
    }

    public ResultList<EipTBlogEntry> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTBlogEntry> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            query.orderDesending("createDate");
            ResultList list = query.getResultList();
            this.entrySum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTBlogEntry> getSelectQuery(RunData rundata, Context context) {
        SelectQuery<EipTBlogEntry> query = Database.query(EipTBlogEntry.class);
        query = BlogUtils.buildSelectQueryForBlogFilter(query, rundata, context);
        query.orderDesending("createDate");
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(EipTBlogEntry record) {
        try {
            BlogEntryResultData rd = new BlogEntryResultData();
            rd.initField();
            rd.setEntryId(record.getEntryId().longValue());
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setTitle(ALCommonUtils.compressString((String)record.getTitle(), (int)this.getStrLength()));
            rd.setNote(record.getNote().replaceAll("\\r\\n", " ").replaceAll("\\n", " ").replaceAll("\\r", " "));
            rd.setBlogId(record.getEipTBlog().getBlogId().longValue());
            if (record.getEipTBlogThema() != null && record.getEipTBlogThema().getThemaId() != null) {
                rd.setThemaId(record.getEipTBlogThema().getThemaId().longValue());
                rd.setThemaName(ALCommonUtils.compressString((String)record.getEipTBlogThema().getThemaName(), (int)this.getStrLength()));
            }
            rd.setAllowComments("T".equals(record.getAllowComments()));
            rd.setTitleDate(record.getCreateDate());
            SimpleDateFormat sdf1 = new SimpleDateFormat("dd");
            rd.setDay(Integer.parseInt(sdf1.format(record.getCreateDate())));
            SelectQuery query = Database.query(EipTBlogComment.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)record.getEntryId());
            query.setQualifier(exp);
            List list = query.fetchList();
            if (list != null && list.size() > 0) {
                rd.setCommentsNum(list.size());
            }
            if (!this.users.contains(record.getOwnerId())) {
                this.users.add(record.getOwnerId());
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
            return null;
        }
    }

    public EipTBlogEntry selectDetail(RunData rundata, Context context) {
        try {
            EipTBlogEntry obj = BlogUtils.getEipTBlogEntry(rundata, context);
            return obj;
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipTBlogEntry record) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5(EE) HH\u6642mm\u5206");
            BlogEntryResultData rd = new BlogEntryResultData();
            rd.initField();
            rd.setEntryId(record.getEntryId().longValue());
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setTitle(record.getTitle());
            rd.setNote(record.getNote());
            rd.setBlogId(record.getEipTBlog().getBlogId().longValue());
            rd.setThemaId(record.getEipTBlogThema().getThemaId().intValue());
            rd.setThemaName(record.getEipTBlogThema().getThemaName());
            rd.setAllowComments("T".equals(record.getAllowComments()));
            rd.setCreateDate(sdf.format(record.getCreateDate()));
            rd.setCreateDateAlternative(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            this.commentList = new ArrayList<BlogCommentResultData>();
            SelectQuery query = Database.query(EipTBlogComment.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)record.getEntryId());
            query.orderAscending("updateDate");
            query.setQualifier(exp);
            List comments = query.fetchList();
            if (comments != null && comments.size() > 0) {
                int size = comments.size();
                for (int i = 0; i < size; ++i) {
                    EipTBlogComment blogcomment = (EipTBlogComment)comments.get(i);
                    BlogCommentResultData comment = new BlogCommentResultData();
                    comment.initField();
                    comment.setCommentId(blogcomment.getCommentId().longValue());
                    comment.setOwnerId(blogcomment.getOwnerId().longValue());
                    comment.setOwnerName(BlogUtils.getUserFullName(blogcomment.getOwnerId()));
                    comment.setComment(blogcomment.getComment());
                    comment.setEntryId(blogcomment.getEipTBlogEntry().getEntryId().longValue());
                    comment.setUpdateDate(sdf.format(blogcomment.getUpdateDate()));
                    comment.setUpdateDateAlternative(blogcomment.getUpdateDate());
                    comment.setOwner(ALEipUtils.getALEipUser((int)blogcomment.getOwnerId()));
                    this.commentList.add(comment);
                }
            }
            SelectQuery filequery = Database.query(EipTBlogFile.class);
            Expression fileexp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)record.getEntryId());
            filequery.setQualifier(fileexp);
            filequery.orderAscending("updateDate");
            filequery.orderAscending("filePath");
            List files = filequery.fetchList();
            if (files != null && files.size() > 0) {
                ArrayList<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
                FileuploadBean filebean = null;
                int size = files.size();
                for (int i = 0; i < size; ++i) {
                    EipTBlogFile file = (EipTBlogFile)files.get(i);
                    String realname = file.getTitle();
                    DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
                    filebean = new FileuploadBean();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(realname);
                    if (hData != null) {
                        filebean.setContentType(hData.getContentType());
                    }
                    filebean.setIsImage(FileuploadUtils.isImage((String)realname));
                    attachmentFileList.add(filebean);
                }
                rd.setAttachmentFiles(attachmentFileList);
            }
            if (record.getOwnerId() == this.uid) {
                record.setUpdateDate(Calendar.getInstance().getTime());
                Database.commit();
            }
            this.loadAggregateUsers();
            return rd;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"blog", (Throwable)ex);
            return null;
        }
    }

    public List<BlogThemaResultData> getThemaList() {
        return this.themaList;
    }

    public int getLoginUid() {
        return this.uid;
    }

    public int getViewUid() {
        return this.view_uid;
    }

    public ALStringField getViewUname() {
        return this.view_uname;
    }

    public int getEntrySum() {
        return this.entrySum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("thema", "THEMA_ID");
        return map;
    }

    public List<BlogCommentResultData> getCommentList() {
        return this.commentList;
    }

    public List<BlogFootmarkResultData> getFootmarkList() {
        return this.footmarkList;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public int getUserId() {
        return this.uid;
    }

    public boolean hasPhoto() {
        return this.has_photo;
    }

    public String getUserAccountURI() {
        return this.userAccountURI;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public ALStringField getKeyword() {
        return this.keyword;
    }

    public String getThemeId() {
        return this.themeId;
    }

    public List<BlogUserResultData> getUserList() {
        return this.userList;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public boolean getDeletable() {
        return this.deletable;
    }

    public boolean getOtherCommentDeletable() {
        return this.other_comment_deletable;
    }

    public boolean getCommentDeletable() {
        return this.comment_deletable;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        boolean result = super.doViewList(action, rundata, context);
        this.loadAggregateUsers();
        return result;
    }

    protected void loadAggregateUsers() {
        ALEipManager.getInstance().getUsers(this.users);
    }
}

