/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog.util;

import com.aimluck.commons.utils.ALDeleteFileUtil;
import com.aimluck.eip.blog.BlogThemaResultData;
import com.aimluck.eip.blog.BlogUserResultData;
import com.aimluck.eip.cayenne.om.portlet.EipTBlog;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFile;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogUtils.class.getName());
    public static final String DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm";
    public static final String TARGET_GROUP_NAME = "target_group_name";
    public static final String OWNER_ID = "ownerid";
    public static final String SEARCH_WORD = "keyword";
    public static final String GROUP_ID = "groupid";
    public static final String THEME_ID = "themeid";
    public static final String ATTACHMENT_TEMP_FILENAME = "file";
    public static final String ATTACHMENT_TEMP_FILENAME_REMAIND = "file.txt";
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    public static final String FOLDER_FILEDIR_BLOG = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    public static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.blog.categorykey", (String)"");
    public static final String PREFIX_DBFILE = "DBF";
    public static final String BLOG_PORTLET_NAME = "Blog";

    public static EipTBlogEntry getEipTBlogEntry(RunData rundata, Context context) throws ALDBErrorException {
        String entryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (entryid == null || Integer.valueOf(entryid) == null) {
                logger.debug((Object)"[Blog Entry] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTBlogEntry.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"ENTRY_ID", (Object)Integer.valueOf(entryid));
            query.setQualifier(exp);
            List entrys = query.fetchList();
            if (entrys == null || entrys.size() == 0) {
                logger.debug((Object)"[Blog Entry] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTBlogEntry)entrys.get(0);
        }
        catch (ALPageNotFoundException ex) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getEipTBlogEntry", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTBlogThema getEipTBlogThema(RunData rundata, Context context) {
        String themaid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (themaid == null || Integer.valueOf(themaid) == null) {
                logger.debug((Object)"[Blog] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTBlogThema.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"THEMA_ID", (Object)Integer.valueOf(themaid));
            query.setQualifier(exp);
            List themas = query.fetchList();
            if (themas == null || themas.size() == 0) {
                logger.debug((Object)"[Blog] Not found ID...");
                return null;
            }
            return (EipTBlogThema)themas.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getEipTBlogThema", (Throwable)ex);
            return null;
        }
    }

    public static EipTBlogThema getEipTBlogThema(Long thema_id) {
        try {
            EipTBlogThema thema = (EipTBlogThema)Database.get(EipTBlogThema.class, (Object)thema_id);
            return thema;
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getEipTBlogThema", (Throwable)ex);
            return null;
        }
    }

    public static EipTBlog getEipTBlog(RunData rundata, Context context) {
        try {
            int uid = ALEipUtils.getUserId((RunData)rundata);
            SelectQuery query = Database.query(EipTBlog.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)uid);
            query.setQualifier(exp);
            List blogs = query.fetchList();
            if (blogs == null || blogs.size() == 0) {
                logger.debug((Object)"[Blog Entry] Not found ID...");
                return null;
            }
            return (EipTBlog)blogs.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getEipTBlog", (Throwable)ex);
            return null;
        }
    }

    public static EipTBlogComment getEipTBlogComment(RunData rundata, Context context, String commentid) throws ALPageNotFoundException, ALDBErrorException {
        try {
            if (commentid == null || Integer.valueOf(commentid) == null) {
                logger.debug((Object)"[BlogUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTBlogComment.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"COMMENT_ID", (Object)Integer.valueOf(commentid));
            query.setQualifier(exp1);
            List comments = query.fetchList();
            if (comments == null || comments.size() == 0) {
                logger.debug((Object)"[BlogUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTBlogComment)comments.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getEipTBlogComment", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTBlogFile getEipTBlogFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int ownerid = rundata.getParameters().getInt(OWNER_ID, -1);
            int entryid = rundata.getParameters().getInt("entityid", -1);
            int fileid = rundata.getParameters().getInt("attachmentIndex", -1);
            if (ownerid <= 0 || entryid <= 0 || fileid <= 0) {
                logger.debug((Object)"[BlogUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTBlogFile.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)fileid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ownerid);
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchDbExp((String)"ENTRY_ID", (Object)entryid);
            query.andQualifier(exp3);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[BlogUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTBlogFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getEipTBlogFile", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTBlogEntry getEipTBlogParentEntry(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String entryid = rundata.getParameters().getString("entityid");
        try {
            if (entryid == null || Integer.valueOf(entryid) == null) {
                logger.debug((Object)"[BlogUtil] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTBlogEntry.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"ENTRY_ID", (Object)Integer.valueOf(entryid));
            query.setQualifier(exp);
            List entrys = query.fetchList();
            if (entrys == null || entrys.size() == 0) {
                logger.debug((Object)"[BlogUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            EipTBlogEntry entry = (EipTBlogEntry)entrys.get(0);
            return entry;
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getEipTBlogParentEntry", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<BlogThemaResultData> getThemaList(RunData rundata, Context context) {
        ArrayList<BlogThemaResultData> themaList = new ArrayList<BlogThemaResultData>();
        try {
            SelectQuery query = Database.query(EipTBlogThema.class);
            query.orderAscending("themaName");
            List aList = query.fetchList();
            int size = aList.size();
            BlogThemaResultData lastRd = new BlogThemaResultData();
            lastRd.initField();
            for (int i = 0; i < size; ++i) {
                EipTBlogThema record = (EipTBlogThema)aList.get(i);
                if (record.getThemaId() != 1) {
                    BlogThemaResultData rd = new BlogThemaResultData();
                    rd.initField();
                    rd.setThemaId(record.getThemaId().longValue());
                    rd.setThemaName(record.getThemaName());
                    themaList.add(rd);
                    continue;
                }
                lastRd.setThemaId(record.getThemaId().longValue());
                lastRd.setThemaName(record.getThemaName());
            }
            themaList.add(lastRd);
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getThemaList", (Throwable)ex);
            return null;
        }
        return themaList;
    }

    public static String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = rundata.getParameters().getString(TARGET_GROUP_NAME);
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME);
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    public static List<BlogUserResultData> getBlogUserResultDataList(String groupname) {
        ArrayList<BlogUserResultData> list = new ArrayList<BlogUserResultData>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, B.HAS_PHOTO, B.PHOTO_MODIFIED, D.POSITION ");
        statement.append("FROM turbine_user_group_role as A ");
        statement.append("LEFT JOIN turbine_user as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN eip_m_user_position as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = #bind($groupname) ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        try {
            List ulist = Database.sql(TurbineUser.class, (String)query).param("groupname", (Object)groupname).fetchListAsDataRow();
            int recNum = ulist.size();
            for (int j = 0; j < recNum; ++j) {
                DataRow dataRow = (DataRow)ulist.get(j);
                BlogUserResultData user = new BlogUserResultData();
                user.initField();
                user.setUserId((Integer)Database.getFromDataRow((DataRow)dataRow, (Object)"USER_ID"));
                user.setName((String)Database.getFromDataRow((DataRow)dataRow, (Object)"LOGIN_NAME"));
                user.setAliasName((String)Database.getFromDataRow((DataRow)dataRow, (Object)"FIRST_NAME"), (String)Database.getFromDataRow((DataRow)dataRow, (Object)"LAST_NAME"));
                user.setHasPhoto("T".equals(Database.getFromDataRow((DataRow)dataRow, (Object)"HAS_PHOTO")));
                Object photoModified = Database.getFromDataRow((DataRow)dataRow, (Object)"PHOTO_MODIFIED");
                Date date = new Date();
                try {
                    date = (Date)photoModified;
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                user.setPhotoModified(date.getTime());
                list.add(user);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getBlogUserResultDataList", (Throwable)ex);
        }
        return list;
    }

    public static ALBaseUser getBaseUser(int userid) {
        String uid = String.valueOf(userid);
        try {
            if ("".equals(uid)) {
                logger.debug((Object)"Empty ID...");
                return null;
            }
            return (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(uid));
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getBaseUser", (Throwable)ex);
            return null;
        }
    }

    public static String getUserFullName(int userid) {
        String userName = "";
        ALBaseUser user = BlogUtils.getBaseUser(userid);
        if (user != null) {
            userName = new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString();
        }
        return userName;
    }

    public static String compressString(String src) {
        int allowed_max_length_added_tags;
        int ALLOWED_MAX_LENGTH = 100;
        if (src == null || src.length() <= 100) {
            return src;
        }
        String a = "<a .+?>";
        String _a = "</a>";
        String wbr = "<wbr/>|<wbr>|<wbr />";
        StringBuilder sb = new StringBuilder();
        sb.append(a);
        sb.append("|");
        sb.append(_a);
        sb.append("|");
        sb.append(wbr);
        String regex = sb.toString();
        Matcher m = Pattern.compile(regex).matcher(src);
        for (allowed_max_length_added_tags = 100; m.find() && m.start() < allowed_max_length_added_tags; allowed_max_length_added_tags += m.group().length()) {
        }
        if (src.length() > allowed_max_length_added_tags) {
            src = src.substring(0, allowed_max_length_added_tags);
            Matcher am = Pattern.compile(a).matcher(src);
            int stt_a = 0;
            while (am.find()) {
                ++stt_a;
            }
            Matcher _am = Pattern.compile(_a).matcher(src);
            int end_a = 0;
            while (_am.find()) {
                ++end_a;
            }
            for (int i = 0; i < stt_a - end_a; ++i) {
                src = src.concat("</a>");
            }
            src = src.concat(ALLocalizationUtils.getl10n((String)"WAR_LONG_ROUND"));
        }
        return src;
    }

    public static String getPortletURIinPersonalConfigPane(RunData rundata, String portletEntryName) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getParent().equals(portletEntryName)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId() + "," + entries[j].getId()).addQueryData("action", "controls.Restore");
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getPortletURIinPersonalConfigPane", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static void deleteFiles(int timelineId, String orgId, int uid, List<String> fpaths) throws ALFileNotRemovedException {
        ALDeleteFileUtil.deleteFiles((int)timelineId, (String)"eipTBlogEntry", (String)BlogUtils.getSaveDirPath(orgId, uid), fpaths, EipTBlogFile.class);
    }

    public static String getSaveDirPath(String orgId, int uid) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR_BLOG, (String)(CATEGORY_KEY + ALStorageService.separator() + uid));
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<FileuploadLiteBean> getFileuploadList(RunData rundata) {
        String[] fileids = rundata.getParameters().getStrings("attachments");
        if (fileids == null) {
            return null;
        }
        ArrayList<String> hadfileids = new ArrayList<String>();
        ArrayList<String> newfileids = new ArrayList<String>();
        for (int j = 0; j < fileids.length; ++j) {
            if (fileids[j].trim().startsWith("s")) {
                hadfileids.add(fileids[j].trim().substring(1));
                continue;
            }
            newfileids.add(fileids[j].trim());
        }
        ArrayList<FileuploadLiteBean> fileNameList = new ArrayList<FileuploadLiteBean>();
        FileuploadLiteBean filebean = null;
        int fileid = 0;
        if (newfileids.size() > 0) {
            String folderName = rundata.getParameters().getString("folderName");
            if (folderName == null || folderName.equals("")) {
                return null;
            }
            int length = newfileids.size();
            for (int i = 0; i < length; ++i) {
                if (newfileids.get(i) == null || ((String)newfileids.get(i)).equals("")) continue;
                try {
                    fileid = Integer.parseInt((String)newfileids.get(i));
                }
                catch (Exception e) {
                    continue;
                }
                if (fileid == 0) {
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName("photo");
                    filebean.setFileName("\u4ee5\u524d\u306e\u5199\u771f\u30d5\u30a1\u30a4\u30eb");
                    fileNameList.add(filebean);
                    continue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(ALStorageService.getTmpFile((int)ALEipUtils.getUserId((RunData)rundata), (String)folderName, (String)(fileid + ".txt")), FILE_ENCODING));
                    String line = reader.readLine();
                    if (line == null || line.length() <= 0) continue;
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName(fileids[i]);
                    filebean.setFileId(fileid);
                    filebean.setFileName(line);
                    fileNameList.add(filebean);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"BlogUtils.getFileuploadList", (Throwable)e);
                    continue;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"BlogUtils.getFileuploadList", (Throwable)e);
                    }
                }
            }
        }
        if (hadfileids.size() > 0) {
            ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
            for (int k = 0; k < hadfileids.size(); ++k) {
                try {
                    fileid = Integer.parseInt((String)hadfileids.get(k));
                    hadfileidsValue.add(fileid);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                SelectQuery reqquery = Database.query(EipTBlogFile.class);
                Expression reqexp1 = ExpressionFactory.inDbExp((String)"FILE_ID", hadfileidsValue);
                reqquery.setQualifier(reqexp1);
                List requests = reqquery.fetchList();
                int requestssize = requests.size();
                for (int i = 0; i < requestssize; ++i) {
                    EipTBlogFile file = (EipTBlogFile)requests.get(i);
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(file.getTitle());
                    filebean.setFlagNewFile(false);
                    fileNameList.add(filebean);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"BlogUtils.getFileuploadList", (Throwable)ex);
            }
        }
        return fileNameList;
    }

    public static List<EipTBlogFile> getEipTBlogFileList(int entryId) {
        try {
            SelectQuery query = Database.query(EipTBlogFile.class);
            Expression exp = ExpressionFactory.matchExp((String)"eipTBlogEntry", (Object)entryId);
            query.setQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                return null;
            }
            return files;
        }
        catch (Exception ex) {
            logger.error((Object)"BlogUtils.getEipTBlogFileList", (Throwable)ex);
            return null;
        }
    }

    public static boolean hasMinimumAuthority(RunData rundata) {
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "blog_entry_self", 1);
        if (!hasAuthority) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        return true;
    }

    public static void createNewBlogActivity(EipTBlogEntry blog, String loginName, boolean isNew) {
        ALActivity RecentActivity = ALActivity.getRecentActivity((String)BLOG_PORTLET_NAME, (int)blog.getEntryId(), (float)0.0f);
        boolean isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
        String title = "\u30d6\u30ed\u30b0\u300c" + blog.getTitle() + (isNew ? "\u300d\u3092\u66f8\u304d\u307e\u3057\u305f\u3002" : "\u300d\u3092\u7de8\u96c6\u3057\u307e\u3057\u305f\u3002");
        String portletParams = "?template=BlogDetailScreen" + "&entityid=" + blog.getEntryId();
        ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(BLOG_PORTLET_NAME).withLoginName(loginName).withUserId(blog.getOwnerId().intValue()).withPortletParams(portletParams).withTitle(title).withPriority(0.0f).withExternalId(String.valueOf(blog.getEntryId())));
        if (isDeletePrev) {
            RecentActivity.delete();
        }
    }

    public static void createNewBlogTopicActivity(EipTBlogEntry blog, String loginName, List<String> recipient, EipTBlogComment blogcomment) {
        boolean isDeletePrev;
        ALActivity RecentActivity = ALActivity.getRecentActivity((String)BLOG_PORTLET_NAME, (int)blog.getEntryId(), (float)1.0f);
        boolean bl = isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
        if (recipient != null) {
            StringBuilder b = new StringBuilder("\u30d6\u30ed\u30b0\u300c");
            b.append(ALCommonUtils.compressString((String)blog.getTitle(), (int)30)).append("\u300d").append("\u306b\u30b3\u30e1\u30f3\u30c8\u3057\u307e\u3057\u305f\u3002");
            String portletParams = "?template=BlogDetailScreen" + "&entityid=" + blog.getEntryId();
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(BLOG_PORTLET_NAME).withUserId(blogcomment.getOwnerId().intValue()).withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipient).withTitle(b.toString()).withPriority(1.0f).withExternalId(String.valueOf(blog.getEntryId())));
        } else {
            StringBuilder b = new StringBuilder("\u30d6\u30ed\u30b0\u300c");
            b.append(ALCommonUtils.compressString((String)blog.getTitle(), (int)30)).append("\u300d").append("\u306b\u30b3\u30e1\u30f3\u30c8\u3057\u307e\u3057\u305f\u3002");
            String portletParams = "?template=MsgboardTopicDetailScreen" + "&entityid=" + blog.getEntryId();
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(BLOG_PORTLET_NAME).withUserId(blogcomment.getOwnerId().intValue()).withLoginName(loginName).withPortletParams(portletParams).withTitle(b.toString()).withPriority(1.0f).withExternalId(String.valueOf(blog.getEntryId())));
        }
        if (isDeletePrev) {
            RecentActivity.delete();
        }
    }

    public static void createNewCommentActivity(EipTBlogEntry blog, String loginName, EipTBlogComment blogcomment) {
        BlogUtils.createNewCommentActivity(blog, loginName, null, blogcomment);
    }

    public static void createNewCommentActivity(EipTBlogEntry blog, String loginName, List<String> recipients, EipTBlogComment blogcomment) {
        String title = "\u30d6\u30ed\u30b0\u300c" + ALCommonUtils.compressString((String)blog.getTitle(), (int)30) + "\u300d\u306b" + "\u30b3\u30e1\u30f3\u30c8\u3057\u307e\u3057\u305f\u3002";
        String portletParams = "?template=BlogDetailScreen" + "&entityid=" + blog.getEntryId();
        if (recipients != null && recipients.size() > 0) {
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(BLOG_PORTLET_NAME).withUserId(blogcomment.getOwnerId().intValue()).withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipients).withTitle(title).withPriority(0.0f).withExternalId(String.valueOf(blog.getEntryId())));
        } else {
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withUserId(blogcomment.getOwnerId().intValue()).withAppId(BLOG_PORTLET_NAME).withLoginName(loginName).withPortletParams(portletParams).withTitle(title).withPriority(0.0f).withExternalId(String.valueOf(blog.getEntryId())));
        }
    }

    public static String getOwnerId(RunData rundata, Context context) {
        String ownerId = null;
        String ownerIdParam = rundata.getParameters().getString(OWNER_ID);
        ownerId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)OWNER_ID);
        if (ownerIdParam == null && ownerId == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)OWNER_ID, (String)"all");
            ownerId = "all";
        } else if (ownerIdParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)OWNER_ID, (String)ownerIdParam);
            ownerId = ownerIdParam;
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)SEARCH_WORD, (String)"");
        }
        return ownerId;
    }

    public static String getKeyword(RunData rundata, Context context) {
        String keyword = null;
        String keywordParm = rundata.getParameters().getString(SEARCH_WORD);
        keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)SEARCH_WORD);
        if (keywordParm == null && keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)SEARCH_WORD, (String)"");
            keyword = "";
        } else if (keywordParm != null) {
            keywordParm = keywordParm.trim();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)SEARCH_WORD, (String)keywordParm);
            keyword = keywordParm;
        }
        return keyword;
    }

    public static String getThemeId(RunData rundata, Context context) {
        String themeId = null;
        String themeIdParam = rundata.getParameters().getString(THEME_ID);
        themeId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)THEME_ID);
        if (themeIdParam == null && themeId == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)THEME_ID, (String)"all");
            themeId = "all";
        } else if (themeIdParam != null) {
            themeIdParam = themeIdParam.trim();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)THEME_ID, (String)themeIdParam);
            themeId = themeIdParam;
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)SEARCH_WORD, (String)"");
        }
        return themeId;
    }

    public static String getGroupId(RunData rundata, Context context) {
        String groupId = null;
        String groupIdParam = rundata.getParameters().getString(GROUP_ID);
        groupId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)GROUP_ID);
        if (groupIdParam == null && groupId == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)GROUP_ID, (String)"LoginUser");
            groupId = "LoginUser";
        } else if (groupIdParam != null) {
            groupIdParam = groupIdParam.trim();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)GROUP_ID, (String)groupIdParam);
            groupId = groupIdParam;
        }
        return groupId;
    }

    public static SelectQuery<EipTBlogEntry> buildSelectQueryForBlogFilter(SelectQuery<EipTBlogEntry> query, RunData rundata, Context context) {
        String themeId;
        String ownerId = BlogUtils.getOwnerId(rundata, context);
        if (!ownerId.equals("all")) {
            Expression exp = ExpressionFactory.matchDbExp((String)"OWNER_ID", (Object)ownerId);
            query.andQualifier(exp);
        }
        if (!(themeId = BlogUtils.getThemeId(rundata, context)).equals("all")) {
            Expression exp = ExpressionFactory.matchExp((String)"eipTBlogThema", (Object)themeId);
            query.andQualifier(exp);
        }
        String queryKeyword = BlogUtils.getKeyword(rundata, context);
        String[] keywords = queryKeyword.split("[ \u3000]");
        for (int i = 0; i < keywords.length; ++i) {
            String keyword = keywords[i];
            if (keyword.length() <= 0) continue;
            String keywordExp = MessageFormat.format("%{0}%", keyword);
            Expression exp1 = ExpressionFactory.likeExp((String)"title", (Object)keywordExp);
            Expression exp2 = ExpressionFactory.likeExp((String)"note", (Object)keywordExp);
            Expression exp = exp1.orExp(exp2);
            query.andQualifier(exp);
        }
        return query;
    }

    public static boolean checkPermission(RunData rundata, Context context, int defineAclType, String pfeature) {
        if (defineAclType == 0) {
            return true;
        }
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), pfeature, defineAclType);
        return hasAuthority;
    }

    public static int getViewId(RunData rundata, Context context, int uid) throws ALDBErrorException {
        int view_uid = -1;
        EipTBlogEntry record = BlogUtils.getEipTBlogEntry(rundata, context);
        view_uid = record != null ? record.getOwnerId() : (rundata.getParameters().containsKey((Object)"view_uid") ? Integer.parseInt(rundata.getParameters().getString("view_uid")) : uid);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_uid", (String)String.valueOf(view_uid));
        return view_uid;
    }

    public static int getCommentViewId(RunData rundata, Context context, int uid, String commentid) throws ALDBErrorException, ALPageNotFoundException {
        int view_uid = -1;
        EipTBlogComment record = BlogUtils.getEipTBlogComment(rundata, context, commentid);
        view_uid = record != null ? record.getOwnerId() : (rundata.getParameters().containsKey((Object)"comment_view_uid") ? Integer.parseInt(rundata.getParameters().getString("comment_view_uid")) : uid);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"comment_view_uid", (String)String.valueOf(view_uid));
        return view_uid;
    }
}

