/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.blog;

import com.aimluck.eip.blog.BlogCommonThemaSelectData;
import com.aimluck.eip.blog.BlogEntryCommentFormData;
import com.aimluck.eip.blog.BlogEntryFormData;
import com.aimluck.eip.blog.BlogEntryLatestSelectData;
import com.aimluck.eip.blog.BlogEntrySelectData;
import com.aimluck.eip.blog.BlogThemaFormData;
import com.aimluck.eip.blog.BlogThemaSelectData;
import com.aimluck.eip.blog.BlogUserSelectData;
import com.aimluck.eip.blog.BlogWordSelectData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.modules.actions.blog.BlogAction;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellBlogAction
extends BlogAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellBlogAction.class.getName());
    private final String RESULT_ON_COMMENT_DETAIL = "resultOnCommentDetail";
    private final String ERROR_MESSAGE_LIST_ON_COMMENT_DETAIL = "errmsgsOnCommentDetail";
    private Object resultOnCommentDetail;
    private List<String> errmsgListOnCommentDetail;

    @Override
    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
    }

    @Override
    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        String mode = rundata.getParameters().getString("mode");
        try {
            if ("form".equals(mode)) {
                this.doBlog_entry_form(rundata, context);
            } else if ("detail".equals(mode)) {
                this.doBlog_entry_detail(rundata, context);
            } else if ("list".equals(mode)) {
                this.doBlog_entry_list(rundata, context);
            } else if ("thema_detail".equals(mode)) {
                this.doBlog_thema_detail(rundata, context);
            } else if ("reply".equals(mode)) {
                this.doBlog_entry_reply_form(rundata, context);
            } else if (this.getMode() == null) {
                this.doBlog_entry_list(rundata, context);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
        }
    }

    @Override
    public void doBlog_entry_form(RunData rundata, Context context) throws Exception {
        BlogEntryFormData formData = new BlogEntryFormData();
        formData.initField();
        formData.loadThemaList(rundata, context);
        formData.doViewForm((ALAction)this, rundata, context);
        this.setTemplate(rundata, "blog-entry-form");
    }

    @Override
    public void doBlog_entry_insert(RunData rundata, Context context) throws Exception {
        BlogEntryFormData formData = new BlogEntryFormData();
        formData.initField();
        formData.loadThemaList(rundata, context);
        if (formData.doInsert((ALAction)this, rundata, context)) {
            this.doBlog_entry_list(rundata, context);
        } else {
            this.setTemplate(rundata, "blog-entry-form");
        }
    }

    @Override
    public void doBlog_entry_update(RunData rundata, Context context) throws Exception {
        BlogEntryFormData formData = new BlogEntryFormData();
        formData.initField();
        formData.loadThemaList(rundata, context);
        if (formData.doUpdate((ALAction)this, rundata, context)) {
            this.doBlog_entry_list(rundata, context);
        } else {
            this.setTemplate(rundata, "blog-entry-form");
        }
    }

    @Override
    public void doBlog_entry_delete(RunData rundata, Context context) throws Exception {
        BlogEntryFormData formData = new BlogEntryFormData();
        formData.initField();
        if (formData.doDelete((ALAction)this, rundata, context)) {
            this.doBlog_entry_list(rundata, context);
        }
    }

    @Override
    public void doBlog_entry_list(RunData rundata, Context context) throws Exception {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_month");
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_uid");
        if (BlogUtils.hasMinimumAuthority(rundata)) {
            this.doBlog_entry_list_latest(rundata, context);
        }
    }

    @Override
    public void doBlog_entry_list_user(RunData rundata, Context context) throws Exception {
        int userid = ALEipUtils.getUserId((RunData)rundata);
        if (rundata.getParameters().getString("view_uid") == null) {
            rundata.getParameters().setString("view_uid", String.valueOf(userid));
        } else {
            userid = Integer.parseInt(rundata.getParameters().getString("view_uid"));
        }
        context.put("view_uid", (Object)ALEipUtils.getALEipUser((int)userid).getUserId().toString());
        context.put("view_title", (Object)(ALEipUtils.getALEipUser((int)userid).getAliasName().toString() + "\u306e\u30d6\u30ed\u30b0"));
        SelectQuery query = Database.query(TurbineUser.class);
        Expression exp1 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)Integer.toString(1));
        Expression exp2 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)Integer.toString(2));
        Expression exp3 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)Integer.toString(3));
        Expression exp11 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        query.setQualifier(exp1.andExp(exp2.andExp(exp3.andExp(exp11))));
        List list = ALEipUtils.getUsersFromSelectQuery((SelectQuery)query);
        context.put("users", (Object)list);
        BlogEntrySelectData listData = new BlogEntrySelectData();
        listData.initField();
        listData.loadThemaList(rundata, context);
        listData.setRowsNum(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1b-rows")));
        listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3a-strlen")));
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "blog-entry-list-user");
    }

    @Override
    public void doBlog_entry_list_latest(RunData rundata, Context context) throws Exception {
        BlogEntryLatestSelectData listData = new BlogEntryLatestSelectData();
        listData.initField();
        listData.setRowsNum(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1b-rows")));
        listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3a-strlen")));
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "blog-entry-list");
    }

    @Override
    public void doBlog_entry_detail(RunData rundata, Context context) throws Exception {
        String mode = rundata.getParameters().getString("mode");
        BlogEntrySelectData detailData = new BlogEntrySelectData();
        detailData.initField();
        if (detailData.doViewDetail((ALAction)this, rundata, context)) {
            BlogEntryCommentFormData formData = new BlogEntryCommentFormData();
            formData.initField();
            formData.doViewForm((ALAction)this, rundata, context);
            if (mode.equals("delete")) {
                this.setTemplate(rundata, "blog-entry-delete-confirm");
            } else {
                this.setTemplate(rundata, "blog-entry-detail");
            }
        } else {
            this.doBlog_entry_list(rundata, context);
        }
    }

    public void doBlog_entry_reply_form(RunData rundata, Context context) throws Exception {
        BlogEntryCommentFormData formData = new BlogEntryCommentFormData();
        formData.initField();
        this.putData(rundata, context);
        formData.doViewForm((ALAction)this, rundata, context);
        this.setTemplate(rundata, "blog-entry-reply-form");
    }

    @Override
    public void doBlog_entry_reply(RunData rundata, Context context) throws Exception {
        BlogEntryCommentFormData formData = new BlogEntryCommentFormData();
        formData.initField();
        if (formData.doInsert((ALAction)this, rundata, context)) {
            rundata.getParameters().setString("entityid", rundata.getParameters().get("entryid"));
            this.doBlog_entry_detail(rundata, context);
        } else {
            this.setTemplate(rundata, "blog-entry-reply-form");
        }
    }

    @Override
    public void doBlog_entry_comment_delete(RunData rundata, Context context) throws Exception {
        BlogEntryCommentFormData formData = new BlogEntryCommentFormData();
        formData.initField();
        if (formData.doDelete((ALAction)this, rundata, context)) {
            this.doBlog_entry_detail(rundata, context);
        }
    }

    public void doBlog_group_list(RunData rundata, Context context) throws Exception {
        BlogUserSelectData listData = new BlogUserSelectData();
        listData.initField();
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "blog-group-list");
    }

    public void doBlog_common_thema_list(RunData rundata, Context context) throws Exception {
        BlogCommonThemaSelectData listData = new BlogCommonThemaSelectData();
        listData.initField();
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "blog-common-thema-list");
    }

    public void doBlog_common_thema_detail(RunData rundata, Context context) throws Exception {
        BlogCommonThemaSelectData detailData = new BlogCommonThemaSelectData();
        detailData.initField();
        if (detailData.doViewDetail((ALAction)this, rundata, context)) {
            this.setTemplate(rundata, "blog-common-thema-detail");
        } else {
            this.doBlog_common_thema_list(rundata, context);
        }
    }

    @Override
    public void doBlog_thema_form(RunData rundata, Context context) throws Exception {
        BlogThemaFormData formData = new BlogThemaFormData();
        formData.initField();
        formData.doViewForm((ALAction)this, rundata, context);
        this.setTemplate(rundata, "blog-thema-form");
    }

    @Override
    public void doBlog_thema_insert(RunData rundata, Context context) throws Exception {
        BlogThemaFormData formData = new BlogThemaFormData();
        formData.initField();
        if (formData.doInsert((ALAction)this, rundata, context)) {
            this.doBlog_thema_list(rundata, context);
        } else {
            this.setTemplate(rundata, "blog-thema-form");
        }
    }

    @Override
    public void doBlog_thema_update(RunData rundata, Context context) throws Exception {
        BlogThemaFormData formData = new BlogThemaFormData();
        formData.initField();
        if (formData.doUpdate((ALAction)this, rundata, context)) {
            this.doBlog_thema_list(rundata, context);
        } else {
            this.setTemplate(rundata, "blog-thema-form");
        }
    }

    @Override
    public void doBlog_thema_delete(RunData rundata, Context context) throws Exception {
        BlogThemaFormData formData = new BlogThemaFormData();
        formData.initField();
        if (formData.doDelete((ALAction)this, rundata, context)) {
            this.doBlog_thema_list(rundata, context);
        }
    }

    @Override
    public void doBlog_thema_list(RunData rundata, Context context) throws Exception {
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        BlogThemaSelectData listData = new BlogThemaSelectData();
        listData.initField();
        listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p1c-rows")));
        listData.setStrLength(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p4a-strlen")));
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "blog-thema-list");
    }

    @Override
    public void doBlog_thema_detail(RunData rundata, Context context) throws Exception {
        BlogThemaSelectData detailData = new BlogThemaSelectData();
        detailData.initField();
        if (detailData.doViewDetail((ALAction)this, rundata, context)) {
            this.setTemplate(rundata, "blog-thema-detail");
        } else {
            this.doBlog_thema_list(rundata, context);
        }
        this.setTemplate(rundata, "blog-thema-detail");
    }

    public void doBlog_search_list(RunData rundata, Context context) throws Exception {
        BlogWordSelectData listData = new BlogWordSelectData();
        listData.setRowsNum(20);
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "blog-search-list");
    }

    @Override
    public void setResultDataOnCommentDetail(Object obj) {
        this.resultOnCommentDetail = obj;
    }

    @Override
    public void addErrorMessagesOnCommentDetail(List<String> msgs) {
        if (this.errmsgListOnCommentDetail == null) {
            this.errmsgListOnCommentDetail = new ArrayList<String>();
        }
        this.errmsgListOnCommentDetail.addAll(msgs);
    }

    @Override
    public void putDataOnCommentDetail(RunData rundata, Context context) {
        context.put("resultOnCommentDetail", this.resultOnCommentDetail);
        context.put("errmsgsOnCommentDetail", this.errmsgListOnCommentDetail);
        context.put("secid", rundata.getUser().getTemp("secid"));
        String entityid = rundata.getParameters().get("entityid");
        if (entityid != null && !"".equals(entityid)) {
            context.put("entityid", (Object)entityid);
        } else {
            context.put("entityid", (Object)rundata.getParameters().get("entryid"));
        }
    }

    private void clearBlogSession(RunData rundata, Context context) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("entityid");
        list.add("view_uid");
        list.add("target_group_name");
        list.add("Blogsword");
        list.add("com.aimluck.eip.blog.BlogWordSelectDatasort");
        list.add("com.aimluck.eip.blog.BlogEntrySelectDatafilter");
        list.add("com.aimluck.eip.blog.BlogEntrySelectDatafiltertype");
        list.add("com.aimluck.eip.blog.BlogThemaSelectDatasort");
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, list);
    }
}

