/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.CodeHelper;
import org.exolab.castor.builder.types.XSInteger;
import org.exolab.javasource.JSourceCode;

public class IntegerCodeHelper
implements CodeHelper {
    XSInteger xsInteger = null;

    public IntegerCodeHelper(XSInteger xSInteger) {
        this.xsInteger = xSInteger;
    }

    public void generateToStringCode(String string, JSourceCode jSourceCode) {
        jSourceCode.append("Integer.toString(");
        jSourceCode.append(string);
        jSourceCode.append(")");
    }

    public void generateValidationCode(String string, JSourceCode jSourceCode) {
        boolean bl;
        Integer n;
        if (this.xsInteger == null) {
            return;
        }
        jSourceCode.add("//-- validation code for integer: ");
        jSourceCode.append(string);
        if (this.xsInteger.hasMinimum()) {
            jSourceCode.add("if (");
            jSourceCode.append(string);
            n = this.xsInteger.getMinExclusive();
            bl = true;
            if (n != null) {
                jSourceCode.append(" <= ");
            } else {
                n = this.xsInteger.getMinInclusive();
                jSourceCode.append(" < ");
                bl = false;
            }
            jSourceCode.append(n.toString());
            jSourceCode.append(") {");
            jSourceCode.indent();
            jSourceCode.add("String err = \"");
            jSourceCode.append(string.substring(1));
            jSourceCode.append(" cannot be less than ");
            if (bl) {
                jSourceCode.append("or equal to ");
            }
            jSourceCode.append(n.toString());
            jSourceCode.append("\";");
            jSourceCode.add("throw new ValidationException(err);");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        if (this.xsInteger.hasMaximum()) {
            jSourceCode.add("if (");
            jSourceCode.append(string);
            n = this.xsInteger.getMaxExclusive();
            bl = true;
            if (n != null) {
                jSourceCode.append(" >= ");
            } else {
                n = this.xsInteger.getMaxInclusive();
                jSourceCode.append(" > ");
                bl = false;
            }
            jSourceCode.append(n.toString());
            jSourceCode.append(") {");
            jSourceCode.indent();
            jSourceCode.add("String err = \"");
            jSourceCode.append(string);
            jSourceCode.append(" cannot be more than ");
            if (bl) {
                jSourceCode.append("or equal to ");
            }
            jSourceCode.append(n.toString());
            jSourceCode.append("\";");
            jSourceCode.add("throw new ValidationException(err);");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
    }
}

