/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.jdo.drivers.HsqlColumn;
import org.exolab.castor.jdo.drivers.HsqlCondition;
import org.exolab.castor.jdo.drivers.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class HsqlQueryExpression
extends JDBCQueryExpression {
    public HsqlQueryExpression(PersistenceFactory persistenceFactory) {
        super(persistenceFactory);
    }

    public final void addColumn(String string, String string2) {
        this._tables.put(string, string);
        this._cols.addElement(new HsqlColumn(string, string2));
    }

    private void addColumnList(StringBuffer stringBuffer, HsqlAliasInfo hsqlAliasInfo) {
        if (this._cols.size() == 0) {
            stringBuffer.append("1");
            return;
        }
        int n = 0;
        n = 0;
        while (n < this._cols.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.getColumnString((HsqlColumn)this._cols.elementAt(n), hsqlAliasInfo));
            ++n;
        }
        if (this._select != null) {
            if (n > 0) {
                stringBuffer.append(",").append(this._select);
            } else {
                stringBuffer.append(this._select);
            }
        }
    }

    public void addCondition(String string, String string2, String string3, String string4) {
        this._tables.put(string, string);
        this._conds.addElement(new HsqlCondition(string, string2, string3, string4));
    }

    private boolean addConditions(StringBuffer stringBuffer, HsqlAliasInfo hsqlAliasInfo, boolean bl) {
        if (this._conds.size() > 0) {
            bl = this.addWhereOrAnd(stringBuffer, bl);
            int n = 0;
            while (n < this._conds.size()) {
                if (n > 0) {
                    stringBuffer.append(" AND ");
                }
                HsqlCondition hsqlCondition = (HsqlCondition)this._conds.elementAt(n);
                stringBuffer.append(this.getConditionString(hsqlCondition, hsqlAliasInfo));
                ++n;
            }
        }
        return bl;
    }

    private void addForUpdateClause(StringBuffer stringBuffer, boolean bl) {
    }

    private void addFromClause(StringBuffer stringBuffer, HsqlAliasInfo hsqlAliasInfo) {
        stringBuffer.append(" FROM ");
        Hashtable hashtable = (Hashtable)this._tables.clone();
        boolean bl = this.addOuterJoins(stringBuffer, hashtable, hsqlAliasInfo);
        this.addTables(stringBuffer, hashtable, bl);
    }

    private void addJoin(StringBuffer stringBuffer, HsqlAliasInfo hsqlAliasInfo, JDBCQueryExpression.Join join) {
        int n = 0;
        while (n < join.leftColumns.length) {
            if (n > 0) {
                stringBuffer.append(" AND ");
            }
            String string = this.quoteTableAndColumn(join.leftTable, join.leftColumns[n]);
            stringBuffer.append(this.checkForAlias(hsqlAliasInfo, join.leftTable, string));
            stringBuffer.append("=");
            string = this.quoteTableAndColumn(join.rightTable, join.rightColumns[n]);
            stringBuffer.append(this.checkForAlias(hsqlAliasInfo, join.rightTable, string));
            ++n;
        }
    }

    private boolean addJoinClause(StringBuffer stringBuffer, HsqlAliasInfo hsqlAliasInfo) {
        boolean bl = true;
        int n = 0;
        while (n < this._joins.size()) {
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(n);
            if (!join.outer) {
                bl = this.addWhereOrAnd(stringBuffer, bl);
                this.addJoin(stringBuffer, hsqlAliasInfo, join);
            }
            ++n;
        }
        bl = this.addOuterJoins(stringBuffer, hsqlAliasInfo, bl);
        return bl;
    }

    private void addJoinTable(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(' ').append(string2);
        }
    }

    private void addOrderByClause(StringBuffer stringBuffer) {
        if (this._order != null) {
            stringBuffer.append(" ORDER BY ").append(this._order);
        }
    }

    private void addOuterJoin(StringBuffer stringBuffer, JDBCQueryExpression.Join join, HsqlAliasInfo hsqlAliasInfo) {
        String string = hsqlAliasInfo.getAliasFor(join.leftTable, join);
        String string2 = hsqlAliasInfo.getAliasFor(join.rightTable, join);
        this.addJoinTable(stringBuffer, join.leftTable, string);
        stringBuffer.append(" LEFT OUTER JOIN ");
        this.addJoinTable(stringBuffer, join.rightTable, string2);
        stringBuffer.append(" ON ").append(" (");
        String string3 = string == null ? join.leftTable : string;
        String string4 = string2 == null ? join.rightTable : string2;
        this.addOuterJoinCondition(stringBuffer, join.leftColumns, join.rightColumns, string3, string4);
        stringBuffer.append(")");
    }

    private void addOuterJoinCondition(StringBuffer stringBuffer, String[] stringArray, String[] stringArray2, String string, String string2) {
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(" AND ");
            }
            String string3 = String.valueOf(string) + "." + stringArray[n];
            stringBuffer.append(this._factory.quoteName(string3));
            stringBuffer.append("=");
            string3 = String.valueOf(string2) + "." + stringArray2[n];
            stringBuffer.append(this._factory.quoteName(string3));
            ++n;
        }
    }

    private boolean addOuterJoins(StringBuffer stringBuffer, Hashtable hashtable, HsqlAliasInfo hsqlAliasInfo) {
        boolean bl = true;
        int n = 0;
        while (n < this._joins.size()) {
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(n);
            if (join.outer) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(",");
                }
                this.addOuterJoin(stringBuffer, join, hsqlAliasInfo);
                hashtable.remove(join.leftTable);
                hashtable.remove(join.rightTable);
            }
            ++n;
        }
        return bl;
    }

    private boolean addOuterJoins(StringBuffer stringBuffer, HsqlAliasInfo hsqlAliasInfo, boolean bl) {
        Enumeration enumeration = hsqlAliasInfo.getTables();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Hashtable hashtable = hsqlAliasInfo.getAliasHash(string);
            Enumeration enumeration2 = hashtable.keys();
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)enumeration2.nextElement();
            String[] stringArray = join.leftTable.equals(string) ? join.leftColumns : join.rightColumns;
            while (enumeration2.hasMoreElements()) {
                bl = this.addWhereOrAnd(stringBuffer, bl);
                this.addOuterJoinCondition(stringBuffer, stringArray, stringArray, (String)hashtable.get(join), (String)hashtable.get(enumeration2.nextElement()));
            }
        }
        return bl;
    }

    private void addSelectClause(StringBuffer stringBuffer, HsqlAliasInfo hsqlAliasInfo) {
        stringBuffer.append("SELECT ");
        if (this._distinct) {
            stringBuffer.append(" DISTINCT ");
        }
        if (this._select == null) {
            this.addColumnList(stringBuffer, hsqlAliasInfo);
        } else {
            stringBuffer.append(this._select).append(" ");
        }
    }

    private void addTables(StringBuffer stringBuffer, Hashtable hashtable, boolean bl) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(this._factory.quoteName((String)enumeration.nextElement()));
        }
    }

    private boolean addWhere(StringBuffer stringBuffer, HsqlAliasInfo hsqlAliasInfo, boolean bl) {
        if (this._where != null) {
            bl = this.addWhereOrAnd(stringBuffer, bl);
            String string = this._where;
            Enumeration enumeration = hsqlAliasInfo.getTables();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = hsqlAliasInfo.getAnAliasFor(string2);
                string = this.substituteAlias(string, String.valueOf(string2) + '.', String.valueOf(string3) + '.');
            }
            stringBuffer.append(string);
        }
        return bl;
    }

    protected boolean addWhereClause(StringBuffer stringBuffer, HsqlAliasInfo hsqlAliasInfo, boolean bl) {
        bl = this.addConditions(stringBuffer, hsqlAliasInfo, bl);
        bl = this.addWhere(stringBuffer, hsqlAliasInfo, bl);
        return bl;
    }

    private boolean addWhereOrAnd(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            stringBuffer.append(" WHERE ");
        } else {
            stringBuffer.append(" AND ");
        }
        return false;
    }

    private String checkForAlias(HsqlAliasInfo hsqlAliasInfo, String string, String string2) {
        String string3 = hsqlAliasInfo.getAnAliasFor(string);
        if (string3 != null) {
            return this.substituteAlias(string2, string, string3);
        }
        return string2;
    }

    private String getColumnString(HsqlColumn hsqlColumn, HsqlAliasInfo hsqlAliasInfo) {
        String string = hsqlColumn.getTableName();
        String string2 = hsqlColumn.getColumnName();
        if (hsqlAliasInfo.tableExists(string)) {
            string = hsqlAliasInfo.getAnAliasFor(string);
        }
        return String.valueOf(string) + "." + string2;
    }

    private String getConditionString(HsqlCondition hsqlCondition, HsqlAliasInfo hsqlAliasInfo) {
        return String.valueOf(this.getColumnString(hsqlCondition.getColumn(), hsqlAliasInfo)) + hsqlCondition.getOperator() + hsqlCondition.getValue();
    }

    public String getStatement(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(128);
        HsqlAliasInfo hsqlAliasInfo = new HsqlAliasInfo(this._joins);
        this.addSelectClause(stringBuffer, hsqlAliasInfo);
        this.addFromClause(stringBuffer, hsqlAliasInfo);
        boolean bl2 = this.addJoinClause(stringBuffer, hsqlAliasInfo);
        this.addWhereClause(stringBuffer, hsqlAliasInfo, bl2);
        this.addOrderByClause(stringBuffer);
        this.addForUpdateClause(stringBuffer, bl);
        return stringBuffer.toString();
    }

    private String quoteTableAndColumn(String string, String string2) {
        return this._factory.quoteName(String.valueOf(string) + "." + string2);
    }

    private String substituteAlias(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 != -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    final class HsqlAliasInfo {
        private int _count = 1;
        private final Hashtable _hash;

        public HsqlAliasInfo(Vector vector) {
            this._hash = this.getRepeatedTablesInOuterJoinsHash(vector);
        }

        private void addTableCount(Hashtable hashtable, String string, JDBCQueryExpression.Join join) {
            Vector vector = null;
            if (hashtable.containsKey(string)) {
                vector = (Vector)hashtable.get(string);
            } else {
                vector = new Vector();
                hashtable.put(string, vector);
            }
            vector.addElement(join);
        }

        public String getAliasFor(String string, JDBCQueryExpression.Join join) {
            Hashtable hashtable = (Hashtable)this._hash.get(string);
            return hashtable == null ? null : (String)hashtable.get(join);
        }

        public Hashtable getAliasHash(String string) {
            return (Hashtable)this._hash.get(string);
        }

        public String getAnAliasFor(String string) {
            Hashtable hashtable = (Hashtable)this._hash.get(string);
            return hashtable == null ? null : (String)hashtable.elements().nextElement();
        }

        private Hashtable getRepeatedTablesInOuterJoinsHash(Vector vector) {
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = this.getTableCountInOuterJoinsHash(vector);
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Vector vector2 = (Vector)hashtable2.get(string);
                if (vector2.size() <= 1) continue;
                Hashtable hashtable3 = new Hashtable();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    hashtable3.put(enumeration2.nextElement(), "a" + this._count++);
                }
                hashtable.put(string, hashtable3);
            }
            return hashtable;
        }

        private Hashtable getTableCountInOuterJoinsHash(Vector vector) {
            Hashtable hashtable = new Hashtable();
            JDBCQueryExpression.Join join = null;
            int n = 0;
            while (n < vector.size()) {
                join = (JDBCQueryExpression.Join)vector.elementAt(n);
                if (join.outer) {
                    this.addTableCount(hashtable, join.leftTable, join);
                    this.addTableCount(hashtable, join.rightTable, join);
                }
                ++n;
            }
            return hashtable;
        }

        public Enumeration getTables() {
            return this._hash.keys();
        }

        public boolean tableExists(String string) {
            return this._hash.containsKey(string);
        }
    }
}

