/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.jdo.drivers.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class InformixQueryExpression
extends JDBCQueryExpression {
    public InformixQueryExpression(PersistenceFactory persistenceFactory) {
        super(persistenceFactory);
    }

    private void addForUpdateClause(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            stringBuffer.append(" FOR UPDATE");
        }
    }

    private void addFromClause(StringBuffer stringBuffer) {
        stringBuffer.append(" FROM ");
        Enumeration enumeration = this.getFromTables();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((String)enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
        }
    }

    private void addJoin(StringBuffer stringBuffer, JDBCQueryExpression.Join join) {
        int n = 0;
        while (n < join.leftColumns.length) {
            if (n > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(this.quoteTableAndColumn(join.leftTable, join.leftColumns[n]));
            stringBuffer.append("=");
            stringBuffer.append(this.quoteTableAndColumn(join.rightTable, join.rightColumns[n]));
            ++n;
        }
    }

    private boolean addJoinClause(StringBuffer stringBuffer) {
        boolean bl = true;
        int n = 0;
        while (n < this._joins.size()) {
            if (bl) {
                stringBuffer.append(" WHERE ");
                bl = false;
            } else {
                stringBuffer.append(" AND ");
            }
            this.addJoin(stringBuffer, (JDBCQueryExpression.Join)this._joins.elementAt(n));
            ++n;
        }
        return bl;
    }

    private void addOrderByClause(StringBuffer stringBuffer) {
        if (this._order != null) {
            stringBuffer.append(" ORDER BY ").append(this._order);
        }
    }

    private void addSelectClause(StringBuffer stringBuffer) {
        stringBuffer.append("SELECT ");
        if (this._distinct) {
            stringBuffer.append(" DISTINCT ");
        }
        if (this._select == null) {
            stringBuffer.append(this.getColumnList());
        } else {
            stringBuffer.append(this._select).append(" ");
        }
    }

    private Enumeration getFromTables() {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.getOuterTables();
        Object var3_3 = null;
        Enumeration enumeration = this._tables.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this._tables.get(string);
            StringBuffer stringBuffer = vector2.contains(string) ? new StringBuffer("OUTER ") : new StringBuffer();
            if (string.equals(string2)) {
                stringBuffer.append(this._factory.quoteName(string2));
            } else {
                stringBuffer.append(String.valueOf(this._factory.quoteName(string2)) + " " + this._factory.quoteName(string));
            }
            vector.addElement(this._factory.quoteName(stringBuffer.toString()));
        }
        return vector.elements();
    }

    private Vector getOuterTables() {
        Vector<String> vector = new Vector<String>();
        JDBCQueryExpression.Join join = null;
        int n = 0;
        while (n < this._joins.size()) {
            join = (JDBCQueryExpression.Join)this._joins.elementAt(n);
            if (join.outer) {
                vector.addElement(join.rightTable);
            }
            ++n;
        }
        return vector;
    }

    public String getStatement(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(128);
        this.addSelectClause(stringBuffer);
        this.addFromClause(stringBuffer);
        boolean bl2 = this.addJoinClause(stringBuffer);
        this.addWhereClause(stringBuffer, bl2);
        this.addOrderByClause(stringBuffer);
        this.addForUpdateClause(stringBuffer, bl);
        return stringBuffer.toString();
    }

    private String quoteTableAndColumn(String string, String string2) {
        return this._factory.quoteName(String.valueOf(string) + "." + string2);
    }
}

