/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class IntegerValidator
extends PatternValidator
implements TypeValidator {
    private boolean useMin = false;
    private boolean useMax = false;
    private boolean useFixed = false;
    private int min = 0;
    private int max = 0;
    private int _totalDigits = -1;
    private int fixed = 0;

    public void clearFixed() {
        this.useFixed = false;
    }

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public void setFixed(int n) {
        this.useFixed = true;
        this.fixed = n;
    }

    public void setMaxExclusive(int n) {
        this.useMax = true;
        this.max = n - 1;
    }

    public void setMaxInclusive(int n) {
        this.useMax = true;
        this.max = n;
    }

    public void setMinExclusive(int n) {
        this.useMin = true;
        this.min = n + 1;
    }

    public void setMinInclusive(int n) {
        this.useMin = true;
        this.min = n;
    }

    public void setTotalDigits(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("IntegerValidator: the totalDigits facet must be positive");
        }
        this._totalDigits = n;
    }

    public void validate(int n) throws ValidationException {
        if (this.useFixed) {
            if (n != this.fixed) {
                String string = String.valueOf(n) + " is not equal to the fixed value of " + this.fixed;
                throw new ValidationException(string);
            }
            return;
        }
        if (this.useMin && n < this.min) {
            String string = String.valueOf(n) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this.min;
            throw new ValidationException(string);
        }
        if (this.useMax && n > this.max) {
            String string = String.valueOf(n) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this.max;
            throw new ValidationException(string);
        }
        if (this._totalDigits != -1 && n % 10 != this._totalDigits) {
            String string = String.valueOf(n) + " doesn't have the correct number of digits: " + this._totalDigits;
            throw new ValidationException(string);
        }
        if (this.hasPattern()) {
            super.validate(Integer.toString(n));
        }
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "IntegerValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        int n = 0;
        try {
            n = (Integer)object;
        }
        catch (Exception exception) {
            String string = "Expecting an Integer, received instead: ";
            string = String.valueOf(string) + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(n);
    }
}

