/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.mail.MXManager;
import com.sk_jp.mail.MailUtility;
import com.sk_jp.util.ThreadPool;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Distributor {
    public static final Comparator DOMAIN_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            String string = Distributor.getDomain((InternetAddress)object);
            String string2 = Distributor.getDomain((InternetAddress)object2);
            return string.compareTo(string2);
        }
    };
    private MXManager mxManager;
    private ThreadPool pool;
    private boolean domainSorting;

    public Distributor(String[] stringArray, int n, boolean bl) {
        this.mxManager = new MXManager(stringArray);
        this.pool = new ThreadPool(n);
        this.domainSorting = bl;
    }

    public void send(Properties properties, MimeMessage mimeMessage, List list, Handler handler) {
        if (this.domainSorting) {
            Collections.sort(list, DOMAIN_COMPARATOR);
        }
        try {
            mimeMessage.setSentDate(new Date());
            mimeMessage.setHeader("X-Mailer", "ParaSender $Revision: 1.1 $");
            FilterableSender filterableSender = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                InternetAddress internetAddress = (InternetAddress)iterator.next();
                if (filterableSender != null) {
                    if (filterableSender.domainEquals(internetAddress)) {
                        filterableSender.addRecipient(internetAddress);
                        continue;
                    }
                    try {
                        this.pool.run((Runnable)filterableSender);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                filterableSender = new FilterableSender((Properties)properties.clone(), new MimeMessage(mimeMessage), internetAddress, handler);
            }
            try {
                this.pool.run(filterableSender);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (MessagingException messagingException) {
            handler.failed((Exception)((Object)messagingException), mimeMessage, null);
        }
    }

    public void waitForProceed() throws InterruptedException {
        this.pool.joinAll();
    }

    public void waitAndTerminate() throws InterruptedException {
        this.pool.terminate();
    }

    public static String getDomain(InternetAddress internetAddress) {
        String string = internetAddress.getAddress();
        return string.substring(string.lastIndexOf(64) + 1);
    }

    public static void main(String[] stringArray) throws Exception {
        Distributor distributor = new Distributor(new String[]{"ns1.qute.co.jp"}, 30, true);
        Properties properties = new Properties();
        MimeMessage mimeMessage = new MimeMessage((Session)null);
        mimeMessage.setText("");
        mimeMessage.setFrom((Address)new InternetAddress("test@sk-jp.com"));
        distributor.send(properties, mimeMessage, Distributor.getRecipients(), new Handler(){

            public boolean filter(Session session, MimeMessage mimeMessage, InternetAddress internetAddress) throws MessagingException {
                try {
                    mimeMessage.setSubject(MailUtility.encodeText(MailUtility.getPersonal(internetAddress) + " \u3055\u3093\u3078\u306e\u3066\u3059\u3068\u3081\u3044\u308b\u301c", "ISO-2022-JP", "B"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                mimeMessage.setRecipient(Message.RecipientType.TO, (Address)internetAddress);
                mimeMessage.setText(MailUtility.getPersonal(internetAddress) + " \u3055\u3093\u3078\u306e\u65e5\u672c\u8a9e\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u3066\u3059\u3068\u3067\u3059\u3002", "ISO-2022-JP");
                mimeMessage.setHeader("Content-Transfer-Encoding", "7bit");
                mimeMessage.saveChanges();
                return true;
            }

            public void completed(MimeMessage mimeMessage, InternetAddress internetAddress) {
                System.out.println("completed " + internetAddress);
            }

            public void failed(Exception exception, MimeMessage mimeMessage, InternetAddress internetAddress) {
                System.out.println("Sending failed : " + exception);
            }
        });
        distributor.waitAndTerminate();
        System.out.println("finished");
    }

    private static List getRecipients() throws AddressException {
        ArrayList<InternetAddress> arrayList = new ArrayList<InternetAddress>();
        try {
            arrayList.add(new InternetAddress("1@sk-jp.com", "\u304d\u306e\u3057\u305f", "ISO-2022-JP"));
            arrayList.add(new InternetAddress("2@sk-jp.com"));
            arrayList.add(new InternetAddress("test@example.com"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return arrayList;
    }

    private class FilterableSender
    implements Runnable {
        private String domain;
        private Session session;
        private MimeMessage message;
        private List recipients;
        private Handler handler;

        public FilterableSender(Properties properties, MimeMessage mimeMessage, InternetAddress internetAddress, Handler handler) {
            this.session = Session.getInstance((Properties)properties);
            this.message = mimeMessage;
            this.handler = handler;
            this.recipients = new ArrayList();
            this.addRecipient(internetAddress);
            this.domain = Distributor.getDomain(internetAddress);
        }

        public boolean domainEquals(InternetAddress internetAddress) {
            return this.domain.equals(Distributor.getDomain(internetAddress));
        }

        public void addRecipient(InternetAddress internetAddress) {
            this.recipients.add(internetAddress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Transport transport = this.session.getTransport("smtp");
                Distributor.this.mxManager.connect(transport, this.domain);
                try {
                    for (int i = 0; i < this.recipients.size(); ++i) {
                        InternetAddress internetAddress = (InternetAddress)this.recipients.get(i);
                        try {
                            if (!this.handler.filter(this.session, this.message, internetAddress)) continue;
                            transport.sendMessage((Message)this.message, (Address[])new InternetAddress[]{internetAddress});
                            this.handler.completed(this.message, internetAddress);
                            continue;
                        }
                        catch (Exception exception) {
                            this.handler.failed(exception, this.message, internetAddress);
                        }
                    }
                }
                finally {
                    transport.close();
                }
            }
            catch (Exception exception) {
                this.handler.failed(exception, this.message, null);
            }
        }
    }

    public static interface Handler {
        public boolean filter(Session var1, MimeMessage var2, InternetAddress var3) throws MessagingException;

        public void completed(MimeMessage var1, InternetAddress var2);

        public void failed(Exception var1, MimeMessage var2, InternetAddress var3);
    }
}

