/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.xml.DOMUtility;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Mail2DOM {
    public static Document createDefaultHTMLDocument(String string) {
        Document document = DOMUtility.createDocument();
        Element element = DOMUtility.createElement((Document)document, (String)"html", (String[][])new String[][]{{"xmlns", "http://www.w3.org/TR/xhtml1"}});
        Element element2 = document.createElement("head");
        Element element3 = document.createElement("body");
        if (string != null) {
            element2.appendChild(DOMUtility.createElement((Document)document, (String)"meta", (String[][])new String[][]{{"http-equiv", "Content-Style-Type"}, {"content", "text/css"}}));
            element2.appendChild(DOMUtility.createElement((Document)document, (String)"link", (String[][])new String[][]{{"rel", "stylesheet"}, {"href", string}, {"type", "text/css"}}));
        }
        element.appendChild(element2);
        element.appendChild(element3);
        document.appendChild(element);
        return document;
    }

    public static Element getAddressesNode(Document document, Address[] addressArray) {
        Element element = document.createElement("span");
        for (int i = 0; i < addressArray.length; ++i) {
            InternetAddress internetAddress = (InternetAddress)addressArray[i];
            Element element2 = DOMUtility.createElement((Document)document, (String)"a", (String[][])new String[][]{{"href", "mailto:" + internetAddress.getAddress()}});
            String string = internetAddress.getPersonal();
            if (string == null) {
                string = internetAddress.toString();
            }
            element2.appendChild(document.createTextNode(string));
            element.appendChild(element2);
            element.appendChild(document.createTextNode(", "));
        }
        element.removeChild(element.getLastChild());
        return element;
    }

    public static Element createHeaderTRElement(Document document, String string, Node node) {
        Element element = document.createElement("tr");
        element.appendChild(DOMUtility.createElement((Document)document, (String)"td", (String[][])new String[][]{{"class", "headername"}})).appendChild(document.createTextNode(string));
        element.appendChild(DOMUtility.createElement((Document)document, (String)"td", (String[][])new String[][]{{"class", "headervalue"}})).appendChild(node);
        return element;
    }

    public static Element createFollowupLink(Document document, MimeMessage mimeMessage, String string) {
        StringBuffer stringBuffer = new StringBuffer("mailto:");
        try {
            Address[] addressArray = mimeMessage.getReplyTo();
            if (addressArray == null) {
                addressArray = mimeMessage.getFrom();
            }
            stringBuffer.append(InternetAddress.toString((Address[])addressArray));
            stringBuffer.append("?subject=");
            stringBuffer.append(mimeMessage.getSubject());
            stringBuffer.append(":reference=");
            stringBuffer.append(mimeMessage.getHeader("In-Reply-To"));
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return DOMUtility.createLinkNode((Document)document, (String)stringBuffer.toString(), (String)string);
    }
}

