/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.mail.CorrectedContentTypeDataSource;
import com.sk_jp.mail.MailUtility;
import com.sk_jp.mail.MessageUpdateListener;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public class SKMessage
extends MimeMessage {
    private Vector listeners;

    public SKMessage() {
        super(Session.getDefaultInstance((Properties)System.getProperties(), null));
    }

    public SKMessage(Session session) {
        super(session);
    }

    public SKMessage(InputStream inputStream) throws MessagingException {
        super(Session.getDefaultInstance((Properties)System.getProperties(), null), inputStream);
    }

    public String getSubject() throws MessagingException {
        String string = this.getHeader("Subject", null);
        if (string == null) {
            return null;
        }
        return MailUtility.decodeText(MailUtility.unfold(string));
    }

    public void setSubject(String string, String string2) throws MessagingException {
        this.setSubject(string, string2, null);
    }

    public void setSubject(String string, String string2, String string3) throws MessagingException {
        if (string == null) {
            this.removeHeader("Subject");
        }
        try {
            this.setHeader("Subject", MailUtility.encodeText(string, string2, string3));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MessagingException("Encoding error", (Exception)unsupportedEncodingException);
        }
    }

    public DataHandler getDataHandler() {
        if (this.dh == null) {
            this.dh = new DataHandler((DataSource)new CorrectedContentTypeDataSource((DataSource)new MimePartDataSource((MimePart)this), "ISO-2022-JP"));
        }
        return this.dh;
    }

    public synchronized void saveChanges() throws MessagingException {
        super.saveChanges();
        if (this.listeners == null) {
            return;
        }
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MessageUpdateListener)enumeration.nextElement()).updated();
        }
    }

    public Address[] getAddressHeader(String string) throws MessagingException {
        return this.getAddressHeader(string, false);
    }

    public Address[] getAddressHeader(String string, boolean bl) throws MessagingException {
        String string2 = this.getHeader(string, ",");
        return string2 == null ? null : InternetAddress.parse((String)string2, (boolean)bl);
    }

    public synchronized void addMessageUpdateListener(MessageUpdateListener messageUpdateListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(messageUpdateListener);
    }

    public static void main(String[] stringArray) throws Exception {
        SKMessage sKMessage = new SKMessage(System.in);
        System.out.println(sKMessage.getSubject());
        System.out.println("***********");
        sKMessage.writeTo(System.out);
    }
}

