/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileupload;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.InputStream;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.upload.FileItem;
import org.apache.velocity.context.Context;

public class FileuploadFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileuploadFormData.class.getName());
    public static final String ATTACHMENT_INIT = "attachmentinit";
    public static final String KEY_ATTACHMENT_ID = "attachment";
    private final int FIELD_ATTACHMENT_MAX_LEN = 128;
    private ALStringField folderName = null;
    private FileuploadBean filebean = null;
    private FileItem attachmentItem = null;
    private ALStringField attachmentName = null;
    private int nowSize = 0;
    private int maxSize = 0;
    private int userId = -1;
    private RunData rundata;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
        this.rundata = rundata;
        this.folderName = new ALStringField();
        this.folderName.setValue(rundata.getParameters().getString("folderName"));
        if (this.folderName.getValue() == null || "".equals(this.folderName.getValue())) {
            this.folderName.setValue("0_" + String.valueOf(System.nanoTime()));
        }
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        ParameterParser parser = rundata.getParameters();
        this.attachmentItem = parser.getFileItem(KEY_ATTACHMENT_ID);
        if (this.attachmentItem != null) {
            this.attachmentName.setValue(this.attachmentItem.getName());
        }
        this.nowSize = parser.getInt("nsize", 0);
        this.maxSize = parser.getInt("msize", 0);
        return true;
    }

    protected void setValidator() {
        this.attachmentName.setNotNull(true);
        this.attachmentName.limitMaxLength(128);
        this.attachmentName.setCharacterType(0);
    }

    protected boolean validate(List<String> msgList) {
        if (this.attachmentItem != null) {
            if (this.attachmentItem.getSize() > 0L) {
                long fileSizeSum = ALStorageService.getTmpFolderSize((int)this.userId, (String)this.folderName.getValue());
                if ((fileSizeSum += this.attachmentItem.getSize()) > (long)FileuploadUtils.getMaxFileSize("B")) {
                    msgList.add("\u8ffd\u52a0\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u306e\u5168\u5bb9\u91cf\u304c " + FileuploadUtils.getMaxFileSize() + "MB \u3088\u308a\u3082\u5927\u304d\u304f\u306a\u308a\u307e\u3057\u305f\u3002\u3053\u308c\u4ee5\u4e0a\u3001\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.attachmentName.validate(msgList);
                }
            } else {
                msgList.add("\u30b5\u30a4\u30ba\u304c 0KB \u306e\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            }
        } else {
            msgList.add("\u8ffd\u52a0\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u306e\u5168\u5bb9\u91cf\u304c " + FileuploadUtils.getMaxFileSize() + "MB \u3088\u308a\u3082\u5927\u304d\u304f\u306a\u308a\u307e\u3057\u305f\u3002\u3053\u308c\u4ee5\u4e0a\u3001\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.maxSize > 0 && (this.maxSize != 1 || this.nowSize != 1) && this.nowSize >= this.maxSize) {
            msgList.add("\u3053\u308c\u4ee5\u4e0a\u3001\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (msgList.size() == 0) {
            String reqSecid = this.rundata.getParameters().getString("secid");
            String sessionSecid = (String)this.rundata.getUser().getTemp("secid");
            if (reqSecid == null || !reqSecid.equals(sessionSecid)) {
                msgList.add("\u30bb\u30c3\u30b7\u30e7\u30f3\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002\u30c0\u30a4\u30a2\u30ed\u30b0\u3092\u9589\u3058\u3066\u3001\u518d\u5ea6\u304a\u8a66\u3057\u304f\u3060\u3055\u3044\u3002");
            }
        }
        return msgList.size() == 0;
    }

    protected boolean doCheckSecurity(RunData rundata, Context context) {
        return true;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int fileId = Long.valueOf(System.nanoTime()).intValue();
            String newAttachmentFileName = String.valueOf(fileId);
            String realfilename = FileuploadUtils.getRealFileName(this.attachmentItem.getName());
            ALStorageService.createNewTmpFile((InputStream)this.attachmentItem.getInputStream(), (int)this.userId, (String)this.folderName.getValue(), (String)newAttachmentFileName, (String)realfilename);
            this.filebean = new FileuploadBean();
            this.filebean.setFolderName(this.folderName.getValue());
            this.filebean.setFileId(fileId);
            this.filebean.setFileName(realfilename);
        }
        catch (Exception ex) {
            logger.error((Object)"fileupload", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public void initField() {
        this.attachmentName = new ALStringField();
        this.attachmentName.setFieldName("\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u540d");
        this.attachmentName.setTrim(true);
    }

    public FileuploadBean getNewAttachmentFile() {
        return this.filebean;
    }

    public ALStringField getFolderName() {
        return this.folderName;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

