/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timecard;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecard;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.timecard.TimecardResultData;
import com.aimluck.eip.timecard.TimecardSummaryResultData;
import com.aimluck.eip.util.ALEipUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimecardSummaryListSelectData
extends ALAbstractSelectData<EipTTimecard, EipTTimecard>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimecardSummaryListSelectData.class.getName());
    private String target_group_name;
    private String target_user_id;
    private List<ALEipGroup> myGroupList = null;
    private List<ALEipUser> userList = null;
    private String userid;
    private final String TARGET_GROUP_NAME = "target_group_name";
    private final String TARGET_USER_ID = "target_user_id";
    private ALDateTimeField view_date;
    private String nowtime;
    private Map<String, TimecardSummaryResultData> datemap;
    private ALNumberField shugyoNissu;
    private ALNumberField shugyoJikan;
    private ALNumberField shugyoJikannaiNissu;
    private ALNumberField shugyoJikannaiJikan;
    private ALNumberField shugyoJikannai1Nissu;
    private ALNumberField shugyoJikannai1Jikan;
    private ALNumberField shugyoJikannai2Nissu;
    private ALNumberField shugyoJikannai2Jikan;
    private ALNumberField zangyoNissu;
    private ALNumberField zangyoJikan;
    private ALNumberField zangyoJikannaiNissu;
    private ALNumberField zangyoJikannaiJikan;
    private ALNumberField zangyoJikannai1Nissu;
    private ALNumberField zangyoJikannai1Jikan;
    private ALNumberField zangyoJikannai2Nissu;
    private ALNumberField zangyoJikannai2Jikan;
    private ALNumberField chikoku;
    private ALNumberField sotai;
    private String aclPortletFeature = null;
    private boolean hasAclSummaryOther;

    public void initField() {
        this.shugyoNissu = new ALNumberField(0L);
        this.shugyoJikan = new ALNumberField(0L);
        this.shugyoJikannaiNissu = new ALNumberField(0L);
        this.shugyoJikannaiJikan = new ALNumberField(0L);
        this.shugyoJikannai1Nissu = new ALNumberField(0L);
        this.shugyoJikannai1Jikan = new ALNumberField(0L);
        this.shugyoJikannai2Nissu = new ALNumberField(0L);
        this.shugyoJikannai2Jikan = new ALNumberField(0L);
        this.zangyoNissu = new ALNumberField(0L);
        this.zangyoJikan = new ALNumberField(0L);
        this.zangyoJikannaiNissu = new ALNumberField(0L);
        this.zangyoJikannaiJikan = new ALNumberField(0L);
        this.zangyoJikannai1Nissu = new ALNumberField(0L);
        this.zangyoJikannai1Jikan = new ALNumberField(0L);
        this.zangyoJikannai2Nissu = new ALNumberField(0L);
        this.zangyoJikannai2Jikan = new ALNumberField(0L);
        this.chikoku = new ALNumberField(0L);
        this.sotai = new ALNumberField(0L);
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        block11: {
            super.init(action, rundata, context);
            this.initField();
            Calendar cal = Calendar.getInstance();
            this.view_date = new ALDateTimeField("yyyy-MM-dd");
            if (rundata.getParameters().containsKey((Object)"view_date_year") && rundata.getParameters().containsKey((Object)"view_date_month")) {
                int tmpViewDate_year = Integer.parseInt(rundata.getParameters().getString("view_date_year"));
                int tmpViewDate_month = Integer.parseInt(rundata.getParameters().getString("view_date_month"));
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(1, tmpViewDate_year);
                cal.set(2, tmpViewDate_month - 1);
            } else {
                cal.set(11, 0);
                cal.set(12, 0);
            }
            cal.set(5, 1);
            this.view_date.setValue(cal.getTime());
            this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList<ALEipGroup>();
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.myGroupList.add((ALEipGroup)myGroups.get(i));
            }
            try {
                String userFilter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_user_id");
                if (userFilter == null || userFilter.equals("")) {
                    VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
                    userFilter = portlet.getPortletConfig().getInitParameter("p3a-user");
                }
                if (userFilter != null && !userFilter.equals("")) {
                    int paramId = -1;
                    try {
                        paramId = Integer.parseInt(userFilter);
                        if (paramId <= 3) break block11;
                        ALEipUser user = ALEipUtils.getALEipUser((int)paramId);
                        if (user != null) {
                            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)userFilter);
                            break block11;
                        }
                        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
                    }
                    catch (NumberFormatException e) {}
                    break block11;
                }
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
            }
            catch (Exception ex) {
                logger.error((Object)"timecard", (Throwable)ex);
            }
        }
        this.aclPortletFeature = this.target_user_id == null || "".equals(this.target_user_id) || this.userid.equals(this.target_user_id) ? "timecard_timecard_self" : "timecard_timecard_other";
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclSummaryOther = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_other", 1);
        if (!this.hasAclSummaryOther) {
            this.target_user_id = this.userid;
            this.aclPortletFeature = "timecard_timecard_self";
        }
        this.datemap = new LinkedHashMap<String, TimecardSummaryResultData>();
        this.setupLists(rundata, context);
    }

    protected ResultList<EipTTimecard> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.setupLists(rundata, context);
            if (!"".equals(this.target_user_id)) {
                SelectQuery<EipTTimecard> query = this.getSelectQuery(rundata, context);
                this.buildSelectQueryForListView(query);
                query.orderAscending("workDate");
                return query.getResultList();
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"timecard", (Throwable)ex);
            return null;
        }
    }

    protected EipTTimecard selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Object getResultData(EipTTimecard record) throws ALPageNotFoundException, ALDBErrorException {
        try {
            TimecardSummaryResultData listrd;
            Date date = record.getWorkDate();
            String checkdate = ALDateUtil.format((Date)date, (String)"yyyyMMdd");
            TimecardSummaryResultData value = this.datemap.get(checkdate);
            if (value == null) {
                listrd = new TimecardSummaryResultData();
                listrd.initField();
                listrd.setDate(date);
                this.datemap.put(checkdate, listrd);
            }
            listrd = this.datemap.get(checkdate);
            TimecardResultData rd = new TimecardResultData();
            rd.initField();
            rd.setWorkFlag(record.getWorkFlag());
            rd.setWorkDate(record.getWorkDate());
            rd.setRefixFlag(record.getCreateDate(), record.getUpdateDate());
            rd.setTimecardId(record.getTimecardId().longValue());
            rd.setReason(record.getReason());
            if (rd.getStartWorkDate() == null) {
                Date workdate = record.getWorkDate();
                workdate.setTime(0L);
                rd.setStartWorkDate(workdate);
            }
            listrd.addTimecardResultData(rd);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"timecard", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipTTimecard obj) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    private void setupLists(RunData rundata, Context context) {
        this.target_group_name = this.getTargetGroupName(rundata, context);
        this.userList = this.target_group_name != null && !this.target_group_name.equals("") && !this.target_group_name.equals("all") ? ALEipUtils.getUsers((String)this.target_group_name) : ALEipUtils.getUsers((String)"LoginUser");
        if (this.userList == null || this.userList.size() == 0) {
            this.target_user_id = "";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
            return;
        }
        this.target_user_id = this.getTargetUserId(rundata, context);
    }

    private String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = null;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString("target_group_name");
        }
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_group_name");
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_group_name", (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_group_name", (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    private String getTargetUserId(RunData rundata, Context context) {
        String target_user_id = null;
        String idParam = null;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString("target_user_id");
        }
        target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_user_id");
        if (idParam == null && target_user_id == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
            target_user_id = this.userid;
        } else if (idParam != null) {
            if (idParam.equals("none")) {
                ALEipUser eipUser = null;
                boolean found = false;
                int length = this.userList.size();
                for (int i = 0; i < length; ++i) {
                    eipUser = this.userList.get(i);
                    String eipUserId = eipUser.getUserId().getValueAsString();
                    if (!this.userid.equals(eipUserId)) continue;
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
                    target_user_id = this.userid;
                    found = true;
                    break;
                }
                if (!found) {
                    eipUser = this.userList.get(0);
                    String userId = eipUser.getUserId().getValueAsString();
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)userId);
                    target_user_id = userId;
                }
            } else {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)idParam);
                target_user_id = idParam;
            }
        }
        return target_user_id;
    }

    private SelectQuery<EipTTimecard> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTTimecard.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.valueOf(this.target_user_id));
        query.setQualifier(exp1);
        Calendar cal = Calendar.getInstance();
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"workDate", (Object)this.view_date.getValue());
        cal.setTime(this.view_date.getValue());
        cal.add(2, 1);
        ALDateTimeField view_date_add_month = new ALDateTimeField("yyyy-MM-dd");
        view_date_add_month.setValue(cal.getTime());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"workDate", (Object)view_date_add_month.getValue());
        query.andQualifier(exp11.andExp(exp12));
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public List<String> getDateListKeys() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            Set<String> set = this.datemap.keySet();
            Iterator<String> iter = set.iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            if (list.size() > 1) {
                for (int i = 0; i < list.size() - 1; ++i) {
                    TimecardSummaryResultData listrd1 = this.datemap.get(list.get(i));
                    TimecardSummaryResultData listrd2 = this.datemap.get(list.get(i + 1));
                    int listrd1_size = listrd1.getList().size();
                    if (listrd1_size <= 0) continue;
                    TimecardResultData listrd1_lastrd = listrd1.getList().get(listrd1_size - 1);
                    TimecardResultData listrd2_firstrd = listrd2.getList().get(0);
                    if (!"0".equals(listrd2_firstrd.getWorkFlag().getValue()) || !"1".equals(listrd1_lastrd.getWorkFlag().getValue()) || this.sameDay(listrd1_lastrd.getWorkDate().getValue(), listrd2_firstrd.getWorkDate().getValue())) continue;
                    Date d = listrd2_firstrd.getWorkDate().getValue();
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(d);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    TimecardResultData dummyrd = new TimecardResultData();
                    dummyrd.initField();
                    dummyrd.setWorkFlag("-1");
                    dummyrd.setWorkDate(cal.getTime());
                    listrd1.addTimecardResultData(dummyrd);
                }
            }
            return list;
        }
        catch (Exception e) {
            logger.error((Object)"[TimecardSummaryListSelectData]", (Throwable)e);
            return null;
        }
    }

    public TimecardSummaryResultData getDateListValue(String date_str) {
        return this.datemap.get(date_str);
    }

    private boolean sameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        return date1Year == date2Year && date1Month == date2Month && date1Day == date2Day;
    }

    public void calc() {
        if (this.datemap != null) {
            int shugyoNissu_temp = 0;
            int shugyoJikan_temp = 0;
            int shugyoJikannaiNissu_temp = 0;
            int shugyoJikannaiJikan_temp = 0;
            int shugyoJikannai1Nissu_temp = 0;
            int shugyoJikannai1Jikan_temp = 0;
            int shugyoJikannai2Nissu_temp = 0;
            int shugyoJikannai2Jikan_temp = 0;
            int zangyoNissu_temp = 0;
            int zangyoJikan_temp = 0;
            int zangyoJikannaiNissu_temp = 0;
            int zangyoJikannaiJikan_temp = 0;
            int zangyoJikannai1Nissu_temp = 0;
            int zangyoJikannai1Jikan_temp = 0;
            int zangyoJikannai2Nissu_temp = 0;
            int zangyoJikannai2Jikan_temp = 0;
            int chikoku_temp = 0;
            int sotai_temp = 0;
            Iterator<TimecardSummaryResultData> iterator = this.datemap.values().iterator();
            while (iterator.hasNext()) {
                TimecardSummaryResultData element;
                TimecardSummaryResultData rd = element = iterator.next();
                rd.calc();
                if (rd.getShugyo().getValue() > 0L) {
                    ++shugyoNissu_temp;
                    shugyoJikan_temp = (int)((long)shugyoJikan_temp + rd.getShugyo().getValue());
                }
                if (rd.getJikannai().getValue() > 0L) {
                    ++shugyoJikannaiNissu_temp;
                    shugyoJikannaiJikan_temp = (int)((long)shugyoJikannaiJikan_temp + rd.getJikannai().getValue());
                }
                if (rd.getJikannai1().getValue() > 0L) {
                    ++shugyoJikannai1Nissu_temp;
                    shugyoJikannai1Jikan_temp = (int)((long)shugyoJikannai1Jikan_temp + rd.getJikannai1().getValue());
                }
                if (rd.getJikannai2().getValue() > 0L) {
                    ++shugyoJikannai2Nissu_temp;
                    shugyoJikannai2Jikan_temp = (int)((long)shugyoJikannai2Jikan_temp + rd.getJikannai2().getValue());
                }
                if (rd.getZangyo().getValue() > 0L) {
                    ++zangyoNissu_temp;
                    zangyoJikan_temp = (int)((long)zangyoJikan_temp + rd.getZangyo().getValue());
                }
                if (rd.getZangyo1().getValue() > 0L) {
                    ++zangyoJikannai1Nissu_temp;
                    zangyoJikannai1Jikan_temp = (int)((long)zangyoJikannai1Jikan_temp + rd.getZangyo1().getValue());
                }
                if (rd.getZangyo2().getValue() > 0L) {
                    ++zangyoJikannai2Nissu_temp;
                    zangyoJikannai2Jikan_temp = (int)((long)zangyoJikannai2Jikan_temp + rd.getZangyo2().getValue());
                }
                if ("\u25cb".equals(rd.getChikoku().getValue())) {
                    ++chikoku_temp;
                }
                if (!"\u25cb".equals(rd.getSotai().getValue())) continue;
                ++sotai_temp;
            }
            this.shugyoNissu.setValue((long)shugyoNissu_temp);
            this.shugyoJikan.setValue((long)shugyoJikan_temp);
            this.shugyoJikannaiNissu.setValue((long)shugyoJikannaiNissu_temp);
            this.shugyoJikannaiJikan.setValue((long)shugyoJikannaiJikan_temp);
            this.shugyoJikannai1Nissu.setValue((long)shugyoJikannai1Nissu_temp);
            this.shugyoJikannai1Jikan.setValue((long)shugyoJikannai1Jikan_temp);
            this.shugyoJikannai2Nissu.setValue((long)shugyoJikannai2Nissu_temp);
            this.shugyoJikannai2Jikan.setValue((long)shugyoJikannai2Jikan_temp);
            this.zangyoNissu.setValue((long)zangyoNissu_temp);
            this.zangyoJikan.setValue((long)zangyoJikan_temp);
            this.zangyoJikannaiNissu.setValue((long)zangyoJikannaiNissu_temp);
            this.zangyoJikannaiJikan.setValue((long)zangyoJikannaiJikan_temp);
            this.zangyoJikannai1Nissu.setValue((long)zangyoJikannai1Nissu_temp);
            this.zangyoJikannai1Jikan.setValue((long)zangyoJikannai1Jikan_temp);
            this.zangyoJikannai2Nissu.setValue((long)zangyoJikannai2Nissu_temp);
            this.zangyoJikannai2Jikan.setValue((long)zangyoJikannai2Jikan_temp);
            this.chikoku.setValue((long)chikoku_temp);
            this.sotai.setValue((long)sotai_temp);
        }
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public List<ALEipUser> getUsers() {
        if (this.hasAclSummaryOther) {
            return this.userList;
        }
        try {
            ArrayList<ALEipUser> users = new ArrayList<ALEipUser>();
            users.add(ALEipUtils.getALEipUser((int)Integer.parseInt(this.userid)));
            return users;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<Integer, ALEipPost> getPostMap() {
        if (this.hasAclSummaryOther) {
            return ALEipManager.getInstance().getPostMap();
        }
        return null;
    }

    public List<ALEipGroup> getMyGroupList() {
        if (this.hasAclSummaryOther) {
            return this.myGroupList;
        }
        return null;
    }

    public String getUserId() {
        return this.userid;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public ALDateTimeField getViewDate() {
        return this.view_date;
    }

    public String getNowTime() {
        return this.nowtime;
    }

    public ALNumberField getShugyoNissu() {
        return this.shugyoNissu;
    }

    public ALNumberField getShugyoJikan() {
        return this.shugyoJikan;
    }

    public ALStringField getShugyoJikanStr() {
        return new ALStringField(this.minuteToHour(this.shugyoJikan.getValue()));
    }

    public ALNumberField getShugyoJikannaiNissu() {
        return this.shugyoJikannaiNissu;
    }

    public ALNumberField getShugyoJikannaiJikan() {
        return this.shugyoJikannaiJikan;
    }

    public ALStringField getShugyoJikannaiJikanStr() {
        return new ALStringField(this.minuteToHour(this.shugyoJikannaiJikan.getValue()));
    }

    public ALNumberField getShugyoJikannai1Nissu() {
        return this.shugyoJikannai1Nissu;
    }

    public ALNumberField getShugyoJikannai1Jikan() {
        return this.shugyoJikannai1Jikan;
    }

    public ALStringField getShugyoJikannai1JikanStr() {
        return new ALStringField(this.minuteToHour(this.shugyoJikannai1Jikan.getValue()));
    }

    public ALNumberField getShugyoJikannai2Nissu() {
        return this.shugyoJikannai2Nissu;
    }

    public ALNumberField getShugyoJikannai2Jikan() {
        return this.shugyoJikannai2Jikan;
    }

    public ALStringField getShugyoJikannai2JikanStr() {
        return new ALStringField(this.minuteToHour(this.shugyoJikannai2Jikan.getValue()));
    }

    public ALNumberField getZangyoNissu() {
        return this.zangyoNissu;
    }

    public ALNumberField getZangyoJikan() {
        return this.zangyoJikan;
    }

    public ALStringField getZangyoJikanStr() {
        return new ALStringField(this.minuteToHour(this.zangyoJikan.getValue()));
    }

    public ALNumberField getZangyoJikannaiNissu() {
        return this.zangyoJikannaiNissu;
    }

    public ALNumberField getZangyoJikannaiJikan() {
        return this.zangyoJikannaiJikan;
    }

    public ALStringField getZangyoJikannaiJikanStr() {
        return new ALStringField(this.minuteToHour(this.zangyoJikannaiJikan.getValue()));
    }

    public ALNumberField getZangyoJikannai1Nissu() {
        return this.zangyoJikannai1Nissu;
    }

    public ALNumberField getZangyoJikannai1Jikan() {
        return this.zangyoJikannai1Jikan;
    }

    public ALStringField getZangyoJikannai1JikanStr() {
        return new ALStringField(this.minuteToHour(this.zangyoJikannai1Jikan.getValue()));
    }

    public ALNumberField getZangyoJikannai2Nissu() {
        return this.zangyoJikannai2Nissu;
    }

    public ALNumberField getZangyoJikannai2Jikan() {
        return this.zangyoJikannai2Jikan;
    }

    public ALStringField getZangyoJikannai2JikanStr() {
        return new ALStringField(this.minuteToHour(this.zangyoJikannai2Jikan.getValue()));
    }

    public ALNumberField getChikoku() {
        return this.chikoku;
    }

    public ALNumberField getSotai() {
        return this.sotai;
    }

    private String minuteToHour(long minute) {
        BigDecimal decimal = new BigDecimal((double)minute / 60.0);
        DecimalFormat dformat = new DecimalFormat("##.#");
        String str = dformat.format(decimal.setScale(1, 3).doubleValue());
        return str;
    }

    public int getEndYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1) + 1;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

