/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.note.util;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class NoteUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteUtils.class.getName());
    public static final String DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm";
    public static final String CREATED_DATE_FORMAT = "yyyy/MM/dd";
    public static final String TARGET_GROUP_NAME = "target_group_name";
    public static final String TARGET_USER_ID = "target_user_id";
    public static final String NOTE_VIEW_TYPE = "note_view_type";
    public static final String NOTE_VIEW_TYPE_LIST = "note_view_list";
    public static final String NOTE_VIEW_TYPE_GROUP = "note_view_group";
    public static final String NOTE_STAT_NEW = "1";
    public static final String NOTE_STAT_UNREAD = "2";
    public static final String NOTE_STAT_READ = "3";
    public static final String NOTE_STAT_DELETED = "4";
    public static final String NOTE_PORTLET_NAME = "Note";
    public static final String NOTE_GROUP_PORTLET_NAME = "NoteGroup";
    public static final String TARGET_KEYWORD = "keyword";
    private static final String RESET_FLAG = "reset_params";

    public static EipTNote getEipTNoteDetail(RunData rundata, Context context, SelectQuery<EipTNote> query) {
        String noteId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        int uid = ALEipUtils.getUserId((RunData)rundata);
        try {
            Expression exp2;
            if (noteId == null || noteId.equals("") || Integer.valueOf(noteId) == null) {
                logger.debug((Object)"[Note] Empty NoteID...");
                return null;
            }
            Expression exp1 = ExpressionFactory.matchExp((String)"noteId", (Object)Integer.valueOf(noteId));
            List maps = Database.query(EipTNoteMap.class, (Expression)exp1.andExp(exp2 = ExpressionFactory.matchExp((String)"userId", (Object)uid))).fetchList();
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[Note] Invalid user access...");
                return null;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"NOTE_ID", (Object)Integer.valueOf(noteId));
            List notes = query.andQualifier(exp).fetchList();
            if (notes == null || notes.size() == 0) {
                logger.debug((Object)"[Note] Not found NoteID...");
                return null;
            }
            return (EipTNote)notes.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    public static EipTNoteMap getEipTNoteMap(RunData rundata, Context context, SelectQuery<EipTNoteMap> query) {
        String noteId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (noteId == null || noteId.equals("") || Integer.valueOf(noteId) == null) {
                logger.debug((Object)"[Note] Empty NoteID...");
                return null;
            }
            Expression exp1 = ExpressionFactory.matchDbExp((String)"NOTE_ID", (Object)noteId);
            Expression exp2 = ExpressionFactory.matchExp((String)"delFlg", (Object)"F");
            List maps = query.andQualifier(exp1).andQualifier(exp2).fetchList();
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[Note] Not found NoteID...");
                return null;
            }
            return (EipTNoteMap)maps.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    public static List<EipTNoteMap> getEipTNoteMapList(RunData rundata, Context context, boolean tabReceive, String[] nodeIds) {
        if (nodeIds == null) {
            return null;
        }
        try {
            Expression exp2;
            Integer userid = ALEipUtils.getUserId((RunData)rundata);
            SelectQuery query = Database.query(EipTNoteMap.class);
            Expression exp1 = ExpressionFactory.inDbExp((String)"NOTE_ID", (Object[])nodeIds);
            query.setQualifier(exp1);
            if (tabReceive) {
                exp2 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
                query.andQualifier(exp2);
                Expression exp3 = ExpressionFactory.noMatchExp((String)"eipTNote.ownerId", (Object)userid);
                query.andQualifier(exp3);
            } else {
                exp2 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
                query.andQualifier(exp2);
                Expression exp3 = ExpressionFactory.matchExp((String)"eipTNote.ownerId", (Object)userid);
                query.andQualifier(exp3);
            }
            List noteMaps = query.fetchList();
            if (noteMaps == null || noteMaps.size() == 0) {
                logger.debug((Object)"[Note] Not found NoteIDs...");
                return null;
            }
            return noteMaps;
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    public static String getUserId(String userLoginName) {
        if (userLoginName == null || userLoginName.equals("")) {
            return null;
        }
        String userId = null;
        try {
            Expression exp = ExpressionFactory.matchExp((String)"loginName", (Object)userLoginName);
            List destUserList = Database.query(TurbineUser.class).setQualifier(exp).fetchList();
            if (destUserList == null || destUserList.size() <= 0) {
                return null;
            }
            userId = ((TurbineUser)destUserList.get(0)).getUserId().toString();
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
        return userId;
    }

    public static String getUserName(String userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
        String userName = null;
        try {
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(userId));
            List destUserList = Database.query(TurbineUser.class).setQualifier(exp).fetchList();
            if (destUserList == null || destUserList.size() <= 0) {
                return null;
            }
            userName = ((TurbineUser)destUserList.get(0)).getLoginName();
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
        return userName;
    }

    public static TurbineGroup getGroup(RunData rundata, Context context) {
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (id == null) {
                logger.debug((Object)"Empty ID...");
                return null;
            }
            return (TurbineGroup)JetspeedSecurity.getGroup((String)id);
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    public static Integer string2integer(String str) {
        Integer integ = null;
        try {
            integ = Integer.valueOf(str);
        }
        catch (NumberFormatException ex) {
            integ = null;
        }
        return integ;
    }

    public static String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = rundata.getParameters().getString(TARGET_GROUP_NAME);
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME);
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    public static String getTargetUserId(RunData rundata, Context context) {
        String target_user_id = null;
        String idParam = rundata.getParameters().getString(TARGET_USER_ID);
        target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID);
        if (idParam == null && target_user_id == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)"all");
            target_user_id = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)idParam);
            target_user_id = idParam;
        }
        return target_user_id;
    }

    public static String getTargetKeyword(RunData rundata, Context context) {
        String target_keyword = null;
        String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
        target_keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD);
        if (keywordParam == null && target_keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
            target_keyword = "";
        } else if (keywordParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)keywordParam.trim());
            target_keyword = keywordParam;
        }
        return target_keyword;
    }

    public static boolean hasResetFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_FLAG);
        return resetflag != null;
    }

    public static void resetFilter(RunData rundata, Context context, String className) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
    }

    public static boolean deleteNotes(RunData rundata, Context context, List<String> values, List<String> msgList) {
        boolean tabReceive = true;
        String currentTab = NoteUtils.getCurrentTab(rundata, context);
        tabReceive = "received_notes".equals(currentTab);
        try {
            String user_id = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
            if ("".equals(user_id)) {
                return false;
            }
            String[] noteIds = new String[values.size()];
            List<EipTNoteMap> eipTNoteMaps = NoteUtils.getEipTNoteMapList(rundata, context, tabReceive, noteIds = values.toArray(noteIds));
            if (eipTNoteMaps == null) {
                return false;
            }
            for (EipTNoteMap noteMap : eipTNoteMaps) {
                EipTNote tmpnote = noteMap.getEipTNote();
                Expression mapexp = ExpressionFactory.matchExp((String)"noteId", (Object)tmpnote.getNoteId());
                List maplist = Database.query(EipTNoteMap.class, (Expression)mapexp).fetchList();
                if (maplist == null || maplist.size() <= 0) continue;
                int count = 0;
                int size = maplist.size();
                for (EipTNoteMap tmpmap : maplist) {
                    if (!"T".equals(tmpmap.getDelFlg())) continue;
                    ++count;
                }
                if (count == size - 1) {
                    Database.delete((Persistent)noteMap.getEipTNote());
                } else {
                    noteMap.setDelFlg("T");
                }
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(noteMap.getEipTNote().getNoteId().intValue(), 140, NoteUtils.getNoteSubject(noteMap.getEipTNote()));
            }
            Database.commit();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"note", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static String getNoteSubject(EipTNote note) {
        String subject = "";
        if (note.getSubjectType().equals("0")) {
            subject = note.getCustomSubject();
        } else if (note.getSubjectType().equals(NOTE_STAT_NEW)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_AGAIN_NO_PERIOD");
        } else if (note.getSubjectType().equals(NOTE_STAT_UNREAD)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_MAIL_CALL_BACK");
        } else if (note.getSubjectType().equals(NOTE_STAT_READ)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_MAIL_TELL_ME");
        } else if (note.getSubjectType().equals(NOTE_STAT_DELETED)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_MAIL_TAKE_A_MESSAGE");
        }
        return subject + " (" + note.getClientName() + ")";
    }

    public static String getCurrentTab(RunData rundata, Context context) {
        String tabParam = rundata.getParameters().getString("tab");
        String currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"received_notes");
            currentTab = "received_notes";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            currentTab = tabParam;
        }
        return currentTab;
    }

    public static SelectQuery<EipTNoteMap> getSelectQueryNoteList(RunData rundata, Context context) {
        String userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        SelectQuery query = Database.query(EipTNoteMap.class);
        Expression exp01 = ExpressionFactory.matchExp((String)"noteStat", (Object)NOTE_STAT_NEW);
        Expression exp02 = ExpressionFactory.matchExp((String)"noteStat", (Object)NOTE_STAT_UNREAD);
        query.setQualifier(exp01.orExp(exp02));
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.valueOf(userId));
        query.andQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"delFlg", (Object)"F");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.noMatchExp((String)"eipTNote.ownerId", (Object)Integer.valueOf(userId));
        query.andQualifier(exp3);
        return query;
    }

    public static int getNewReceivedNoteAllSum(RunData rundata, String userId) {
        int newNoteAllSum = 0;
        try {
            SelectQuery<EipTNote> query = NoteUtils.getSelectQueryForNewReceivedNoteCount(userId);
            List list = query.fetchList();
            newNoteAllSum = list != null && list.size() > 0 ? list.size() : 0;
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return 0;
        }
        return newNoteAllSum;
    }

    private static SelectQuery<EipTNote> getSelectQueryForNewReceivedNoteCount(String srcUserId) {
        try {
            SelectQuery query = Database.query(EipTNote.class);
            Expression exp1 = ExpressionFactory.noMatchExp((String)"ownerId", (Object)Integer.valueOf(srcUserId));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTNoteMaps.userId", (Object)Integer.valueOf(srcUserId));
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchExp((String)"eipTNoteMaps.delFlg", (Object)"F");
            query.andQualifier(exp3);
            Expression exp4 = ExpressionFactory.matchExp((String)"eipTNoteMaps.noteStat", (Object)NOTE_STAT_NEW);
            query.andQualifier(exp4);
            return query;
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    public static int getUnreadReceivedNotesAllSum(RunData rundata, String userId) {
        int unreadNotesAllSum = 0;
        try {
            SelectQuery<EipTNote> query = NoteUtils.getSelectQueryForUnreadReceivedNoteCount(userId);
            List list = query.fetchList();
            unreadNotesAllSum = list != null && list.size() > 0 ? list.size() : 0;
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return 0;
        }
        return unreadNotesAllSum;
    }

    private static SelectQuery<EipTNote> getSelectQueryForUnreadReceivedNoteCount(String srcUserId) {
        try {
            SelectQuery query = Database.query(EipTNote.class);
            Expression exp1 = ExpressionFactory.noMatchExp((String)"ownerId", (Object)Integer.valueOf(srcUserId));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTNoteMaps.userId", (Object)Integer.valueOf(srcUserId));
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchExp((String)"eipTNoteMaps.delFlg", (Object)"F");
            query.andQualifier(exp3);
            Expression exp4 = ExpressionFactory.matchExp((String)"eipTNoteMaps.noteStat", (Object)NOTE_STAT_UNREAD);
            query.andQualifier(exp4);
            return query;
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    public static String getPortletURIinPersonalConfigPane(RunData rundata, String portletEntryName) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getParent().equals(portletEntryName)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId() + "," + entries[j].getId()).addQueryData("action", "controls.Restore");
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static void sendNoteActivity(EipTNote note, String loginName, List<String> recipients) {
        if (recipients != null && recipients.size() > 0) {
            ALActivity RecentActivity = ALActivity.getRecentActivity((String)NOTE_PORTLET_NAME, (int)note.getNoteId(), (float)1.0f);
            boolean isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
            String subjectType = note.getSubjectType();
            String subject = "";
            if ("0".equals(subjectType)) {
                subject = note.getCustomSubject();
            } else if (NOTE_STAT_NEW.equals(subjectType)) {
                subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_AGAIN");
            } else if (NOTE_STAT_UNREAD.equals(subjectType)) {
                subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_BACK");
            } else if (NOTE_STAT_READ.equals(subjectType)) {
                subject = ALLocalizationUtils.getl10n((String)"NOTE_TELL_ME");
            } else if (NOTE_STAT_DELETED.equals(subjectType)) {
                subject = ALLocalizationUtils.getl10n((String)"NOTE_TAKE_A_MESSAGE");
            }
            String title = ALLocalizationUtils.getl10nFormat((String)"NOTE_CLIENT_NAME_SUBJECT_TEXT", (Object[])new Object[]{note.getClientName(), subject});
            String portletParams = "?template=NoteDetailScreen" + "&entityid=" + note.getNoteId() + "&tab=received_notes";
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(NOTE_PORTLET_NAME).withUserId(Integer.valueOf(note.getOwnerId()).intValue()).withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipients).withTitle(title).withPriority(1.0f).withExternalId(String.valueOf(note.getNoteId())));
            if (isDeletePrev) {
                RecentActivity.delete();
            }
        }
    }

    private String createMsgForPc(RunData rundata, EipTNote note, List<ALEipUser> memberList) throws ALDBErrorException {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        context.put("clientName", (Object)note.getClientName());
        context.put("companyName", (Object)note.getCompanyName());
        ALDateTimeField alDateTimeField = new ALDateTimeField();
        alDateTimeField.setValue(note.getAcceptDate());
        StringBuffer acceptDate = new StringBuffer();
        acceptDate.append(alDateTimeField.getMonth()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MONTH", (Object[])new Object[0])).append(alDateTimeField.getDay()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_DAY", (Object[])new Object[0])).append(alDateTimeField.getHour()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_HOUR", (Object[])new Object[0])).append(alDateTimeField.getMinute()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MINUTE", (Object[])new Object[0]));
        context.put("acceptDate", (Object)acceptDate);
        String subjectType = note.getSubjectType();
        String subject = "";
        if ("0".equals(subjectType)) {
            subject = note.getCustomSubject();
        } else if (NOTE_STAT_NEW.equals(subjectType)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_AGAIN");
        } else if (NOTE_STAT_UNREAD.equals(subjectType)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_BACK");
        } else if (NOTE_STAT_READ.equals(subjectType)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_TELL_ME");
        } else if (NOTE_STAT_DELETED.equals(subjectType)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_TAKE_A_MESSAGE");
        }
        context.put("subjectType", (Object)subject);
        context.put("clientName", (Object)note.getClientName());
        context.put("companyName", (Object)note.getCompanyName());
        context.put("telephone", (Object)note.getTelephone());
        context.put("emailAddress", (Object)note.getEmailAddress());
        context.put("message", (Object)note.getMessage());
        context.put("loginUser", (Object)loginUser.getAliasName().toString());
        context.put("hasEmail", (Object)(!user.getEmail().equals("") ? 1 : 0));
        context.put("email", (Object)user.getEmail());
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && !lang.equals("en")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/note-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/note-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    private String createMsgCellPhone(RunData rundata, EipTNote note, List<ALEipUser> memberList) throws ALDBErrorException {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        context.put("clientName", (Object)note.getClientName());
        context.put("companyName", (Object)note.getCompanyName());
        ALDateTimeField alDateTimeField = new ALDateTimeField();
        alDateTimeField.setValue(note.getAcceptDate());
        StringBuffer acceptDate = new StringBuffer();
        acceptDate.append(alDateTimeField.getMonth()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MONTH", (Object[])new Object[0])).append(alDateTimeField.getDay()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_DAY", (Object[])new Object[0])).append(alDateTimeField.getHour()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_HOUR", (Object[])new Object[0])).append(alDateTimeField.getMinute()).append(ALLocalizationUtils.getl10nFormat((String)"NOTE_MINUTE", (Object[])new Object[0]));
        context.put("acceptDate", (Object)acceptDate);
        String subjectType = note.getSubjectType();
        String subject = "";
        if ("0".equals(subjectType)) {
            subject = note.getCustomSubject();
        } else if (NOTE_STAT_NEW.equals(subjectType)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_AGAIN");
        } else if (NOTE_STAT_UNREAD.equals(subjectType)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_BACK");
        } else if (NOTE_STAT_READ.equals(subjectType)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_TELL_ME");
        } else if (NOTE_STAT_DELETED.equals(subjectType)) {
            subject = ALLocalizationUtils.getl10n((String)"NOTE_TAKE_A_MESSAGE");
        }
        context.put("subjectType", (Object)subject);
        context.put("clientName", (Object)note.getClientName());
        context.put("companyName", (Object)note.getCompanyName());
        context.put("telephone", (Object)note.getTelephone());
        context.put("emailAddress", (Object)note.getEmailAddress());
        context.put("message", (Object)note.getMessage());
        context.put("loginUser", (Object)loginUser.getAliasName().toString());
        context.put("hasEmail", (Object)(!user.getEmail().equals("") ? 1 : 0));
        context.put("email", (Object)user.getEmail());
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && !lang.equals("en")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/note-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/note-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }
}

