/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellAccountLoginAction
extends ALBaseAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellAccountLoginAction.class.getName());

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        String action_logout = rundata.getParameters().getString("logout", "").trim();
        if ("T".equals(action_logout)) {
            this.setTemplate(rundata, "accountlogout-info");
        }
        Map attribute = ALOrgUtilsService.getParameters();
        for (Map.Entry e : attribute.entrySet()) {
            context.put((String)e.getKey(), e.getValue());
        }
        if (Boolean.parseBoolean((String)rundata.getSession().getAttribute("changeToPc"))) {
            context.put("client", (Object)ALEipUtils.getClient((RunData)rundata));
        }
        this.doAccount_login(rundata, context);
        this.setResultData((Object)this);
        this.putData(rundata, context);
    }

    public void doAccount_login(RunData rundata, Context context) throws Exception {
        boolean enableEasyLogin = false;
        String username = null;
        String key = rundata.getParameters().getString("key", "").trim();
        if (key.contains("_")) {
            username = key.substring(0, key.lastIndexOf("_"));
            String base64value = key.substring(key.lastIndexOf("_") + 1);
            ALStringField tmpname = new ALStringField();
            tmpname.setTrim(true);
            tmpname.setNotNull(true);
            tmpname.setCharacterType(19);
            tmpname.limitMaxLength(16);
            tmpname.setValue(username);
            boolean valid = tmpname.validate(new ArrayList());
            int length = username.length();
            for (int i1 = 0; i1 < length; ++i1) {
                if (!this.isSymbol(username.charAt(i1)) || username.charAt(i1) == "_".charAt(0) || username.charAt(i1) == "-".charAt(0) || username.charAt(i1) == ".".charAt(0)) continue;
                valid = false;
                break;
            }
            if (valid) {
                Expression exp;
                DataContext dataContext = DataContext.getThreadDataContext();
                SelectQuery query = Database.query((DataContext)dataContext, TurbineUser.class, (Expression)(exp = ExpressionFactory.matchExp((String)"loginName", (Object)username)));
                List users = query.fetchList();
                if (users.size() != 0) {
                    String uid;
                    TurbineUser tuser = (TurbineUser)users.get(0);
                    if (!ALCellularUtils.getCheckValueForCellLogin((String)username, (String)tuser.getUserId().toString()).equals(base64value)) {
                        username = "";
                    }
                    enableEasyLogin = (uid = tuser.getCellularUid()) != null && uid.length() > 0;
                } else {
                    username = "";
                }
            } else {
                username = "";
            }
        }
        context.put("username", username);
        context.put("key", (Object)key);
        context.put("enableEasyLogin", (Object)enableEasyLogin);
    }

    public void doAccount_info(RunData rundata, Context context) throws Exception {
        this.doAccount_login(rundata, context);
        this.setTemplate(rundata, "accountlogin-info");
    }

    protected boolean isSymbol(char ch) {
        byte[] chars;
        try {
            chars = Character.valueOf(ch).toString().getBytes("shift_jis");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return chars != null && chars.length != 2 && !Character.isDigit(ch) && !Character.isLetter(ch);
    }
}

