/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.turbine.TurbineConstants;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.modules.PageLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.RunDataFactory;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.security.AccessControlList;

public class Turbine
extends HttpServlet
implements TurbineConstants {
    public static final String REDIRECTED_PATHINFO_NAME = "redirected";
    public static final String BASEDIR_KEY = "basedir";
    private static boolean firstInit = true;
    private static Throwable initFailure = null;
    private static boolean firstDoGet = true;
    private static String applicationRoot;
    private static ServletConfig servletConfig;
    private static ServletContext servletContext;
    private static String webappRoot;
    private TurbineServices services = (TurbineServices)TurbineServices.getInstance();
    private static String serverName;
    private static String serverScheme;
    private static String serverPort;
    private static String scriptName;
    private static String contextPath;
    static /* synthetic */ Class class$org$apache$turbine$Turbine;

    public final void init() throws ServletException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            super.init();
            ServletConfig config = this.getServletConfig();
            if (!firstInit) {
                this.log("Double initializaton of Turbine was attempted!");
                return;
            }
            firstInit = false;
            try {
                ServletContext context = config.getServletContext();
                applicationRoot = config.getInitParameter("applicationRoot");
                if (applicationRoot == null || applicationRoot.equals("webContext")) {
                    applicationRoot = config.getServletContext().getRealPath("/");
                }
                Turbine.setApplicationRoot(applicationRoot);
                webappRoot = config.getServletContext().getRealPath("/");
                Turbine.setTurbineServletConfig(config);
                Turbine.setTurbineServletContext(context);
                Turbine.createRuntimeDirectories();
                this.services.initPrimaryServices(config);
                TurbineResources.setProperty("applicationRoot", applicationRoot);
                TurbineResources.setProperty("webappRoot", webappRoot);
                this.services.initServices(config, false);
                this.log("Turbine: init() Ready to Rumble!");
            }
            catch (Exception e) {
                initFailure = e;
                this.log("Turbine: init() failed: " + StringUtils.stackTrace(e));
            }
        }
    }

    private static void createRuntimeDirectories() {
        File logDir = new File(webappRoot + "/logs");
        if (!logDir.exists() && !logDir.mkdirs()) {
            System.err.println("Cannot create directory for logs!");
        }
    }

    public final void init(RunData data) {
        Class clazz = class$org$apache$turbine$Turbine == null ? (class$org$apache$turbine$Turbine = Turbine.class$("org.apache.turbine.Turbine")) : class$org$apache$turbine$Turbine;
        synchronized (clazz) {
            if (firstDoGet) {
                Turbine.saveServletInfo(data);
                this.log("Turbine: Starting HTTP initialization of services");
                TurbineServices.getInstance().initServices(data);
                this.log("Turbine: Completed HTTP initialization of services");
                firstDoGet = false;
            }
        }
    }

    public static String getServerName() {
        return serverName;
    }

    public static String getServerScheme() {
        return serverScheme;
    }

    public static String getServerPort() {
        return serverPort;
    }

    public static String getScriptName() {
        return scriptName;
    }

    public static String getContextPath() {
        return contextPath;
    }

    public static void setTurbineServletConfig(ServletConfig s) {
        servletConfig = s;
    }

    public static ServletConfig getTurbineServletConfig() {
        return servletConfig;
    }

    public static void setTurbineServletContext(ServletContext s) {
        servletContext = s;
    }

    public static ServletContext getTurbineServletContext() {
        return servletContext;
    }

    public final void destroy() {
        TurbineServices.getInstance().shutdownServices();
        System.gc();
        this.log("Turbine: Done shutting down!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        boolean requestRedirected = false;
        RunData data = null;
        try {
            try {
                int timeout;
                if (initFailure != null) {
                    throw initFailure;
                }
                data = RunDataFactory.getRunData(req, res, this.getServletConfig());
                if (firstDoGet) {
                    this.init(data);
                }
                if (data.getSession().isNew() && (timeout = TurbineResources.getInt("session.timeout", -1)) != -1) {
                    data.getSession().setMaxInactiveInterval(timeout);
                }
                data.setScreen(data.getParameters().getString("screen"));
                data.setAction(data.getParameters().getString("action"));
                if (data.hasAction() && data.getAction().equalsIgnoreCase(TurbineResources.getString("action.login")) || data.getAction().equalsIgnoreCase(TurbineResources.getString("action.logout"))) {
                    String[] names;
                    if (data.getAction().equalsIgnoreCase(TurbineResources.getString("action.login")) && (names = data.getSession().getValueNames()) != null) {
                        int i = 0;
                        while (i < names.length) {
                            data.getSession().removeValue(names[i]);
                            ++i;
                        }
                    }
                    ActionLoader.getInstance().exec(data, data.getAction());
                    data.setAction(null);
                }
                ActionLoader.getInstance().exec(data, TurbineResources.getString("action.sessionvalidator"));
                ActionLoader.getInstance().exec(data, TurbineResources.getString("action.accesscontroller"));
                String defaultPage = TurbineTemplate.getDefaultPageName(data);
                if (defaultPage == null) {
                    defaultPage = TurbineResources.getString("page.default", "DefaultPage");
                }
                PageLoader.getInstance().exec(data, defaultPage);
                if (data.getACL() == null) {
                    try {
                        data.getSession().removeValue(AccessControlList.SESSION_KEY);
                    }
                    catch (IllegalStateException ignored) {
                        // empty catch block
                    }
                }
                boolean bl = requestRedirected = data.getRedirectURI() != null && data.getRedirectURI().length() > 0;
                if (requestRedirected) {
                    if (data.getResponse().isCommitted()) {
                        requestRedirected = false;
                        this.log("redirect requested, response already committed: " + data.getRedirectURI());
                    } else {
                        data.getResponse().sendRedirect(data.getRedirectURI());
                    }
                }
                if (!requestRedirected) {
                    try {
                        if (!data.isPageSet() && !data.isOutSet()) {
                            throw new Exception("Nothing to output");
                        }
                        if (data.isPageSet() && !data.isOutSet()) {
                            data.getResponse().setLocale(data.getLocale());
                            data.getResponse().setContentType(data.getContentType());
                            data.getResponse().setStatus(data.getStatusCode());
                            data.getPage().output(data.getOut());
                        }
                    }
                    catch (Exception e) {
                        Log.debug("Output stream closed? ", e);
                    }
                }
                Object var8_13 = null;
            }
            catch (Exception e) {
                this.handleException(data, res, e);
                Object var8_14 = null;
                RunDataFactory.putRunData(data);
                return;
            }
            catch (Throwable t) {
                this.handleException(data, res, t);
                Object var8_15 = null;
                RunDataFactory.putRunData(data);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            RunDataFactory.putRunData(data);
            throw throwable;
        }
        RunDataFactory.putRunData(data);
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public final String getServletInfo() {
        return "Turbine Servlet";
    }

    private final void handleException(RunData data, HttpServletResponse res, Throwable t) {
        Log.error("Turbine.handleException: " + t.getMessage());
        Log.error(t);
        String mimeType = "text/plain";
        try {
            data.setStackTrace(StringUtils.stackTrace(t), t);
            data.setScreen(TurbineResources.getString("screen.error"));
            if (data.getTemplateInfo() != null) {
                data.getTemplateInfo().setScreenTemplate(TurbineResources.getString("template.error"));
            }
            data.setAction("");
            PageLoader.getInstance().exec(data, TurbineResources.getString("page.default", "DefaultPage"));
            data.getResponse().setContentType(data.getContentType());
            data.getResponse().setStatus(data.getStatusCode());
            if (data.isPageSet()) {
                data.getOut().print(data.getPage().toString());
            }
        }
        catch (NoSuchFieldError e) {
            try {
                data.getResponse().setContentType(mimeType);
                data.getResponse().setStatus(200);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                data.getOut().print("java.lang.NoSuchFieldError: Please recompile all of your source code.");
            }
            catch (IOException ignored) {
                // empty catch block
            }
            this.log(data.getStackTrace());
            Log.error(e.getMessage(), e);
        }
        catch (Throwable reallyScrewedNow) {
            StringBuffer msg = new StringBuffer();
            msg.append("Horrible Exception: ");
            if (data != null) {
                msg.append(data.getStackTrace());
            } else {
                msg.append(t);
            }
            try {
                res.setContentType(mimeType);
                res.setStatus(200);
                res.getWriter().print(msg.toString());
            }
            catch (Exception ignored) {
                // empty catch block
            }
            Log.error(reallyScrewedNow.getMessage(), reallyScrewedNow);
        }
    }

    public static synchronized void saveServletInfo(RunData data) {
        serverName = data.getRequest().getServerName();
        serverPort = new Integer(data.getRequest().getServerPort()).toString();
        serverScheme = data.getRequest().getScheme();
        scriptName = applicationRoot + data.getRequest().getServletPath();
        contextPath = data.getRequest().getContextPath();
    }

    public static void setApplicationRoot(String val) {
        applicationRoot = val;
    }

    public static String getApplicationRoot() {
        return applicationRoot;
    }

    public static String getRealPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return applicationRoot + "/" + path;
    }

    public void log(String msg) {
        this.services.notice(msg);
    }

    public void log(String message, Throwable t) {
        this.services.notice(message);
        this.services.error(t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

