/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.turbine.om.Retrievable;
import org.apache.turbine.services.intake.TurbineIntake;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.pool.Recyclable;

public class IntakeTool
implements ApplicationTool,
Recyclable {
    public static final String DEFAULT_KEY = "_0";
    private HashMap groups;
    private RunData data;
    private Map pullMap = new HashMap();
    HashMap declaredGroups = new HashMap();
    StringBuffer allGroupsSB = new StringBuffer(256);
    StringBuffer groupSB = new StringBuffer(128);
    private boolean disposed;

    public IntakeTool() {
        String[] groupNames = TurbineIntake.getGroupNames();
        this.groups = new HashMap((int)(1.25 * (double)groupNames.length + 1.0));
        this.pullMap = new HashMap((int)(1.25 * (double)groupNames.length + 1.0));
        int i = groupNames.length - 1;
        while (i >= 0) {
            this.pullMap.put(groupNames[i], new PullHelper(groupNames[i]));
            --i;
        }
    }

    public void init(Object runData) {
        int i;
        this.data = (RunData)runData;
        String[] groupKeys = this.data.getParameters().getStrings("intake-grp");
        String[] groupNames = null;
        if (groupKeys == null || groupKeys.length == 0) {
            groupNames = TurbineIntake.getGroupNames();
        } else {
            groupNames = new String[groupKeys.length];
            i = groupKeys.length - 1;
            while (i >= 0) {
                groupNames[i] = TurbineIntake.getGroupName(groupKeys[i]);
                --i;
            }
        }
        i = groupNames.length - 1;
        while (i >= 0) {
            try {
                ArrayList foundGroups = TurbineIntake.getGroup(groupNames[i]).getObjects(this.data);
                if (foundGroups != null) {
                    Iterator iter = foundGroups.iterator();
                    while (iter.hasNext()) {
                        Group group = (Group)iter.next();
                        this.groups.put(group.getObjectKey(), group);
                    }
                }
            }
            catch (Exception e) {
                Log.error(e);
            }
            --i;
        }
    }

    public String declareGroups() {
        this.allGroupsSB.setLength(0);
        Iterator i = this.groups.values().iterator();
        while (i.hasNext()) {
            this.declareGroup((Group)i.next(), this.allGroupsSB);
        }
        return this.allGroupsSB.toString();
    }

    public String declareGroup(Group group) {
        this.groupSB.setLength(0);
        this.declareGroup(group, this.groupSB);
        return this.groupSB.toString();
    }

    public void declareGroup(Group group, StringBuffer sb) {
        if (!this.declaredGroups.containsKey(group.getIntakeGroupName())) {
            this.declaredGroups.put(group.getIntakeGroupName(), null);
            sb.append("<input type=\"hidden\" name=\"").append("intake-grp\" value=\"").append(group.getGID()).append("\"></input>\n");
        }
        group.appendHtmlFormInput(sb);
    }

    public void newForm() {
        this.declaredGroups.clear();
        Iterator i = this.groups.values().iterator();
        while (i.hasNext()) {
            ((Group)i.next()).resetDeclared();
        }
    }

    public void refresh() {
    }

    public Object get(String groupName) throws Exception {
        return this.pullMap.get(groupName);
    }

    public boolean isAllValid() {
        boolean allValid = true;
        Iterator iter = this.groups.values().iterator();
        while (iter.hasNext()) {
            Group group = (Group)iter.next();
            allValid &= group.isAllValid();
        }
        return allValid;
    }

    public Group get(String groupName, String key) throws Exception {
        return ((PullHelper)this.get(groupName)).setKey(key);
    }

    public Group get(String groupName, String key, boolean create) throws Exception {
        return ((PullHelper)this.get(groupName)).setKey(key, create);
    }

    public void remove(Group group) {
        this.groups.remove(group.getObjectKey());
        group.removeFromRequest();
        TurbineIntake.releaseGroup(group);
    }

    public void removeAll() {
        Object[] allGroups = this.groups.values().toArray();
        int i = allGroups.length - 1;
        while (i >= 0) {
            Group group = (Group)allGroups[i];
            this.remove(group);
            --i;
        }
    }

    public Map getGroups() {
        return this.groups;
    }

    public void recycle() {
        this.disposed = false;
    }

    public void dispose() {
        Iterator iter = this.groups.values().iterator();
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            TurbineIntake.releaseGroup(g);
        }
        this.groups.clear();
        this.declaredGroups.clear();
        this.data = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public class PullHelper {
        String groupName;

        private PullHelper(String groupName) {
            this.groupName = groupName;
        }

        public Group getDefault() throws Exception {
            return this.setKey(IntakeTool.DEFAULT_KEY);
        }

        public Group setKey(String key) throws Exception {
            return this.setKey(key, true);
        }

        public Group setKey(String key, boolean create) throws Exception {
            Group g = null;
            String inputKey = TurbineIntake.getGroupKey(this.groupName) + key;
            if (IntakeTool.this.groups.containsKey(inputKey)) {
                g = (Group)IntakeTool.this.groups.get(inputKey);
            } else if (create) {
                g = TurbineIntake.getGroup(this.groupName);
                IntakeTool.this.groups.put(inputKey, g);
                g.init(key, IntakeTool.this.data);
            }
            return g;
        }

        public Group mapTo(Retrievable obj) throws Exception {
            Group g = null;
            try {
                String inputKey = TurbineIntake.getGroupKey(this.groupName) + obj.getQueryKey();
                if (IntakeTool.this.groups.containsKey(inputKey)) {
                    g = (Group)IntakeTool.this.groups.get(inputKey);
                } else {
                    g = TurbineIntake.getGroup(this.groupName);
                    IntakeTool.this.groups.put(inputKey, g);
                }
                return g.init(obj);
            }
            catch (Exception e) {
                Log.error(e);
                return null;
            }
        }
    }
}

