/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ValueParser;
import org.apache.turbine.util.parser.BaseValueParser;

public abstract class DataStreamParser
implements Iterator {
    private static final boolean DEBUG = false;
    protected static final String EMPTYFIELDNAME = "UNKNOWNFIELD";
    private List columnNames;
    private StreamTokenizer tokenizer;
    private ValueParser lineValues;
    private boolean neverRead = true;
    private String characterEncoding;
    private char fieldSeparator;

    public DataStreamParser(Reader in, List columnNames, String characterEncoding) {
        this.columnNames = columnNames;
        this.characterEncoding = characterEncoding;
        if (this.characterEncoding == null) {
            this.characterEncoding = "US-ASCII";
            try {
                this.characterEncoding = ((InputStreamReader)in).getEncoding();
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        this.tokenizer = new StreamTokenizer(new BufferedReader(in));
        this.initTokenizer(this.tokenizer);
    }

    protected void initTokenizer(StreamTokenizer tokenizer) {
        tokenizer.ordinaryChars(48, 57);
        tokenizer.ordinaryChars(45, 45);
        tokenizer.ordinaryChars(46, 46);
        tokenizer.wordChars(32, Integer.MAX_VALUE);
        tokenizer.quoteChar(34);
        tokenizer.eolIsSignificant(true);
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
        this.tokenizer.ordinaryChar(fieldSeparator);
    }

    public void setColumnNames(List columnNames) {
        this.columnNames = columnNames;
    }

    /*
     * Unable to fully structure code
     */
    public void readColumnNames() throws IOException {
        this.columnNames = new ArrayList<E>();
        lastTtype = 0;
        fieldCounter = 1;
        this.neverRead = false;
        this.tokenizer.nextToken();
        if (true) ** GOTO lbl32
        while (true) {
            if (this.tokenizer.ttype == this.fieldSeparator) ** GOTO lbl-1000
            if (this.tokenizer.ttype != 10) {
                this.columnNames.add(this.tokenizer.sval);
                ++fieldCounter;
            } else if (this.tokenizer.ttype == this.fieldSeparator && lastTtype == this.fieldSeparator) {
                this.columnNames.add("UNKNOWNFIELD" + fieldCounter);
                ++fieldCounter;
            } else {
                if (lastTtype == this.fieldSeparator) {
                    if (this.tokenizer.ttype == 10) {
                        this.columnNames.add("UNKNOWNFIELD" + fieldCounter);
                        break;
                    }
                }
                if (this.tokenizer.ttype == 10) break;
            }
            lastTtype = this.tokenizer.ttype;
            this.tokenizer.nextToken();
lbl32:
            // 2 sources

            if (this.tokenizer.ttype == -3) continue;
            if (this.tokenizer.ttype != 10 && this.tokenizer.ttype != 34 && this.tokenizer.ttype != this.fieldSeparator) break;
        }
    }

    public boolean hasNextRow() throws IOException {
        if (this.neverRead || this.tokenizer.ttype == 10) {
            this.tokenizer.nextToken();
            this.tokenizer.pushBack();
            this.neverRead = false;
        }
        return this.tokenizer.ttype != -1;
    }

    public ValueParser nextRow() throws IOException, NoSuchElementException {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException();
        }
        if (this.lineValues == null) {
            this.lineValues = new BaseValueParser(this.characterEncoding);
        } else {
            this.lineValues.clear();
        }
        Iterator it = this.columnNames.iterator();
        this.tokenizer.nextToken();
        while (this.tokenizer.ttype == -3 || this.tokenizer.ttype == 34 || this.tokenizer.ttype == this.fieldSeparator) {
            int lastTtype = 0;
            if (it.hasNext()) {
                String colname = it.next().toString();
                String colval = this.tokenizer.sval;
                if (this.tokenizer.ttype != this.fieldSeparator && lastTtype != this.fieldSeparator) {
                    this.lineValues.add(colname, colval);
                } else if (this.tokenizer.ttype == this.fieldSeparator && lastTtype != this.fieldSeparator) {
                    lastTtype = this.tokenizer.ttype;
                    this.tokenizer.nextToken();
                    if (this.tokenizer.ttype != this.fieldSeparator && this.tokenizer.sval != null) {
                        this.lineValues.add(colname, this.tokenizer.sval);
                    } else if (this.tokenizer.ttype == 10) {
                        this.tokenizer.pushBack();
                    }
                }
            }
            this.tokenizer.nextToken();
        }
        return this.lineValues;
    }

    public boolean hasNext() {
        boolean hasNext = false;
        try {
            hasNext = this.hasNextRow();
        }
        catch (IOException e) {
            Log.error("IOException in CSVParser.hasNext", e);
        }
        return hasNext;
    }

    public Object next() throws NoSuchElementException {
        ValueParser nextRow = null;
        try {
            nextRow = this.nextRow();
        }
        catch (IOException e) {
            Log.error("IOException in CSVParser.next", e);
            throw new NoSuchElementException();
        }
        return nextRow;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

