/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.velocity;

import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.mail.SimpleEmail;
import org.apache.velocity.context.Context;

public class VelocityEmail {
    private String toName = null;
    private String toEmail = null;
    private String fromName = null;
    private String fromEmail = null;
    private String subject = null;
    private int wordWrap = 0;
    private String template = null;
    private Context context = null;

    public VelocityEmail() {
    }

    public VelocityEmail(Context context) {
        this.context = context;
    }

    public VelocityEmail setTo(String to, String email) {
        this.toName = to;
        this.toEmail = email;
        return this;
    }

    public VelocityEmail setFrom(String from, String email) {
        this.fromName = from;
        this.fromEmail = email;
        return this;
    }

    public VelocityEmail setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public VelocityEmail setTemplate(String template) {
        this.template = template;
        return this;
    }

    public VelocityEmail setWordWrap(int wordWrap) {
        this.wordWrap = wordWrap;
        return this;
    }

    public VelocityEmail setContext(Context context) {
        this.context = context;
        return this;
    }

    public Context getContext() {
        return this.context;
    }

    public void send() throws Exception {
        String body = TurbineVelocity.handleRequest(this.context, this.template);
        if (this.wordWrap > 0) {
            body = StringUtils.wrapText(body, System.getProperty("line.separator"), this.wordWrap);
        }
        SimpleEmail se = new SimpleEmail();
        se.setFrom(this.fromEmail, this.fromName);
        se.addTo(this.toEmail, this.toName);
        se.setSubject(this.subject);
        se.setMsg(body);
        se.send();
    }

    public String toString() {
        try {
            this.send();
        }
        catch (Exception e) {
            Log.error("VelocityEmail error", e);
        }
        return "";
    }
}

