/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.strategy;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.strategy.IdStoringStrategy;

public class DefaultIdStoringStrategy
extends IdStoringStrategy {
    private Map idByBeanMap;
    private Map beanByIdMap;

    public DefaultIdStoringStrategy() {
        this(new HashMap(), new HashMap());
    }

    public DefaultIdStoringStrategy(Map idByBeanMap, Map beanByIdMap) {
        this.idByBeanMap = idByBeanMap;
        this.beanByIdMap = beanByIdMap;
    }

    public String getReferenceFor(Context context, Object bean) {
        return (String)this.idByBeanMap.get(bean);
    }

    public void setReference(Context context, Object bean, String id) {
        if (!this.idByBeanMap.containsKey(bean)) {
            this.idByBeanMap.put(bean, id);
            this.beanByIdMap.put(id, bean);
        }
    }

    public Object getReferenced(Context context, String id) {
        return this.beanByIdMap.get(id);
    }

    public void reset() {
        this.idByBeanMap.clear();
        this.beanByIdMap.clear();
    }
}

