/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.resources;

import java.util.StringTokenizer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.flexdock.plaf.resources.ResourceHandler;

public class FontResourceHandler
extends ResourceHandler {
    public static final String BASE_FONT_KEY = "Panel.font";

    public Object getResource(String fontData) {
        if (fontData == null) {
            return null;
        }
        String name = null;
        int style = -1;
        int size = -1;
        if (!fontData.endsWith(",")) {
            fontData = fontData + ",";
        }
        StringTokenizer st = new StringTokenizer(fontData, ",");
        int i = 0;
        while (st.hasMoreTokens()) {
            switch (i) {
                case 0: {
                    name = this.getFontName(st.nextToken());
                    break;
                }
                case 1: {
                    style = this.getInt(st.nextToken(), 0);
                    break;
                }
                case 2: {
                    size = this.getInt(st.nextToken(), 10);
                }
            }
            ++i;
        }
        FontUIResource defaultFont = (FontUIResource)UIManager.getDefaults().getFont(BASE_FONT_KEY);
        if (name == null) {
            name = defaultFont.getName();
        }
        if (style == -1) {
            style = defaultFont.getStyle();
        }
        if (size == -1) {
            size = defaultFont.getSize();
        }
        return new FontUIResource(name, style, size);
    }

    private String getFontName(String data) {
        data = data == null ? null : data.trim();
        return data == null || data.length() == 0 ? null : data;
    }

    private int getInt(String data, int defaultValue) {
        data = data == null ? "" : data.trim();
        try {
            return Integer.parseInt(data);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

