/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.EncryptionHandler;
import com.adobe.epubcheck.ocf.OCFHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.util.Hashtable;

public class OCFChecker {
    OCFPackage ocf;
    Report report;
    Hashtable encryptedItems;
    static XMLValidator containerValidator = new XMLValidator("rng/container.rng");
    static XMLValidator encryptionValidator = new XMLValidator("rng/encryption.rng");
    static XMLValidator signatureValidator = new XMLValidator("rng/signatures.rng");

    public OCFChecker(OCFPackage ocf, Report report) {
        this.ocf = ocf;
        this.report = report;
    }

    public void runChecks() {
        String signatureEntry;
        String containerEntry = "META-INF/container.xml";
        if (!this.ocf.hasEntry(containerEntry)) {
            this.report.error(null, 0, "Required META-INF/container.xml resource is missing");
            return;
        }
        XMLParser containerParser = new XMLParser(this.ocf, containerEntry, this.report);
        OCFHandler containerHandler = new OCFHandler(containerParser);
        containerParser.addXMLHandler(containerHandler);
        containerParser.addValidator(containerValidator);
        containerParser.process();
        String rootPath = containerHandler.getRootPath();
        String encryptionEntry = "META-INF/encryption.xml";
        if (this.ocf.hasEntry(encryptionEntry)) {
            XMLParser encryptionParser = new XMLParser(this.ocf, encryptionEntry, this.report);
            EncryptionHandler encryptionHandler = new EncryptionHandler(encryptionParser, this.ocf);
            encryptionParser.addXMLHandler(encryptionHandler);
            encryptionParser.addValidator(encryptionValidator);
            encryptionParser.process();
        }
        if (this.ocf.hasEntry(signatureEntry = "META-INF/signatures.xml")) {
            XMLParser signatureParser = new XMLParser(this.ocf, signatureEntry, this.report);
            OCFHandler signatureHandler = new OCFHandler(signatureParser);
            signatureParser.addXMLHandler(signatureHandler);
            signatureParser.addValidator(signatureValidator);
            signatureParser.process();
        }
        if (rootPath != null) {
            OPFChecker opfChecker = new OPFChecker(this.ocf, this.report, rootPath, containerHandler.getContainerEntries());
            opfChecker.runChecks();
        }
    }

    public String processRootPath(String rootPath) {
        String rootBase = rootPath;
        if (rootPath.endsWith(".opf")) {
            int slash = rootPath.lastIndexOf("/");
            if (slash < rootPath.lastIndexOf("\\")) {
                slash = rootPath.lastIndexOf("\\");
            }
            rootBase = slash >= 0 && slash + 1 < rootPath.length() ? rootPath.substring(0, slash + 1) : rootPath;
            return rootBase;
        }
        System.out.println("RootPath is not an OPF file");
        return null;
    }
}

