/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.counts.CountsReaderI;
import org.campagnelab.goby.counts.Peak;
import org.campagnelab.goby.exception.GobyRuntimeException;

public class PeakAggregator
implements Iterator<Peak>,
Iterable<Peak> {
    private static final Log LOG = LogFactory.getLog(PeakAggregator.class);
    private final CountsReaderI reader;
    private boolean nextLoaded;
    private int peakDetectionThreshold;
    private final Peak currentPeak;

    public PeakAggregator(CountsReaderI reader) {
        this.reader = reader;
        this.currentPeak = new Peak();
    }

    @Override
    public boolean hasNext() {
        if (this.nextLoaded) {
            return true;
        }
        try {
            int baseCount;
            this.currentPeak.start = -1;
            this.currentPeak.length = 0;
            this.currentPeak.count = 0;
            while (this.reader.hasNextTransition()) {
                this.reader.nextTransition();
                baseCount = this.reader.getCount();
                if (baseCount <= this.peakDetectionThreshold) continue;
                this.nextLoaded = true;
                this.currentPeak.count += baseCount;
                this.currentPeak.length += this.reader.getLength();
                break;
            }
            this.currentPeak.start = this.reader.getPosition();
            while (this.reader.hasNextTransition()) {
                this.reader.nextTransition();
                baseCount = this.reader.getCount();
                if (baseCount > this.peakDetectionThreshold) {
                    this.currentPeak.length += this.reader.getLength();
                    this.currentPeak.count += baseCount;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
            throw new GobyRuntimeException(e);
        }
        return this.nextLoaded;
    }

    @Override
    public Peak next() {
        if (this.hasNext()) {
            this.nextLoaded = false;
            return this.currentPeak;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This operation is not supported. Peaks are read-only.");
    }

    @Override
    public Iterator<Peak> iterator() {
        return this;
    }

    public void setPeakDetectionThreshold(int peakDetectionThreshold) {
        this.peakDetectionThreshold = peakDetectionThreshold;
    }
}

