/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DTDAttributeTypeInfo;
import gnu.xml.dom.DTDElementTypeInfo;
import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomCDATASection;
import gnu.xml.dom.DomComment;
import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocumentConfiguration;
import gnu.xml.dom.DomDocumentFragment;
import gnu.xml.dom.DomElement;
import gnu.xml.dom.DomEntity;
import gnu.xml.dom.DomEntityReference;
import gnu.xml.dom.DomImpl;
import gnu.xml.dom.DomNamedNodeMap;
import gnu.xml.dom.DomNode;
import gnu.xml.dom.DomNodeIterator;
import gnu.xml.dom.DomNotation;
import gnu.xml.dom.DomNsNode;
import gnu.xml.dom.DomProcessingInstruction;
import gnu.xml.dom.DomText;
import gnu.xml.dom.DomXPathExpression;
import gnu.xml.dom.DomXPathNSResolver;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathExpression;
import org.w3c.dom.xpath.XPathNSResolver;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DomDocument
extends DomNode
implements Document,
DocumentTraversal,
XPathEvaluator {
    private final DOMImplementation implementation;
    private boolean checkingCharacters;
    boolean checkingWellformedness;
    boolean building;
    DomDocumentConfiguration config;
    String inputEncoding;
    String encoding;
    String version;
    boolean standalone;
    String systemId;

    public void setBuilding(boolean bl) {
        this.building = bl;
    }

    public void setCheckWellformedness(boolean bl) {
        this.checkingWellformedness = bl;
    }

    public final String getNodeName() {
        return "#document";
    }

    public final Element getDocumentElement() {
        DomNode domNode = this.first;
        while (domNode != null) {
            if (domNode.nodeType == 1) {
                return (Element)((Object)domNode);
            }
            domNode = domNode.next;
        }
        return null;
    }

    public final DocumentType getDoctype() {
        DomNode domNode = this.first;
        while (domNode != null) {
            if (domNode.nodeType == 10) {
                return (DocumentType)((Object)domNode);
            }
            domNode = domNode.next;
        }
        return null;
    }

    public final DOMImplementation getImplementation() {
        return this.implementation;
    }

    /*
     * Unable to fully structure code
     */
    public Element getElementById(String var1_1) {
        if (var1_1 == null || var1_1.length() == 0) {
            return null;
        }
        var2_2 = (DomDoctype)this.getDoctype();
        if (var2_2 != null && !var2_2.hasIds()) {
            var2_2 = null;
        }
        if ((var3_3 = this.getDocumentElement()) != null) ** GOTO lbl36
        return null;
lbl-1000:
        // 1 sources

        {
            if (var3_3.getNodeType() == 1) {
                var5_5 = (DomElement)var3_3;
                if (var2_2 != null) {
                    var6_6 = var2_2.getElementTypeInfo(var3_3.getNodeName());
                    if (var6_6 != null && var1_1.equals(var5_5.getAttribute(var6_6.idAttrName))) {
                        return var5_5;
                    }
                    if (var5_5.userIdAttrs != null) {
                        var7_7 = var5_5.userIdAttrs.iterator();
                        while (var7_7.hasNext()) {
                            var8_8 = (Node)var7_7.next();
                            if (!var1_1.equals(var8_8.getNodeValue())) continue;
                            return var5_5;
                        }
                    }
                }
                if ((var6_6 = var5_5.getAttribute("xml:id")) == null) {
                    var6_6 = var5_5.getAttributeNS("http://www.w3.org/XML/1998/namespace", "id");
                }
                if (var1_1.equals(var6_6)) {
                    return var5_5;
                }
            }
            if (var3_3.hasChildNodes()) {
                var3_3 = var3_3.getFirstChild();
                continue;
            }
            var4_4 = var3_3.getNextSibling();
            if (var4_4 != null) {
                var3_3 = var4_4;
                continue;
            }
            do {
                if ((var4_4 = var3_3.getParentNode()) != null) continue;
                return null;
            } while ((var4_4 = (var3_3 = var4_4).getNextSibling()) == null);
            var3_3 = var4_4;
lbl36:
            // 4 sources

            ** while (var3_3 != this)
        }
lbl37:
        // 1 sources

        return null;
    }

    private final void checkNewChild(Node node2) {
        if (node2.getNodeType() == 1 && this.getDocumentElement() != null) {
            throw new DomDOMException(3, "document element already present: " + this.getDocumentElement(), node2, 0);
        }
        if (node2.getNodeType() == 10 && this.getDoctype() != null) {
            throw new DomDOMException(3, "document type already present: " + this.getDoctype(), node2, 0);
        }
    }

    public Node appendChild(Node node2) {
        if (this.checkingWellformedness) {
            this.checkNewChild(node2);
        }
        return super.appendChild(node2);
    }

    public Node insertBefore(Node node2, Node node3) {
        if (this.checkingWellformedness) {
            this.checkNewChild(node2);
        }
        return super.insertBefore(node2, node3);
    }

    public Node replaceChild(Node node2, Node node3) {
        if (this.checkingWellformedness && (node2.getNodeType() == 1 && node3.getNodeType() != 1 || node2.getNodeType() == 10 && node3.getNodeType() != 10)) {
            this.checkNewChild(node2);
        }
        return super.replaceChild(node2, node3);
    }

    public static void verifyXmlName(String string) {
        DomDocument.checkName(string, false);
    }

    static void checkName(String string, boolean bl) {
        int n;
        if (string == null) {
            throw new DomDOMException(14, string, null, 0);
        }
        int n2 = string.length();
        if (n2 == 0) {
            throw new DomDOMException(14, string, null, 0);
        }
        char c = string.charAt(0);
        if (bl) {
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == ':' || c == '_' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd' || c >= '\u10000' && c <= '\ueffff')) {
                throw new DomDOMException(5, string, null, c);
            }
        } else {
            n = Character.getType(c);
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 10: {
                    if ((c <= '\uf900' || c >= '\ufffe') && (c < '\u20dd' || c > '\u20e0')) break;
                    throw new DomDOMException(5, string, null, c);
                }
                default: {
                    if (c == ':' || c == '_' || c >= '\u02bb' && c <= '\u02c1' || c == '\u0559' || c == '\u06e5' || c == '\u06e6') break;
                    throw new DomDOMException(5, string, null, c);
                }
            }
        }
        n = 1;
        while (n < n2) {
            c = string.charAt(n);
            if (bl) {
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ':' || c == '_' || c == '-' || c == '.' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd' || c >= '\u10000' && c <= '\ueffff' || c == '\u00b7' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040')) {
                    throw new DomDOMException(5, string, null, c);
                }
            } else {
                int n3 = Character.getType(c);
                switch (n3) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        if ((c <= '\uf900' || c >= '\ufffe') && (c < '\u20dd' || c > '\u20e0')) break;
                        throw new DomDOMException(5, string, null, c);
                    }
                    default: {
                        if (c == '-' || c == '.' || c == ':' || c == '_' || c == '\u0387' || c >= '\u02bb' && c <= '\u02c1' || c == '\u0559' || c == '\u06e5' || c == '\u06e6' || c == '\u00b7') break;
                        throw new DomDOMException(5, string, null, c);
                    }
                }
            }
            ++n;
        }
    }

    static void checkNCName(String string, boolean bl) {
        DomDocument.checkName(string, bl);
        int n = string.length();
        int n2 = string.indexOf(58);
        if (n2 != -1 && (n2 == 0 || n2 == n - 1 || string.lastIndexOf(58) != n2)) {
            throw new DomDOMException(14, string, null, 0);
        }
    }

    static void checkChar(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        DomDocument.checkChar(cArray, 0, cArray.length, bl);
    }

    static void checkChar(char[] cArray, int n, int n2, boolean bl) {
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            if (!(c >= ' ' && c <= '\ud7ff' || c == '\n' || c == '\r' || c == '\t' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff' || bl && (c >= '\u0001' && c <= '\u001f' || c >= '\u007f' && c <= '\u0084' || c >= '\u0086' && c <= '\u009f'))) {
                throw new DomDOMException(5, new String(cArray, n, n2), null, c);
            }
            ++n3;
        }
    }

    public Element createElement(String string) {
        Element element;
        if (this.checkingCharacters) {
            DomDocument.checkName(string, "1.1".equals(this.version));
        }
        if (string.startsWith("xml:")) {
            element = this.createElementNS(null, string);
        } else {
            DomElement domElement = new DomElement(this, null, string);
            domElement.localName = null;
            element = domElement;
        }
        this.defaultAttributes(element, string);
        return element;
    }

    public Element createElementNS(String string, String string2) {
        if (this.checkingCharacters) {
            DomDocument.checkNCName(string2, "1.1".equals(this.version));
        }
        if ("".equals(string)) {
            string = null;
        }
        if (string2.startsWith("xml:")) {
            if (string != null && !"http://www.w3.org/XML/1998/namespace".equals(string)) {
                throw new DomDOMException(14, "xml namespace is always http://www.w3.org/XML/1998/namespace", this, 0);
            }
            string = "http://www.w3.org/XML/1998/namespace";
        } else {
            if ("xmlns".equals(string2) || string2.startsWith("xmlns:")) {
                throw new DomDOMException(14, "xmlns is reserved", this, 0);
            }
            if (string == null && string2.indexOf(58) != -1) {
                throw new DomDOMException(14, "prefixed name '" + string2 + "' needs a URI", this, 0);
            }
        }
        DomElement domElement = new DomElement(this, string, string2);
        this.defaultAttributes(domElement, string2);
        return domElement;
    }

    private final void defaultAttributes(Element element, String string) {
        DomDoctype domDoctype = (DomDoctype)this.getDoctype();
        if (domDoctype == null) {
            return;
        }
        DTDElementTypeInfo dTDElementTypeInfo = domDoctype.getElementTypeInfo(string);
        if (dTDElementTypeInfo != null) {
            Iterator iterator = dTDElementTypeInfo.attributes();
            while (iterator != null && iterator.hasNext()) {
                DTDAttributeTypeInfo dTDAttributeTypeInfo = (DTDAttributeTypeInfo)iterator.next();
                DomAttr domAttr = (DomAttr)this.createAttribute(dTDAttributeTypeInfo.name);
                String string2 = dTDAttributeTypeInfo.value;
                if (string2 == null) {
                    string2 = "";
                }
                domAttr.setValue(string2);
                domAttr.setSpecified(false);
                element.setAttributeNode(domAttr);
            }
        }
    }

    public DocumentFragment createDocumentFragment() {
        return new DomDocumentFragment(this);
    }

    public Text createTextNode(String string) {
        if (this.checkingCharacters) {
            DomDocument.checkChar(string, "1.1".equals(this.version));
        }
        return new DomText(this, string);
    }

    public Text createTextNode(char[] cArray, int n, int n2) {
        if (this.checkingCharacters) {
            DomDocument.checkChar(cArray, n, n2, "1.1".equals(this.version));
        }
        return new DomText(this, cArray, n, n2);
    }

    public Comment createComment(String string) {
        if (this.checkingCharacters) {
            DomDocument.checkChar(string, "1.1".equals(this.version));
        }
        return new DomComment(this, string);
    }

    public CDATASection createCDATASection(String string) {
        if (this.checkingCharacters) {
            DomDocument.checkChar(string, "1.1".equals(this.version));
        }
        return new DomCDATASection(this, string);
    }

    public CDATASection createCDATASection(char[] cArray, int n, int n2) {
        if (this.checkingCharacters) {
            DomDocument.checkChar(cArray, n, n2, "1.1".equals(this.version));
        }
        return new DomCDATASection(this, cArray, n, n2);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        if (this.checkingCharacters) {
            boolean bl = "1.1".equals(this.version);
            DomDocument.checkName(string, bl);
            if ("xml".equalsIgnoreCase(string)) {
                throw new DomDOMException(12, "illegal PI target name", this, 0);
            }
            DomDocument.checkChar(string2, bl);
        }
        return new DomProcessingInstruction(this, string, string2);
    }

    public Attr createAttribute(String string) {
        if (this.checkingCharacters) {
            DomDocument.checkName(string, "1.1".equals(this.version));
        }
        if (string.startsWith("xml:")) {
            return this.createAttributeNS("http://www.w3.org/XML/1998/namespace", string);
        }
        if ("xmlns".equals(string) || string.startsWith("xmlns:")) {
            return this.createAttributeNS("http://www.w3.org/2000/xmlns/", string);
        }
        DomAttr domAttr = new DomAttr(this, null, string);
        domAttr.localName = null;
        return domAttr;
    }

    public Attr createAttributeNS(String string, String string2) {
        if (this.checkingCharacters) {
            DomDocument.checkNCName(string2, "1.1".equals(this.version));
        }
        if ("".equals(string)) {
            string = null;
        }
        if (string2.startsWith("xml:")) {
            if (string == null) {
                string = "http://www.w3.org/XML/1998/namespace";
            } else if (!"http://www.w3.org/XML/1998/namespace".equals(string)) {
                throw new DomDOMException(14, "xml namespace is always http://www.w3.org/XML/1998/namespace", this, 0);
            }
        } else if ("xmlns".equals(string2) || string2.startsWith("xmlns:")) {
            if (string == null) {
                string = "http://www.w3.org/2000/xmlns/";
            } else if (!"http://www.w3.org/2000/xmlns/".equals(string)) {
                throw new DomDOMException(14, "xmlns namespace must be http://www.w3.org/2000/xmlns/", this, 0);
            }
        } else if (string == null && string2.indexOf(58) != -1) {
            throw new DomDOMException(14, "prefixed name needs a URI: " + string2, this, 0);
        }
        return new DomAttr(this, string, string2);
    }

    public EntityReference createEntityReference(String string) {
        DomEntity domEntity;
        DomEntityReference domEntityReference = new DomEntityReference(this, string);
        DocumentType documentType = this.getDoctype();
        if (documentType != null && (domEntity = (DomEntity)documentType.getEntities().getNamedItem(string)) != null) {
            DomNode domNode = domEntity.first;
            while (domNode != null) {
                domEntityReference.appendChild(domNode.cloneNode(true));
                domNode = domNode.next;
            }
        }
        domEntityReference.makeReadonly();
        return domEntityReference;
    }

    public Node importNode(Node node2, boolean bl) {
        Node node3 = null;
        switch (node2.getNodeType()) {
            case 3: {
                node3 = this.createTextNode(node2.getNodeValue());
                break;
            }
            case 4: {
                node3 = this.createCDATASection(node2.getNodeValue());
                break;
            }
            case 8: {
                node3 = this.createComment(node2.getNodeValue());
                break;
            }
            case 7: {
                node3 = this.createProcessingInstruction(node2.getNodeName(), node2.getNodeValue());
                break;
            }
            case 12: {
                Notation notation = (Notation)node2;
                node3 = new DomNotation(this, notation.getNodeName(), notation.getPublicId(), notation.getSystemId());
                break;
            }
            case 6: {
                Entity entity = (Entity)node2;
                node3 = new DomEntity(this, entity.getNodeName(), entity.getPublicId(), entity.getSystemId(), entity.getNotationName());
                if (!bl) break;
                Node node4 = node2.getFirstChild();
                while (node4 != null) {
                    node3.appendChild(this.importNode(node4, bl));
                    node4 = node4.getNextSibling();
                }
                break;
            }
            case 5: {
                node3 = this.createEntityReference(node2.getNodeName());
                break;
            }
            case 11: {
                node3 = new DomDocumentFragment(this);
                if (!bl) break;
                Node node5 = node2.getFirstChild();
                while (node5 != null) {
                    node3.appendChild(this.importNode(node5, bl));
                    node5 = node5.getNextSibling();
                }
                break;
            }
            case 2: {
                String string = node2.getNamespaceURI();
                node3 = string != null ? this.createAttributeNS(string, node2.getNodeName()) : this.createAttribute(node2.getNodeName());
                Node node6 = node2.getFirstChild();
                while (node6 != null) {
                    node3.appendChild(this.importNode(node6, false));
                    node6 = node6.getNextSibling();
                }
                break;
            }
            case 1: {
                String string = node2.getNamespaceURI();
                node3 = string != null ? this.createElementNS(string, node2.getNodeName()) : this.createElement(node2.getNodeName());
                NamedNodeMap namedNodeMap = node2.getAttributes();
                NamedNodeMap namedNodeMap2 = node3.getAttributes();
                int n = namedNodeMap.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Attr attr = (Attr)namedNodeMap.item(n2);
                    Attr attr2 = (Attr)namedNodeMap2.getNamedItem(attr.getNodeName());
                    if (attr2 != null) {
                        String string2 = attr.getNodeValue();
                        if (!attr2.getNodeValue().equals(string2) || attr.getSpecified()) {
                            attr2.setNodeValue(string2);
                        }
                    } else {
                        namedNodeMap2.setNamedItem((Attr)this.importNode(attr, false));
                    }
                    ++n2;
                }
                if (!bl) break;
                Node node7 = node2.getFirstChild();
                while (node7 != null) {
                    node3.appendChild(this.importNode(node7, true));
                    node7 = node7.getNextSibling();
                }
                break;
            }
            default: {
                throw new DomDOMException(9, null, node2, 0);
            }
        }
        if (node2 instanceof DomNode) {
            ((DomNode)node2).notifyUserDataHandlers((short)2, node2, node3);
        }
        return node3;
    }

    public NodeIterator createNodeIterator(Node node2, int n, NodeFilter nodeFilter, boolean bl) {
        return new DomNodeIterator(node2, n, nodeFilter, bl, false);
    }

    public TreeWalker createTreeWalker(Node node2, int n, NodeFilter nodeFilter, boolean bl) {
        return new DomNodeIterator(node2, n, nodeFilter, bl, true);
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String string) {
        this.inputEncoding = string;
    }

    public String getXmlEncoding() {
        return this.encoding;
    }

    public void setXmlEncoding(String string) {
        this.encoding = string;
    }

    public boolean getXmlStandalone() {
        return this.standalone;
    }

    public void setXmlStandalone(boolean bl) {
        this.standalone = bl;
    }

    public String getXmlVersion() {
        return this.version;
    }

    public void setXmlVersion(String string) {
        if (string == null) {
            string = "1.0";
        }
        if (!"1.0".equals(string) && !"1.1".equals(string)) {
            throw new DomDOMException(9);
        }
        this.version = string;
    }

    public boolean getStrictErrorChecking() {
        return this.checkingCharacters;
    }

    public void setStrictErrorChecking(boolean bl) {
        this.checkingCharacters = bl;
    }

    public String lookupPrefix(String string) {
        Element element = this.getDocumentElement();
        return element == null ? null : element.lookupPrefix(string);
    }

    public boolean isDefaultNamespace(String string) {
        Element element = this.getDocumentElement();
        boolean bl = false;
        if (element != null) {
            bl = element.isDefaultNamespace(string);
        }
        return bl;
    }

    public String lookupNamespaceURI(String string) {
        Element element = this.getDocumentElement();
        return element == null ? null : element.lookupNamespaceURI(string);
    }

    public String getBaseURI() {
        return this.getDocumentURI();
    }

    public String getDocumentURI() {
        return this.systemId;
    }

    public void setDocumentURI(String string) {
        this.systemId = string;
    }

    public Node adoptNode(Node node2) {
        short s = node2.getNodeType();
        switch (s) {
            case 9: 
            case 10: {
                throw new DomDOMException(9);
            }
            case 6: 
            case 12: {
                throw new DomDOMException(7);
            }
        }
        if (node2 instanceof DomNode) {
            DomNode domNode;
            DomNode domNode2 = domNode = (DomNode)node2;
            if (domNode2.parent != null) {
                domNode2 = (DomNode)domNode2.cloneNode(true);
            }
            domNode2.setOwner(this);
            domNode.notifyUserDataHandlers((short)5, domNode, domNode2);
            return domNode2;
        }
        Node node3 = null;
        switch (s) {
            case 2: {
                Attr attr = (Attr)node2;
                String string = attr.getNodeName();
                String string2 = attr.getLocalName();
                String string3 = attr.getNamespaceURI();
                node3 = string2 == null ? this.createAttribute(string) : this.createAttributeNS(string3, string);
                this.adoptChildren(attr, node3);
                break;
            }
            case 4: {
                CDATASection cDATASection = (CDATASection)node2;
                node3 = this.createCDATASection(cDATASection.getData());
                break;
            }
            case 8: {
                Comment comment = (Comment)node2;
                node3 = this.createComment(comment.getData());
                break;
            }
            case 11: {
                DocumentFragment documentFragment = (DocumentFragment)node2;
                node3 = this.createDocumentFragment();
                this.adoptChildren(documentFragment, node3);
                break;
            }
            case 1: {
                Element element = (Element)node2;
                String string = element.getNodeName();
                String string4 = element.getLocalName();
                String string5 = element.getNamespaceURI();
                node3 = string4 == null ? this.createElement(string) : this.createElementNS(string5, string);
                this.adoptAttributes(element, node3);
                this.adoptChildren(element, node3);
                break;
            }
            case 5: {
                EntityReference entityReference = (EntityReference)node2;
                node3 = this.createEntityReference(entityReference.getNodeName());
                this.adoptChildren(entityReference, node3);
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node2;
                node3 = this.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 3: {
                Text text = (Text)node2;
                node3 = this.createTextNode(text.getData());
                break;
            }
        }
        return node3;
    }

    void adoptChildren(Node node2, Node node3) {
        Node node4 = node2.getFirstChild();
        while (node4 != null) {
            Node node5 = node4.getNextSibling();
            node3.appendChild(this.adoptNode(node4));
            node4 = node5;
        }
    }

    void adoptAttributes(Node node2, Node node3) {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        NamedNodeMap namedNodeMap2 = node3.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node4 = namedNodeMap.item(n2);
            String string = node4.getLocalName();
            if (string == null) {
                namedNodeMap2.setNamedItem(this.adoptNode(node4));
            } else {
                namedNodeMap2.setNamedItemNS(this.adoptNode(node4));
            }
            ++n2;
        }
    }

    public DOMConfiguration getDomConfig() {
        if (this.config == null) {
            this.config = new DomDocumentConfiguration();
        }
        return this.config;
    }

    public boolean isEqualNode(Node node2) {
        if (!super.isEqualNode(node2)) {
            return false;
        }
        Document document = (Document)node2;
        String string = document.getXmlVersion();
        if (string == null || !string.equals(this.version)) {
            return false;
        }
        boolean bl = document.getXmlStandalone();
        if (bl != this.standalone) {
            return false;
        }
        String string2 = document.getXmlEncoding();
        return !(string2 == null || string2.equalsIgnoreCase("UTF-8") ? this.encoding != null && !this.encoding.equalsIgnoreCase("UTF-8") : !string2.equals(this.encoding));
    }

    public void normalizeDocument() {
        boolean bl = this.building;
        this.building = true;
        this.normalizeNode(this);
        this.building = bl;
    }

    void normalizeNode(DomNode domNode) {
        Object object;
        domNode.normalize();
        if (this.config != null) {
            switch (domNode.nodeType) {
                case 4: {
                    if (!this.config.cdataSections) {
                        object = this.createTextNode(domNode.getNodeValue());
                        domNode.parent.insertBefore((Node)object, domNode);
                        domNode.parent.removeChild(domNode);
                        String string = object.getWholeText();
                        domNode = (DomNode)((Object)object.replaceWholeText(string));
                        break;
                    }
                    if (!this.config.splitCdataSections) break;
                    object = domNode.getNodeValue();
                    int n = ((String)object).indexOf("]]>");
                    while (n != -1) {
                        CDATASection cDATASection = this.createCDATASection(((String)object).substring(0, n));
                        domNode.parent.insertBefore(cDATASection, domNode);
                        object = ((String)object).substring(n + 3);
                        domNode.setNodeValue((String)object);
                        n = ((String)object).indexOf("]]>");
                    }
                    break;
                }
                case 8: {
                    if (this.config.comments) break;
                    domNode.parent.removeChild(domNode);
                    break;
                }
                case 3: {
                    if (this.config.elementContentWhitespace || !((Text)((Object)domNode)).isElementContentWhitespace()) break;
                    domNode.parent.removeChild(domNode);
                    break;
                }
                case 5: {
                    if (this.config.entities) break;
                    object = domNode.first;
                    while (object != null) {
                        DomNode domNode2 = ((DomNode)object).next;
                        domNode.parent.insertBefore((Node)object, domNode);
                        object = domNode2;
                    }
                    domNode.parent.removeChild(domNode);
                    break;
                }
                case 1: {
                    if (this.config.namespaceDeclarations) break;
                    object = (DomNamedNodeMap)domNode.getAttributes();
                    boolean bl = ((DomNamedNodeMap)object).readonly;
                    ((DomNamedNodeMap)object).readonly = false;
                    int n = ((DomNamedNodeMap)object).getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        Node node2 = ((DomNamedNodeMap)object).item(n2);
                        String string = node2.getNamespaceURI();
                        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
                            ((DomNamedNodeMap)object).removeNamedItemNS(string, node2.getLocalName());
                            --n2;
                            --n;
                        }
                        ++n2;
                    }
                    ((DomNamedNodeMap)object).readonly = bl;
                    break;
                }
            }
        }
        object = domNode.first;
        while (object != null) {
            DomNode domNode3 = ((DomNode)object).next;
            this.normalizeNode((DomNode)object);
            object = domNode3;
        }
    }

    public Node renameNode(Node node2, String string, String string2) throws DOMException {
        if (node2 instanceof DomNsNode) {
            DomNsNode domNsNode = (DomNsNode)node2;
            if (domNsNode == null) {
                throw new DomDOMException(8);
            }
            if (domNsNode.owner != this) {
                throw new DomDOMException(4, null, domNsNode, 0);
            }
            boolean bl = "1.1".equals(this.version);
            DomDocument.checkName(string2, bl);
            int n = string2.indexOf(58);
            if ("".equals(string)) {
                string = null;
            }
            if (string != null) {
                String string3;
                DomDocument.checkNCName(string2, bl);
                String string4 = string3 = n == -1 ? "" : string2.substring(0, n);
                if ("xml".equals(string3) && !"http://www.w3.org/XML/1998/namespace".equals(string)) {
                    throw new DomDOMException(14, "xml namespace must be http://www.w3.org/XML/1998/namespace", domNsNode, 0);
                }
                if (domNsNode.nodeType == 2 && ("xmlns".equals(string3) || "xmlns".equals(string2)) && !"http://www.w3.org/2000/xmlns/".equals(string)) {
                    throw new DomDOMException(14, "xmlns namespace must be http://www.w3.org/2000/xmlns/", domNsNode, 0);
                }
                if ("http://www.w3.org/XML/1998/namespace".equals(string) && !"xml".equals(string3)) {
                    throw new DomDOMException(14, "xml namespace must be http://www.w3.org/XML/1998/namespace", domNsNode, 0);
                }
                if (domNsNode.nodeType == 2 && "http://www.w3.org/2000/xmlns/".equals(string) && !"xmlns".equals(string3) && !"xmlns".equals(string2)) {
                    throw new DomDOMException(14, "xmlns namespace must be http://www.w3.org/2000/xmlns/", domNsNode, 0);
                }
            }
            domNsNode.setNodeName(string2);
            domNsNode.setNamespaceURI(string);
            domNsNode.notifyUserDataHandlers((short)4, domNsNode, domNsNode);
            return domNsNode;
        }
        throw new DomDOMException(9, null, node2, 0);
    }

    public XPathExpression createExpression(String string, XPathNSResolver xPathNSResolver) throws XPathException, DOMException {
        return new DomXPathExpression(this, string, xPathNSResolver);
    }

    public XPathNSResolver createNSResolver(Node node2) {
        return new DomXPathNSResolver(node2);
    }

    public Object evaluate(String string, Node node2, XPathNSResolver xPathNSResolver, short s, Object object) throws XPathException, DOMException {
        DomXPathExpression domXPathExpression = new DomXPathExpression(this, string, xPathNSResolver);
        return domXPathExpression.evaluate(node2, s, object);
    }

    private final /* synthetic */ void this() {
        this.checkingCharacters = true;
        this.checkingWellformedness = true;
        this.version = "1.0";
    }

    public DomDocument() {
        this(new DomImpl());
    }

    protected DomDocument(DOMImplementation dOMImplementation) {
        super((short)9, null);
        this.this();
        this.implementation = dOMImplementation;
    }
}

