require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_IBM4XX_PMAP_H_)) {
    eval 'sub _IBM4XX_PMAP_H_ () {1;}' unless defined(&_IBM4XX_PMAP_H_);
    if(defined(&_LOCORE)) {
	die("use\ assym\.h\ instead");
    }
    if(defined(&_MODULE)) {
	die("this\ file\ should\ not\ be\ included\ by\ loadable\ kernel\ modules");
    }
    require 'powerpc/ibm4xx/tlb.ph';
    eval 'sub KERNEL_PID () {1;}' unless defined(&KERNEL_PID);
    eval 'sub TTE_PA_MASK () {0xffffc000;}' unless defined(&TTE_PA_MASK);
    eval 'sub TTE_RPN_MASK {
        my($sz) = @_;
	    eval q((~((1<< (10+ 2* ($sz))) - 1)));
    }' unless defined(&TTE_RPN_MASK);
    eval 'sub TTE_ENDIAN () {0x2000;}' unless defined(&TTE_ENDIAN);
    eval 'sub TTE_SZ_MASK () {0x1c00;}' unless defined(&TTE_SZ_MASK);
    eval 'sub TTE_SZ_SHIFT () {10;}' unless defined(&TTE_SZ_SHIFT);
    eval 'sub TTE_SZ_16K () {( &TLB_SIZE_16K <<  &TTE_SZ_SHIFT);}' unless defined(&TTE_SZ_16K);
    eval 'sub TTE_SZ_64K () {( &TLB_SIZE_64K <<  &TTE_SZ_SHIFT);}' unless defined(&TTE_SZ_64K);
    eval 'sub TTE_SZ_256K () {( &TLB_SIZE_256K <<  &TTE_SZ_SHIFT);}' unless defined(&TTE_SZ_256K);
    eval 'sub TTE_SZ_1M () {( &TLB_SIZE_1M <<  &TTE_SZ_SHIFT);}' unless defined(&TTE_SZ_1M);
    eval 'sub TTE_SZ_4M () {( &TLB_SIZE_4M <<  &TTE_SZ_SHIFT);}' unless defined(&TTE_SZ_4M);
    eval 'sub TTE_SZ_16M () {( &TLB_SIZE_16M <<  &TTE_SZ_SHIFT);}' unless defined(&TTE_SZ_16M);
    eval 'sub TTE_EX () { &TLB_EX;}' unless defined(&TTE_EX);
    eval 'sub TTE_WR () { &TLB_WR;}' unless defined(&TTE_WR);
    eval 'sub TTE_ZSEL_MASK () { &TLB_ZSEL_MASK;}' unless defined(&TTE_ZSEL_MASK);
    eval 'sub TTE_ZSEL_SHFT () { &TLB_ZSEL_SHFT;}' unless defined(&TTE_ZSEL_SHFT);
    eval 'sub TTE_W () { &TLB_W;}' unless defined(&TTE_W);
    eval 'sub TTE_I () { &TLB_I;}' unless defined(&TTE_I);
    eval 'sub TTE_M () { &TLB_M;}' unless defined(&TTE_M);
    eval 'sub TTE_G () { &TLB_G;}' unless defined(&TTE_G);
    eval 'sub ZONE_PRIV () {0;}' unless defined(&ZONE_PRIV);
    eval 'sub ZONE_USER () {1;}' unless defined(&ZONE_USER);
    eval 'sub TTE_PA {
        my($p) = @_;
	    eval q((($p) &TTE_PA_MASK));
    }' unless defined(&TTE_PA);
    eval 'sub TTE_ZONE {
        my($z) = @_;
	    eval q( &TLB_ZONE($z));
    }' unless defined(&TTE_ZONE);
    eval 'sub PTSZ () {( &PAGE_SIZE / 4);}' unless defined(&PTSZ);
    eval 'sub PTMAP () {( &PTSZ *  &PAGE_SIZE);}' unless defined(&PTMAP);
    eval 'sub PTMSK () {(( &PTMAP - 1) & ~( &PGOFSET));}' unless defined(&PTMSK);
    eval 'sub PTIDX {
        my($v) = @_;
	    eval q(((($v) &  &PTMSK) >>  &PGSHIFT));
    }' unless defined(&PTIDX);
    eval 'sub STSZ () {((0xffffffff / ( &PAGE_SIZE *  &PTSZ)) + 1);}' unless defined(&STSZ);
    eval 'sub STMAP () {(0xffffffff);}' unless defined(&STMAP);
    eval 'sub STMSK () {(~( &PTMAP - 1));}' unless defined(&STMSK);
    eval 'sub STIDX {
        my($v) = @_;
	    eval q((($v) >> ( &PGSHIFT + 12)));
    }' unless defined(&STIDX);
    eval 'sub PME_NOCACHE () {0x1000000;}' unless defined(&PME_NOCACHE);
    eval 'sub PME_WRITETHROUG () {0x2000000;}' unless defined(&PME_WRITETHROUG);
    if(defined(&_KERNEL)) {
	eval 'sub PMAP_GROWKERNEL () {1;}' unless defined(&PMAP_GROWKERNEL);
	eval 'sub PMAP_ATTR_REF () {0x1;}' unless defined(&PMAP_ATTR_REF);
	eval 'sub PMAP_ATTR_CHG () {0x2;}' unless defined(&PMAP_ATTR_CHG);
	eval 'sub pmap_clear_modify {
	    my($pg) = @_;
    	    eval q(( &pmap_check_attr(($pg),  &PMAP_ATTR_CHG, 1)));
	}' unless defined(&pmap_clear_modify);
	eval 'sub pmap_clear_reference {
	    my($pg) = @_;
    	    eval q(( &pmap_check_attr(($pg),  &PMAP_ATTR_REF, 1)));
	}' unless defined(&pmap_clear_reference);
	eval 'sub pmap_is_modified {
	    my($pg) = @_;
    	    eval q(( &pmap_check_attr(($pg),  &PMAP_ATTR_CHG, 0)));
	}' unless defined(&pmap_is_modified);
	eval 'sub pmap_is_referenced {
	    my($pg) = @_;
    	    eval q(( &pmap_check_attr(($pg),  &PMAP_ATTR_REF, 0)));
	}' unless defined(&pmap_is_referenced);
	eval 'sub pmap_phys_address {
	    my($x) = @_;
    	    eval q(($x));
	}' unless defined(&pmap_phys_address);
	eval 'sub pmap_resident_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_wired_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{wired_count})));
	}' unless defined(&pmap_wired_count);
	eval 'sub vtophys {
	    my($va) = @_;
    	    eval q({  &paddr_t  &pa;  &if ( &pmap_extract( &pmap_kernel(), $va,  &pa))  &pa; $va; });
	}' unless defined(&vtophys);
    }
}
1;
