/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class BevelBorder
extends AbstractBorder {
    static final long serialVersionUID = -1034942243356299676L;
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int bevelType;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowOuter;
    protected Color shadowInner;

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        switch (this.bevelType) {
            case 0: {
                this.paintRaisedBevel(c, g, x, y, width, height);
                break;
            }
            case 1: {
                this.paintLoweredBevel(c, g, x, y, width, height);
                break;
            }
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(2, 2, 2, 2);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 2;
        insets.top = 2;
        insets.right = 2;
        insets.left = 2;
        return insets;
    }

    public Color getHighlightOuterColor(Component c) {
        if (this.highlightOuter != null) {
            return this.highlightOuter;
        }
        return this.getHighlightInnerColor(c).brighter();
    }

    public Color getHighlightInnerColor(Component c) {
        if (this.highlightInner != null) {
            return this.highlightInner;
        }
        return c.getBackground().brighter();
    }

    public Color getShadowInnerColor(Component c) {
        if (this.shadowInner != null) {
            return this.shadowInner;
        }
        return c.getBackground().darker();
    }

    public Color getShadowOuterColor(Component c) {
        if (this.shadowOuter != null) {
            return this.shadowOuter;
        }
        return this.getShadowInnerColor(c).darker();
    }

    public Color getHighlightOuterColor() {
        return this.highlightOuter;
    }

    public Color getHighlightInnerColor() {
        return this.highlightInner;
    }

    public Color getShadowInnerColor() {
        return this.shadowInner;
    }

    public Color getShadowOuterColor() {
        return this.shadowOuter;
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public boolean isBorderOpaque() {
        boolean bl = false;
        if (!(this.highlightOuter != null && this.highlightOuter.getAlpha() != 255 || this.highlightInner != null && this.highlightInner.getAlpha() != 255 || this.shadowInner != null && this.shadowInner.getAlpha() != 255 || this.shadowOuter != null && this.shadowOuter.getAlpha() != 255)) {
            bl = true;
        }
        return bl;
    }

    protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
        BevelBorder.paintBevel(g, x, y, width, height, this.getHighlightOuterColor(c), this.getHighlightInnerColor(c), this.getShadowInnerColor(c), this.getShadowOuterColor(c));
    }

    protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
        BevelBorder.paintBevel(g, x, y, width, height, this.getShadowInnerColor(c), this.getShadowOuterColor(c), this.getHighlightInnerColor(c), this.getHighlightOuterColor(c));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void paintBevel(Graphics g, int x, int y, int width, int height, Color a, Color b, Color c, Color d) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        --width;
        --height;
        try {
            g.setColor(a);
            g.drawLine(0, 0, width, 0);
            g.drawLine(0, 1, 0, height);
            g.setColor(b);
            g.drawLine(1, 1, width - 1, 1);
            g.drawLine(1, 2, 1, height - 1);
            g.setColor(c);
            g.drawLine(2, height - 1, width - 1, height - 1);
            g.drawLine(width - 1, 2, width - 1, height - 2);
            g.setColor(d);
            g.drawLine(1, height, width, height);
            g.drawLine(width, 1, width, height - 1);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            g.translate(-x, -y);
            g.setColor(oldColor);
            throw throwable;
        }
        {
            Object var11_12 = null;
            g.translate(-x, -y);
            g.setColor(oldColor);
            return;
        }
    }

    public BevelBorder(int bevelType) {
        if (bevelType != 0 && bevelType != 1) {
            throw new IllegalArgumentException();
        }
        this.bevelType = bevelType;
    }

    public BevelBorder(int bevelType, Color highlight, Color shadow) {
        this(bevelType, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public BevelBorder(int bevelType, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        this(bevelType);
        if (highlightOuter == null || highlightInner == null || shadowOuter == null || shadowInner == null) {
            throw new NullPointerException();
        }
        this.highlightOuter = highlightOuter;
        this.highlightInner = highlightInner;
        this.shadowOuter = shadowOuter;
        this.shadowInner = shadowInner;
    }
}

