/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import writer2latex.latex.style.I18n;
import writer2latex.latex.style.UnicodeTable;

class UnicodeTableHandler
extends DefaultHandler {
    private Hashtable tableSet;
    private UnicodeTable table;
    private String sSymbolSets;
    private boolean bGlobalReadThisSet;
    private boolean bReadThisSet;
    private int nGlobalFontencs = 0;
    private int nFontencs = 0;
    private boolean b8bit = false;

    UnicodeTableHandler(Hashtable tableSet, String sSymbolSets) {
        this.sSymbolSets = sSymbolSets;
        this.tableSet = tableSet;
    }

    public void startElement(String nameSpace, String localName, String qName, Attributes attributes) {
        block12: {
            block18: {
                block16: {
                    char c;
                    block17: {
                        block15: {
                            block14: {
                                block13: {
                                    block11: {
                                        if (!qName.equals("symbols")) break block11;
                                        this.table = new UnicodeTable(null);
                                        this.tableSet.put("root", this.table);
                                        break block12;
                                    }
                                    if (!qName.equals("symbol-set")) break block13;
                                    this.bReadThisSet = this.bGlobalReadThisSet = this.sSymbolSets.indexOf(attributes.getValue("name")) >= 0;
                                    this.nFontencs = this.nGlobalFontencs = I18n.readFontencs(attributes.getValue("fontenc"));
                                    break block12;
                                }
                                if (!qName.equals("special-symbol-set")) break block14;
                                this.table = new UnicodeTable((UnicodeTable)this.tableSet.get("root"));
                                this.tableSet.put(attributes.getValue("name"), this.table);
                                this.bReadThisSet = this.bGlobalReadThisSet = attributes.getValue("requires") == null || this.sSymbolSets.indexOf(attributes.getValue("requires")) >= 0;
                                this.b8bit = "true".equals(attributes.getValue("eight-bit"));
                                this.nFontencs = this.nGlobalFontencs = I18n.readFontencs(attributes.getValue("fontenc"));
                                break block12;
                            }
                            if (!qName.equals("symbol-subset")) break block15;
                            if (attributes.getValue("requires") != null) {
                                this.bReadThisSet = this.sSymbolSets.indexOf(attributes.getValue("requires")) >= 0;
                            }
                            this.nFontencs = I18n.readFontencs(attributes.getValue("fontenc"));
                            break block12;
                        }
                        if (!qName.equals("symbol")) break block16;
                        if (!this.bReadThisSet) break block12;
                        c = (char)Integer.parseInt(attributes.getValue("char"), 16);
                        String sEqChar = attributes.getValue("eq-char");
                        if (sEqChar == null) break block17;
                        char eqc = (char)Integer.parseInt(sEqChar, 16);
                        if (this.table.getCharType(eqc) != 3) {
                            this.table.addCharType(c, this.table.getCharType(eqc));
                        }
                        if (this.table.hasMathChar(eqc)) {
                            this.table.addMathChar(c, this.table.getMathChar(eqc));
                        }
                        if (this.table.hasTextChar(eqc)) {
                            this.table.addTextChar(c, this.table.getTextChar(eqc), this.table.getFontencs(eqc));
                        }
                        break block12;
                    }
                    String sType = attributes.getValue("char-type");
                    String sMath = attributes.getValue("math");
                    String sText = attributes.getValue("text");
                    if (sType != null) {
                        this.table.addCharType(c, sType);
                    }
                    if (sMath != null) {
                        this.table.addMathChar(c, sMath);
                    }
                    if (sText == null) break block12;
                    this.table.addTextChar(c, sText, this.nFontencs);
                    break block12;
                }
                if (!qName.equals("preserve-symbol")) break block18;
                if (!this.bReadThisSet) break block12;
                String sMode = attributes.getValue("mode");
                char c = (char)Integer.parseInt(attributes.getValue("char"), 16);
                this.table.addCharType(c, attributes.getValue("char-type"));
                if ("math".equals(sMode) || "both".equals(sMode)) {
                    this.table.addMathChar(c, Character.toString(c));
                }
                if (!"text".equals(sMode) && !"both".equals(sMode)) break block12;
                this.table.addTextChar(c, Character.toString(c), this.nFontencs);
                break block12;
            }
            if (qName.equals("preserve-symbols") && this.bReadThisSet) {
                String sMode = attributes.getValue("mode");
                String sType = attributes.getValue("char-type");
                char c1 = (char)Integer.parseInt(attributes.getValue("first-char"), 16);
                char c2 = (char)Integer.parseInt(attributes.getValue("last-char"), 16);
                boolean bMath = "math".equals(sMode) || "both".equals(sMode);
                boolean bText = "text".equals(sMode) || "both".equals(sMode);
                char c = c1;
                while (c <= c2) {
                    this.table.addCharType(c, sType);
                    if (bMath) {
                        this.table.addMathChar(c, Character.toString(c));
                    }
                    if (bText) {
                        this.table.addTextChar(c, Character.toString(c), this.nFontencs);
                    }
                    c = (char)(c + '\u0001');
                }
            }
        }
    }

    public void endElement(String nameSpace, String localName, String qName) {
        if (qName.equals("symbol-subset")) {
            this.bReadThisSet = this.bGlobalReadThisSet;
            this.nFontencs = this.nGlobalFontencs;
        } else if (qName.equals("special-symbol-set")) {
            if (this.b8bit) {
                this.table.table[0] = this.table.table[240];
            }
            this.b8bit = false;
        }
    }
}

