/*
 * Decompiled with CFR 0.152.
 */
package ints;

import ints.IntArray;
import ints.IntList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class UnsignedByteArray
implements IntArray {
    private final byte[] ba;

    public UnsignedByteArray(byte[] byArray) {
        this.ba = (byte[])byArray.clone();
    }

    public UnsignedByteArray(byte[] byArray, int n, int n2) {
        this.ba = Arrays.copyOfRange(byArray, n, n2);
    }

    public UnsignedByteArray(int[] nArray) {
        this(nArray, 0, nArray.length);
    }

    public UnsignedByteArray(IntList intList) {
        this(intList, 0, intList.size());
    }

    public UnsignedByteArray(int[] nArray, int n) {
        if (n < 1 || n > 256) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.ba = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0 || nArray[i] >= n) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            this.ba[i] = (byte)nArray[i];
        }
    }

    public UnsignedByteArray(IntList intList, int n) {
        if (n < 1 || n > 256) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.ba = new byte[intList.size()];
        for (int i = 0; i < this.ba.length; ++i) {
            int n2 = intList.get(i);
            if (n2 < 0 || n2 >= n) {
                throw new IllegalArgumentException(String.valueOf(n2));
            }
            this.ba[i] = (byte)n2;
        }
    }

    public UnsignedByteArray(int[] nArray, int n, int n2) {
        this.ba = new byte[n2 - n];
        for (int i = n; i < n2; ++i) {
            if (nArray[i] < 0 || nArray[i] > 255) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            this.ba[i - n] = (byte)nArray[i];
        }
    }

    public UnsignedByteArray(IntList intList, int n, int n2) {
        this.ba = new byte[n2 - n];
        for (int i = n; i < n2; ++i) {
            int n3 = intList.get(i);
            if (n3 < 0 || n3 > 255) {
                throw new IllegalArgumentException(String.valueOf(n3));
            }
            this.ba[i - n] = (byte)n3;
        }
    }

    public UnsignedByteArray(ByteArrayOutputStream byteArrayOutputStream) {
        this.ba = byteArrayOutputStream.toByteArray();
    }

    @Override
    public int size() {
        return this.ba.length;
    }

    @Override
    public int get(int n) {
        return this.ba[n] & 0xFF;
    }

    public String toString() {
        return IntArray.asString(this);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.ba);
    }
}

