/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    static final FlowStrategy sharedStrategy = new FlowStrategy();
    protected int layoutSpan;
    protected View layoutPool;
    protected FlowStrategy strategy = sharedStrategy;
    private boolean layoutDirty = true;

    public int getFlowAxis() {
        int n = this.getAxis();
        int n2 = n == 0 ? 1 : 0;
        return n2;
    }

    public int getFlowSpan(int n) {
        return this.layoutSpan;
    }

    public int getFlowStart(int n) {
        return this.getLeftInset();
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory viewFactory) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this.getElement(), this.getAxis());
            this.layoutPool.setParent(this);
        }
    }

    protected void layout(int n, int n2) {
        int n3 = this.getFlowAxis();
        if (n3 == 0) {
            if (this.layoutSpan != n) {
                this.layoutChanged(1);
                this.layoutSpan = n;
            }
        } else if (this.layoutSpan != n2) {
            this.layoutChanged(0);
            this.layoutSpan = n2;
        }
        if (this.layoutDirty) {
            this.strategy.layout(this);
            this.layoutDirty = false;
        }
        if (this.getPreferredSpan(this.getAxis()) != (float)n2) {
            this.preferenceChanged(this, false, true);
        }
        super.layout(n, n2);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.insertUpdate(documentEvent, shape, viewFactory);
        this.strategy.insertUpdate(this, documentEvent, this.getInsideAllocation(shape));
        this.layoutDirty = true;
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.strategy.removeUpdate(this, documentEvent, this.getInsideAllocation(shape));
        this.layoutDirty = true;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.strategy.changedUpdate(this, documentEvent, this.getInsideAllocation(shape));
        this.layoutDirty = true;
    }

    protected int getViewIndexAtPosition(int n) {
        if (!this.isAllocationValid()) {
            this.layout(this.getWidth(), this.getHeight());
        }
        int n2 = this.getViewCount();
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            View view = this.getView(n4);
            int n5 = view.getStartOffset();
            int n6 = view.getEndOffset();
            if (n5 <= n && n6 > n) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        return n3;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
        sizeRequirements2.minimum = (int)this.layoutPool.getMinimumSpan(n);
        sizeRequirements2.preferred = (int)this.layoutPool.getPreferredSpan(n);
        sizeRequirements2.maximum = (int)this.layoutPool.getMaximumSpan(n);
        return sizeRequirements2;
    }

    public FlowView(Element element, int n) {
        super(element, n);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LogicalView
    extends BoxView {
        LogicalView(Element element, int n) {
            super(element, n);
        }
    }

    public static class FlowStrategy {
        public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        }

        public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        }

        public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        }

        protected View getLogicalView(FlowView flowView) {
            return flowView.layoutPool;
        }

        public void layout(FlowView flowView) {
            flowView.removeAll();
            Element element = flowView.getElement();
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            int n3 = 0;
            while (n >= 0 && n < n2) {
                View view = flowView.createRow();
                flowView.append(view);
                n = this.layoutRow(flowView, n3, n);
                ++n3;
            }
        }

        protected int layoutRow(FlowView flowView, int n, int n2) {
            int n3;
            int n4;
            View view = flowView.getView(n);
            int n5 = flowView.getFlowAxis();
            int n6 = flowView.getFlowSpan(n);
            int n7 = flowView.getFlowStart(n);
            int n8 = n2;
            View view2 = this.getLogicalView(flowView);
            if (n6 == 0) {
                n6 = Integer.MAX_VALUE;
            }
            while (n6 > 0) {
                View view3;
                if (view2.getViewIndex(n8, Position.Bias.Forward) == -1 || (view3 = this.createView(flowView, n8, n6, n)) == null) break;
                n4 = (int)view3.getPreferredSpan(n5);
                view.append(view3);
                n3 = view3.getBreakWeight(n5, n7, n6);
                if (n3 >= 3000) break;
                n7 += n4;
                n6 -= n4;
                n8 += view3.getEndOffset() - view3.getStartOffset();
            }
            if (n6 < 0) {
                int n9 = flowView.getFlowStart(n5);
                n4 = flowView.getFlowSpan(n5);
                this.adjustRow(flowView, n, n4, n9);
                n3 = view.getViewCount();
                n8 = n3 > 0 ? view.getView(n3 - 1).getEndOffset() : -1;
            }
            return n8 != n2 ? n8 : -1;
        }

        protected View createView(FlowView flowView, int n, int n2, int n3) {
            View view = this.getLogicalView(flowView);
            int n4 = view.getViewIndex(n, Position.Bias.Forward);
            View view2 = null;
            if (n4 >= 0 && (view2 = view.getView(n4)).getStartOffset() != n) {
                view2 = view2.createFragment(n, view2.getEndOffset());
            }
            return view2;
        }

        protected void adjustRow(FlowView flowView, int n, int n2, int n3) {
            View view;
            int n4 = flowView.getFlowAxis();
            View view2 = flowView.getView(n);
            int n5 = view2.getViewCount();
            int n6 = -1;
            int n7 = 0;
            int n8 = n3;
            int n9 = n2;
            int n10 = n3;
            int n11 = n2;
            int n12 = 0;
            while (n12 < n5) {
                view = view2.getView(n12);
                int n13 = view.getBreakWeight(n4, n10, n11);
                if (n13 >= n7) {
                    n6 = n12;
                    n8 = n10;
                    n9 = n11;
                    n7 = n13;
                }
                int n14 = (int)view.getPreferredSpan(n4);
                n10 += n14;
                n11 -= n14;
                ++n12;
            }
            if (n6 > -1) {
                View view3 = view2.getView(n6);
                view = view3.breakView(n4, view3.getStartOffset(), n8, n9);
                view2.replace(n6, n5 - n6, new View[]{view});
            }
        }
    }
}

