/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JLayeredPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 5534920399324590459L;
    public static final String LAYER_PROPERTY = "layeredContainerLayer";
    public static Integer FRAME_CONTENT_LAYER = new Integer(-30000);
    public static Integer DEFAULT_LAYER = new Integer(0);
    public static Integer PALETTE_LAYER = new Integer(100);
    public static Integer MODAL_LAYER = new Integer(200);
    public static Integer POPUP_LAYER = new Integer(300);
    public static Integer DRAG_LAYER = new Integer(400);
    TreeMap layers = new TreeMap();
    Hashtable componentToLayer = new Hashtable();
    static /* synthetic */ Class class$javax$swing$JLayeredPane;

    public int getLayer(Component c) {
        Component myComp = c;
        while (!this.componentToLayer.containsKey(myComp)) {
            if ((myComp = myComp.getParent()) == null) break;
        }
        if (myComp == null) {
            throw new IllegalArgumentException("component is not in this JLayeredPane");
        }
        Integer layerObj = (Integer)this.componentToLayer.get(myComp);
        return layerObj;
    }

    public static int getLayer(JComponent comp) {
        JLayeredPane lp;
        Class clazz = class$javax$swing$JLayeredPane;
        if (clazz == null) {
            clazz = class$javax$swing$JLayeredPane = JLayeredPane.class("[Ljavax.swing.JLayeredPane;", false);
        }
        if ((lp = (JLayeredPane)SwingUtilities.getAncestorOfClass(clazz, comp)) == null) {
            return 0;
        }
        return lp.getLayer(comp);
    }

    public static JLayeredPane getLayeredPaneAbove(Component comp) {
        Class clazz = class$javax$swing$JLayeredPane;
        if (clazz == null) {
            clazz = class$javax$swing$JLayeredPane = JLayeredPane.class("[Ljavax.swing.JLayeredPane;", false);
        }
        JLayeredPane lp = (JLayeredPane)SwingUtilities.getAncestorOfClass(clazz, comp);
        return lp;
    }

    private final int[] layerToRange(Integer layer) {
        int[] ret = new int[2];
        ret[1] = this.getComponents().length;
        Iterator i = this.layers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry pair = (Map.Entry)i.next();
            Integer layerNum = (Integer)pair.getKey();
            Integer layerSz = (Integer)pair.getValue();
            if (layerNum.intValue() == layer.intValue()) {
                ret[0] = ret[1] - layerSz;
                return ret;
            }
            ret[1] = ret[1] - layerSz;
        }
        throw new IllegalArgumentException();
    }

    private final void incrLayer(Integer layer) {
        int sz = 1;
        if (this.layers.containsKey(layer)) {
            sz += ((Integer)this.layers.get(layer)).intValue();
        }
        this.layers.put(layer, new Integer(sz));
    }

    private final void decrLayer(Integer layer) {
        int sz = 0;
        if (this.layers.containsKey(layer)) {
            sz = (Integer)this.layers.get(layer) - 1;
        }
        this.layers.put(layer, new Integer(sz));
    }

    public int highestLayer() {
        if (this.layers.size() == 0) {
            return 0;
        }
        return (Integer)this.layers.lastKey();
    }

    public int lowestLayer() {
        if (this.layers.size() == 0) {
            return 0;
        }
        return (Integer)this.layers.firstKey();
    }

    public void moveToFront(Component c) {
        this.setPosition(c, 0);
    }

    public void moveToBack(Component c) {
        this.setPosition(c, -1);
    }

    public int getPosition(Component c) {
        int layer = this.getLayer(c);
        int[] range = this.layerToRange(new Integer(layer));
        int top = range[0];
        int bot = range[1];
        Component[] comps = this.getComponents();
        int i = top;
        while (i < bot) {
            if (comps[i] == c) {
                return i - top;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public void setPosition(Component c, int position) {
        int layer = this.getLayer(c);
        int[] range = this.layerToRange(new Integer(layer));
        if (range[0] == range[1]) {
            throw new IllegalArgumentException();
        }
        int top = range[0];
        int bot = range[1];
        if (position == -1) {
            position = bot - top - 1;
        }
        int targ = Math.min(top + position, bot - 1);
        int curr = -1;
        Component[] comps = this.getComponents();
        int i = top;
        while (i < bot) {
            if (comps[i] == c) {
                curr = i;
                break;
            }
            ++i;
        }
        if (curr == -1) {
            throw new IllegalArgumentException();
        }
        super.swapComponents(curr, targ);
        this.revalidate();
        this.repaint();
    }

    public Component[] getComponentsInLayer(int layer) {
        int[] range = this.layerToRange(this.getObjectForLayer(layer));
        if (range[0] == range[1]) {
            return new Component[0];
        }
        Component[] comps = this.getComponents();
        int sz = range[1] - range[0];
        Component[] nc = new Component[sz];
        int i = 0;
        while (i < sz) {
            nc[i] = comps[range[0] + i];
            ++i;
        }
        return nc;
    }

    public int getComponentCountInLayer(int layer) {
        int[] range = this.layerToRange(this.getObjectForLayer(layer));
        if (range[0] == range[1]) {
            return 0;
        }
        return range[1] - range[0];
    }

    protected Hashtable getComponentToLayer() {
        return this.componentToLayer;
    }

    public int getIndexOf(Component c) {
        int layer = this.getLayer(c);
        int[] range = this.layerToRange(new Integer(layer));
        Component[] comps = this.getComponents();
        int i = range[0];
        while (i < range[1]) {
            if (comps[i] == c) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected Integer getObjectForLayer(int layer) {
        switch (layer) {
            case -30000: {
                return FRAME_CONTENT_LAYER;
            }
            case 0: {
                return DEFAULT_LAYER;
            }
            case 100: {
                return PALETTE_LAYER;
            }
            case 200: {
                return MODAL_LAYER;
            }
            case 300: {
                return POPUP_LAYER;
            }
            case 400: {
                return DRAG_LAYER;
            }
        }
        return new Integer(layer);
    }

    protected int insertIndexForLayer(int layer, int position) {
        int[] range;
        Integer lobj = this.getObjectForLayer(layer);
        if (!this.layers.containsKey(lobj)) {
            this.layers.put(lobj, new Integer(0));
        }
        if ((range = this.layerToRange(lobj))[0] == range[1]) {
            return range[0];
        }
        int top = range[0];
        int bot = range[1];
        if (position == -1 || position > bot - top) {
            return bot;
        }
        return top + position;
    }

    public void remove(int index) {
        Component c = this.getComponent(index);
        int layer = this.getLayer(c);
        this.decrLayer(new Integer(layer));
        this.componentToLayer.remove(c);
        super.remove(index);
        this.revalidate();
    }

    public void setLayer(Component c, int layer) {
        this.componentToLayer.put(c, this.getObjectForLayer(layer));
    }

    public void setLayer(Component c, int layer, int position) {
        this.remove(c);
        this.add(c, this.getObjectForLayer(layer));
        this.setPosition(c, position);
        this.revalidate();
        this.repaint();
    }

    protected void addImpl(Component comp, Object layerConstraint, int index) {
        Integer layer = layerConstraint != null && layerConstraint instanceof Integer ? (Integer)layerConstraint : (this.componentToLayer.containsKey(comp) ? (Integer)this.componentToLayer.remove(comp) : DEFAULT_LAYER);
        int newIdx = this.insertIndexForLayer(layer, index);
        this.componentToLayer.put(comp, layer);
        this.incrLayer(layer);
        super.addImpl(comp, null, newIdx);
    }

    public static void putLayer(JComponent component, int layer) {
        JLayeredPane.getLayeredPaneAbove(component).setLayer(component, layer);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLayeredPane();
        }
        return this.accessibleContext;
    }

    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g);
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JLayeredPane() {
        this.setLayout(null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJLayeredPane
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LAYERED_PANE;
        }
    }
}

