/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.ColoredPiecePainter;
import free.chess.Piece;
import java.awt.Color;

public abstract class AbstractColoredPiecePainter
implements ColoredPiecePainter {
    private Color whiteColor;
    private Color blackColor;
    private Color whiteOutline;
    private Color blackOutline;

    public AbstractColoredPiecePainter() {
        this(Color.white, Color.black);
    }

    public AbstractColoredPiecePainter(Color color, Color color2) {
        this(color, color2, AbstractColoredPiecePainter.getReversed(color), AbstractColoredPiecePainter.getReversed(color2));
    }

    public AbstractColoredPiecePainter(Color color, Color color2, Color color3, Color color4) {
        if (color == null) {
            throw new IllegalArgumentException("Null white color");
        }
        if (color2 == null) {
            throw new IllegalArgumentException("Null black color");
        }
        if (color3 == null) {
            throw new IllegalArgumentException("Null white outline color");
        }
        if (color4 == null) {
            throw new IllegalArgumentException("Null black outline color");
        }
        this.whiteColor = color;
        this.blackColor = color2;
        this.whiteOutline = color3;
        this.blackOutline = color4;
    }

    private static Color getReversed(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public Color getWhiteColor() {
        return this.whiteColor;
    }

    public void setWhiteColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Null color");
        }
        this.whiteColor = color;
    }

    public Color getBlackColor() {
        return this.blackColor;
    }

    public void setBlackColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Null color");
        }
        this.blackColor = color;
    }

    public Color getWhiteOutline() {
        return this.whiteOutline;
    }

    public void setWhiteOutline(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Null color");
        }
        this.whiteOutline = color;
    }

    public Color getBlackOutline() {
        return this.blackOutline;
    }

    public void setBlackOutline(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Null color");
        }
        this.blackOutline = color;
    }

    public Color getPieceColor(Piece piece, boolean bl) {
        if (piece == null) {
            return null;
        }
        Color color = piece.isWhite() ? this.getWhiteColor() : this.getBlackColor();
        return bl ? this.getShaded(color) : color;
    }

    public Color getOutlineColor(Piece piece, boolean bl) {
        if (piece == null) {
            return null;
        }
        Color color = piece.isWhite() ? this.getWhiteOutline() : this.getBlackOutline();
        return bl ? this.getShaded(color) : color;
    }

    protected Color getShaded(Color color) {
        int n = (color.getRed() + 256) / 3;
        int n2 = (color.getGreen() + 256) / 3;
        int n3 = (color.getBlue() + 256) / 3;
        return new Color(n, n2, n3);
    }
}

