/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.jar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class Connection
extends JarURLConnection {
    private JarFile jar_file;
    private JarEntry jar_entry;
    private URL jar_url;

    public final synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.jar_url = this.getJarFileURL();
        this.jar_file = JarFileCache.get(this.jar_url, this.useCaches);
        String entry_name = this.getEntryName();
        if (entry_name != null && !entry_name.equals("")) {
            this.jar_entry = (JarEntry)this.jar_file.getEntry(entry_name);
            if (this.jar_entry == null) {
                throw new IOException("No entry for " + entry_name + " exists.");
            }
        }
        this.connected = true;
    }

    public final InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        if (this.jar_entry == null) {
            throw new IOException(this.jar_url + " couldn't be found.");
        }
        return this.jar_file.getInputStream(this.jar_entry);
    }

    public final synchronized JarFile getJarFile() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open JarFile if doInput is false");
        }
        return this.jar_file;
    }

    public final int getContentLength() {
        if (!this.connected) {
            return -1;
        }
        return (int)this.jar_entry.getSize();
    }

    protected Connection(URL url) throws MalformedURLException {
        super(url);
    }

    public static class JarFileCache {
        private static Hashtable cache = new Hashtable();
        private static final int READBUFSIZE = 4096;

        public static synchronized JarFile get(URL url, boolean useCaches) throws IOException {
            JarFile jf;
            if (useCaches && (jf = (JarFile)cache.get(url)) != null) {
                return jf;
            }
            if ("file".equals(url.getProtocol())) {
                File f = new File(url.getFile());
                jf = new JarFile(f, true, 1);
            } else {
                URLConnection urlconn = url.openConnection();
                InputStream is = urlconn.getInputStream();
                byte[] buf = new byte[4096];
                File f = File.createTempFile("cache", "jar");
                FileOutputStream fos = new FileOutputStream(f);
                int len = 0;
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                jf = new JarFile(f, true, 5);
            }
            if (useCaches) {
                cache.put(url, jf);
            }
            return jf;
        }
    }
}

