/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.html2;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.html2.DomHTMLCollection;
import gnu.xml.dom.html2.DomHTMLDocument;
import gnu.xml.dom.html2.DomHTMLElement;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLFormElement;
import org.w3c.dom.html2.HTMLOptionElement;
import org.w3c.dom.html2.HTMLOptionsCollection;
import org.w3c.dom.html2.HTMLSelectElement;

public class DomHTMLSelectElement
extends DomHTMLElement
implements HTMLSelectElement {
    public String getType() {
        return this.getHTMLAttribute("type");
    }

    public int getSelectedIndex() {
        HTMLOptionsCollection options = this.getOptions();
        int len = options.getLength();
        int i = 0;
        while (i < len) {
            HTMLOptionElement option = (HTMLOptionElement)options.item(i);
            if (option.getSelected()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setSelectedIndex(int selectedIndex) {
        HTMLOptionsCollection options = this.getOptions();
        int len = options.getLength();
        if (selectedIndex < 0 || selectedIndex >= len) {
            throw new DomDOMException(1);
        }
        int i = 0;
        while (i < len) {
            HTMLOptionElement option = (HTMLOptionElement)options.item(i);
            boolean bl = false;
            if (i == selectedIndex) {
                bl = true;
            }
            option.setSelected(bl);
            ++i;
        }
    }

    public String getValue() {
        return this.getHTMLAttribute("value");
    }

    public void setValue(String value) {
        this.setHTMLAttribute("value", value);
    }

    public int getLength() {
        return this.getIntHTMLAttribute("length");
    }

    public void setLength(int length) {
        this.setIntHTMLAttribute("length", length);
    }

    public HTMLFormElement getForm() {
        return (HTMLFormElement)this.getParentElement("form");
    }

    public HTMLOptionsCollection getOptions() {
        DomHTMLCollection ret = new DomHTMLCollection((DomHTMLDocument)this.getOwnerDocument(), this);
        ret.addNodeName("option");
        ret.evaluate();
        return ret;
    }

    public boolean getDisabled() {
        return this.getBooleanHTMLAttribute("disabled");
    }

    public void setDisabled(boolean disabled) {
        this.setBooleanHTMLAttribute("disabled", disabled);
    }

    public boolean getMultiple() {
        return this.getBooleanHTMLAttribute("multiple");
    }

    public void setMultiple(boolean multiple) {
        this.setBooleanHTMLAttribute("multiple", multiple);
    }

    public String getName() {
        return this.getHTMLAttribute("name");
    }

    public void setName(String name) {
        this.setHTMLAttribute("name", name);
    }

    public int getSize() {
        return this.getIntHTMLAttribute("size");
    }

    public void setSize(int size) {
        this.setIntHTMLAttribute("size", size);
    }

    public int getTabIndex() {
        return this.getIntHTMLAttribute("tabindex");
    }

    public void setTabIndex(int tabIndex) {
        this.setIntHTMLAttribute("tabindex", tabIndex);
    }

    public void add(HTMLElement element, HTMLElement before) {
        this.insertBefore(before, element);
    }

    public void remove(int index) {
        HTMLOptionsCollection options = this.getOptions();
        int len = options.getLength();
        if (index < 0 || index >= len) {
            throw new DomDOMException(1);
        }
        HTMLOptionElement option = (HTMLOptionElement)options.item(index);
        option.getParentNode().removeChild(option);
    }

    public void blur() {
        this.dispatchUIEvent("blur");
    }

    public void focus() {
        this.dispatchUIEvent("focus");
    }

    protected DomHTMLSelectElement(DomHTMLDocument owner, String namespaceURI, String name) {
        super(owner, namespaceURI, name);
    }
}

